/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.xmlsec.wss.impl.KrbParser;

public class KrbDecryptor {
    public static void removeMSBits(byte[] block) {
        int i = 0;
        while (i < block.length) {
            int n = i++;
            block[n] = (byte)(block[n] << 1);
        }
    }

    public static byte reverse7bits(byte bt) {
        byte rbt = 0;
        for (int i = 1; i < 8; ++i) {
            byte bit = (byte)((bt & 1 << i) >> i);
            rbt = (byte)(rbt | (byte)(bit << 8 - i));
        }
        return rbt;
    }

    public static void reverse7bitbytes(byte[] block) {
        int i;
        for (i = 0; i < block.length / 2; ++i) {
            byte b1 = KrbDecryptor.reverse7bits(block[i]);
            byte b2 = KrbDecryptor.reverse7bits(block[block.length - i - 1]);
            block[block.length - i - 1] = b1;
            block[i] = b2;
        }
        if (block.length % 2 == 1) {
            i = (block.length + 1) / 2;
            block[i] = KrbDecryptor.reverse7bits(block[i]);
        }
    }

    public static void addOddParityInLSB(byte[] block) {
        for (int i = 0; i < block.length; ++i) {
            int count = 0;
            byte b = block[i];
            for (int j = 0; j < 8; ++j) {
                if ((b & 1 << j) == 0) continue;
                ++count;
            }
            if (count & true) continue;
            int n = i;
            block[n] = (byte)(block[n] ^ 1);
        }
    }

    public static byte[] computeDES_CBC_check(byte[] block, byte[] tempKey) {
        try {
            SecretKeyFactory kf = SecretKeyFactory.getInstance("DES");
            SecretKey desKey = kf.generateSecret(new DESKeySpec(tempKey));
            Cipher c = Cipher.getInstance("DES/CBC/NoPadding");
            byte[] iv = new byte[8];
            for (int i = 0; i < 8; ++i) {
                iv[i] = 0;
            }
            c.init(1, (Key)desKey, new IvParameterSpec(tempKey));
            byte[] out = c.doFinal(block);
            byte[] checksum = new byte[8];
            System.arraycopy(out, out.length - 8, checksum, 0, 8);
            return checksum;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (BadPaddingException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InvalidKeySpecException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static void xorWith(byte[] block, byte[] block2) {
        for (int i = 0; i < block.length; ++i) {
            int n = i;
            block[n] = (byte)(block[n] ^ block2[i]);
        }
    }

    public static byte[] mit_des_string_to_key(char[] str, String salt) {
        boolean odd = true;
        byte[] s1 = null;
        try {
            s1 = (new String(str) + salt).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] s = new byte[(s1.length + 7) / 8 * 8];
        for (int i = 0; i < s.length; ++i) {
            s[i] = 0;
        }
        System.arraycopy(s1, 0, s, 0, s1.length);
        byte[] tempString = new byte[8];
        for (int i = 0; i < 8; ++i) {
            tempString[i] = 0;
        }
        int n = s.length / 8;
        byte[] block = new byte[8];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(s, i * 8, block, 0, 8);
            KrbDecryptor.removeMSBits(block);
            if (!odd) {
                KrbDecryptor.reverse7bitbytes(block);
            }
            odd = !odd;
            KrbDecryptor.xorWith(tempString, block);
        }
        KrbDecryptor.addOddParityInLSB(tempString);
        try {
            if (DESKeySpec.isWeak(tempString, 0)) {
                tempString[7] = (byte)(tempString[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException i) {
            // empty catch block
        }
        byte[] key = KrbDecryptor.computeDES_CBC_check(s, tempString);
        KrbDecryptor.addOddParityInLSB(key);
        try {
            if (DESKeySpec.isWeak(tempString, 0)) {
                tempString[7] = (byte)(tempString[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return key;
    }

    public static byte[] stringToKey(char[] passwd, String salt, int etype) {
        if (etype == 1 || etype == 2 || etype == 3) {
            return KrbDecryptor.mit_des_string_to_key(passwd, salt);
        }
        if (etype == 23 || etype == 24) {
            try {
                byte[] p = new String(passwd).getBytes("UTF-16LE");
                MessageDigest md = MessageDigest.getInstance((AlgorithmIdentifier)AlgID.md4);
                return md.computeDigest(p);
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalArgumentException(ex);
            }
            catch (AlgorithmIdentifierException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return null;
    }

    public static EncryptionKey passwdToKey(char[] passwd, String principal, int etype) {
        StringBuilder buf = new StringBuilder();
        int i = principal.lastIndexOf(64);
        if (i > -1) {
            buf.append(principal.substring(i + 1));
            principal = principal.substring(0, i);
        }
        String[] components = principal.split("\\/");
        for (i = 0; i < components.length; ++i) {
            buf.append(components[i]);
        }
        byte[] key = KrbDecryptor.stringToKey(passwd, buf.toString(), etype);
        return new EncryptionKey(etype, key);
    }

    public static void rotr(byte[] X, int s) {
        byte[] X2 = new byte[X.length];
        System.arraycopy(X, 0, X2, 0, X.length);
        int j = s / 8 % X.length;
        for (int i = 0; i < X.length; ++i) {
            X[j] = X2[i];
            j = (j + 1) % X.length;
        }
        int k = s % 8;
        if (k == 0) {
            return;
        }
        System.arraycopy(X, 0, X2, 0, X.length);
        int j2 = 1 % X.length;
        for (int i = 0; i < X.length; ++i) {
            int b1 = 0xFF & X2[i];
            int b2 = 0xFF & X2[j2];
            X[j2] = (byte)(b1 << 8 - k | b2 >> k);
            j2 = (j2 + 1) % X.length;
        }
    }

    public static void addTo(byte[] a, byte[] b) {
        int s;
        int i;
        int c = 0;
        for (i = a.length - 1; i >= 0; --i) {
            s = (0xFF & b[i]) + (0xFF & a[i]) + c;
            c = s >> 8;
            a[i] = (byte)s;
        }
        if (c == 0) {
            return;
        }
        for (i = a.length - 1; i >= 0; --i) {
            s = (0xFF & a[i]) + c;
            c = s >> 8;
            a[i] = (byte)s;
        }
    }

    public static byte[] nFold(byte[] X, int n) {
        if (X.length == n) {
            return X;
        }
        int a = X.length;
        int b = n;
        while (b != 0) {
            int t = b;
            b = a % b;
            a = t;
        }
        int lcm = X.length * n / a;
        byte[] concat = new byte[lcm];
        byte[] X2 = new byte[X.length];
        System.arraycopy(X, 0, X2, 0, X.length);
        for (int i = 0; i < lcm / X2.length; ++i) {
            System.arraycopy(X2, 0, concat, i * X2.length, X2.length);
            KrbDecryptor.rotr(X2, 13);
        }
        byte[] output = new byte[n];
        byte[] t = new byte[n];
        for (int i = 0; i < lcm / n; ++i) {
            System.arraycopy(concat, i * n, t, 0, n);
            KrbDecryptor.addTo(output, t);
        }
        return output;
    }

    public static byte[] des3randomToKey(byte[] random) {
        int i;
        byte[] key = new byte[24];
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 7; ++j) {
                key[i * 8 + j] = (byte)(random[i * 7 + j] & 0xFE);
                int n = i * 8 + 7;
                key[n] = (byte)(key[n] | (byte)((random[i * 7 + j] & 1) << j + 1));
            }
        }
        for (i = 0; i < 24; ++i) {
            byte a = key[i];
            int b = a >> 7 ^ a >> 6 ^ a >> 5 ^ a >> 4 ^ a >> 3 ^ a >> 2 ^ a >> 1;
            key[i] = (byte)((a | 1) ^ b & 1);
        }
        for (i = 0; i < 3; ++i) {
            try {
                if (!DESKeySpec.isWeak(key, i * 8)) continue;
                int n = i * 8 + 7;
                key[n] = (byte)(key[n] ^ 0xF0);
                continue;
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
        }
        return key;
    }

    public static byte[] deriveRandom(byte[] baseKey, byte[] constant, String algorithm, int k) throws ASN1FormatException {
        try {
            int kl;
            int ki;
            byte[] keyMaterial = new byte[k];
            Cipher c = Cipher.getInstance(algorithm + "/CBC/NoPadding");
            byte[] iv = new byte[c.getBlockSize()];
            SecretKeySpec baseKey1 = new SecretKeySpec(baseKey, algorithm);
            c.init(1, (Key)baseKey1, new IvParameterSpec(iv));
            byte[] constant2 = KrbDecryptor.nFold(constant, c.getBlockSize());
            byte[] enc = c.doFinal(constant2);
            System.arraycopy(enc, 0, keyMaterial, 0, ki);
            for (ki = Math.min(enc.length, keyMaterial.length); ki < k; ki += kl) {
                c.init(1, (Key)baseKey1, new IvParameterSpec(iv));
                enc = c.doFinal(enc);
                kl = Math.min(enc.length, keyMaterial.length - ki);
                System.arraycopy(enc, 0, keyMaterial, ki, kl);
            }
            return keyMaterial;
        }
        catch (NoSuchAlgorithmException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
        catch (NoSuchPaddingException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
        catch (InvalidKeyException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
        catch (BadPaddingException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
        catch (IllegalBlockSizeException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
        catch (InvalidAlgorithmParameterException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
    }

    public static void xor(byte[] src1, int src1Offset, byte[] src2, int src2Offset, byte[] dest, int destOffset, int length) {
        for (int i = 0; i < length; ++i) {
            dest[destOffset + i] = (byte)(src1[src1Offset + i] ^ src2[src2Offset + i]);
        }
    }

    public static byte[] aesCtsEncrypt(byte[] plaintext, SecretKey key) throws ASN1FormatException {
        try {
            Cipher c = Cipher.getInstance("AES/CBC/NoPadding");
            int b = c.getBlockSize();
            int padSize = c.getBlockSize() - plaintext.length % b;
            if (padSize == b) {
                padSize = 0;
            }
            byte[] plaintext2 = new byte[plaintext.length + padSize];
            System.arraycopy(plaintext, 0, plaintext2, 0, plaintext.length);
            byte[] iv = new byte[b];
            c.init(1, (Key)key, new IvParameterSpec(iv));
            byte[] cipherText = c.doFinal(plaintext2);
            int numBlocks = plaintext2.length / c.getBlockSize();
            if (numBlocks > 1) {
                byte[] Xn1 = new byte[b];
                if (numBlocks > 2) {
                    KrbDecryptor.xor(plaintext2, plaintext2.length - b * 2, cipherText, cipherText.length - b * 3, Xn1, 0, b);
                } else {
                    KrbDecryptor.xor(plaintext2, plaintext2.length - b * 2, iv, 0, Xn1, 0, b);
                }
                c = Cipher.getInstance("AES/ECB/NoPadding");
                c.init(1, key);
                byte[] En1 = c.doFinal(Xn1);
                System.arraycopy(En1, 0, cipherText, cipherText.length - b, b);
                byte[] Dn = new byte[b];
                KrbDecryptor.xor(plaintext2, plaintext2.length - b, En1, 0, Dn, 0, b);
                c.init(1, key);
                byte[] En = c.doFinal(Dn);
                System.arraycopy(En, 0, cipherText, cipherText.length - b * 2, b);
            }
            byte[] cipherText2 = new byte[plaintext.length];
            System.arraycopy(cipherText, 0, cipherText2, 0, plaintext.length);
            return cipherText2;
        }
        catch (NoSuchAlgorithmException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
        catch (NoSuchPaddingException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
        catch (InvalidKeyException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
        catch (BadPaddingException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
        catch (IllegalBlockSizeException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
        catch (InvalidAlgorithmParameterException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
    }

    public static byte[] aesCtsDecrypt(byte[] ciphertext, SecretKey key) throws ASN1FormatException {
        try {
            Cipher c = Cipher.getInstance("AES/CBC/NoPadding");
            int b = c.getBlockSize();
            int padSize = c.getBlockSize() - ciphertext.length % b;
            if (padSize == b) {
                padSize = 0;
            }
            byte[] ciphertext2 = new byte[ciphertext.length + padSize];
            System.arraycopy(ciphertext, 0, ciphertext2, 0, ciphertext.length);
            byte[] iv = new byte[b];
            c.init(2, (Key)key, new IvParameterSpec(iv));
            byte[] plaintext = c.doFinal(ciphertext2);
            int numBlocks = ciphertext2.length / c.getBlockSize();
            if (numBlocks > 1) {
                c = Cipher.getInstance("AES/ECB/NoPadding");
                c.init(2, key);
                byte[] Dn = c.doFinal(ciphertext2, ciphertext2.length - b * 2, b);
                byte[] Xn = new byte[b];
                KrbDecryptor.xor(Dn, 0, ciphertext2, ciphertext2.length - b, Xn, 0, b);
                System.arraycopy(Xn, 0, plaintext, plaintext.length - b, b);
                byte[] En = new byte[b];
                System.arraycopy(ciphertext2, ciphertext2.length - b, En, 0, b - padSize);
                System.arraycopy(Xn, b - padSize, En, b - padSize, padSize);
                c.init(2, key);
                byte[] Xn1 = c.doFinal(En);
                if (numBlocks > 2) {
                    KrbDecryptor.xor(Xn1, 0, ciphertext2, ciphertext2.length - b * 3, plaintext, plaintext.length - b * 2, b);
                } else {
                    KrbDecryptor.xor(Xn1, 0, iv, 0, plaintext, plaintext.length - b * 2, b);
                }
            }
            byte[] plaintext2 = new byte[ciphertext.length];
            System.arraycopy(plaintext, 0, plaintext2, 0, ciphertext.length);
            return plaintext2;
        }
        catch (NoSuchAlgorithmException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
        catch (NoSuchPaddingException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
        catch (InvalidKeyException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
        catch (BadPaddingException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
        catch (IllegalBlockSizeException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
        catch (InvalidAlgorithmParameterException e) {
            ASN1FormatException ae = new ASN1FormatException("Decryption problem");
            ae.initCause((Throwable)e);
            throw ae;
        }
    }

    public static EncryptionKey[] getEncryptionKeysForSubject(Subject s) {
        ArrayList<EncryptionKey> encKey = new ArrayList<EncryptionKey>();
        Set<KerberosKey> skeys = s.getPrivateCredentials(KerberosKey.class);
        for (KerberosKey k : skeys) {
            encKey.add(new EncryptionKey(k));
        }
        return encKey.toArray(new EncryptionKey[0]);
    }

    public static EncryptionKey getTGTSessionKey(Subject s) {
        Set<KerberosTicket> stkts = s.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket tkt : stkts) {
            if (!tkt.getServer().getName().contains("tgt")) continue;
            SecretKey k = tkt.getSessionKey();
            return new EncryptionKey(0, k.getEncoded());
        }
        return null;
    }

    public static class EncryptionKey
    implements SecretKey,
    Destroyable {
        int keyType;
        byte[] keyBytes;

        public EncryptionKey(KerberosKey k) {
            this.keyType = k.getKeyType();
            this.keyBytes = k.getEncoded();
        }

        public EncryptionKey(int keyType, byte[] keyBytes) {
            this.keyType = keyType;
            this.keyBytes = keyBytes;
        }

        public EncryptionKey(ASN1Sequence seq) throws IOException {
            this.keyType = ((ASN1Integer)KrbParser.getElementAt(seq, 0)).intValue();
            this.keyBytes = ((ASN1OctetString)KrbParser.getElementAt(seq, 1)).getValue();
        }

        public KerberosKey toKerberosKey(KerberosPrincipal princ) {
            return new KerberosKey(princ, this.keyBytes, this.keyType, 1);
        }

        @Override
        public String getAlgorithm() {
            if (this.keyType == 1 || this.keyType == 2 || this.keyType == 3) {
                return "DES";
            }
            if (this.keyType == 5 || this.keyType == 7 || this.keyType == 15 || this.keyType == 16) {
                return "DESede";
            }
            if (this.keyType == 17 || this.keyType == 18) {
                return "AES";
            }
            if (this.keyType == 23 || this.keyType == 24) {
                return "RC4";
            }
            return null;
        }

        @Override
        public byte[] getEncoded() {
            return this.keyBytes;
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public void destroy() {
            this.keyBytes = null;
        }

        @Override
        public boolean isDestroyed() {
            return this.keyBytes == null;
        }
    }

    public static class EncryptedData {
        public int etype;
        public byte[] cipherData;

        public EncryptedData(ASN1Sequence seq) throws ASN1FormatException {
            this.etype = ((ASN1Integer)KrbParser.getElementAt(seq, 0)).intValue();
            this.cipherData = ((ASN1OctetString)KrbParser.getElementAt(seq, 2)).getValue();
        }

        public byte[] decrypt(EncryptionKey key, int usage) throws ASN1FormatException {
            byte[] constant = new byte[5];
            constant[4] = -86;
            constant[0] = (byte)(usage >> 24);
            constant[1] = (byte)(usage >> 16);
            constant[2] = (byte)(usage >> 8);
            constant[3] = (byte)usage;
            try {
                if (this.etype == 1 || this.etype == 2 || this.etype == 3) {
                    byte[] iv = new byte[8];
                    Cipher c = Cipher.getInstance("DES/CBC/NoPadding");
                    c.init(2, (Key)key, new IvParameterSpec(iv));
                    byte[] out = c.doFinal(this.cipherData);
                    int cl = 8 + (this.etype == 1 ? 4 : 16);
                    byte[] out2 = new byte[out.length - cl];
                    System.arraycopy(out, cl, out2, 0, out2.length);
                    return out2;
                }
                if (this.etype == 16) {
                    byte[] iv = new byte[8];
                    byte[] Kebytes = KrbDecryptor.des3randomToKey(KrbDecryptor.deriveRandom(key.getEncoded(), constant, "DESede", 21));
                    Cipher c = Cipher.getInstance("DESede/CBC/NoPadding");
                    SecretKeySpec Ke = new SecretKeySpec(Kebytes, "DESede");
                    c.init(2, (Key)Ke, new IvParameterSpec(iv));
                    byte[] out = c.doFinal(this.cipherData, 0, this.cipherData.length - 20);
                    byte[] out2 = new byte[out.length - c.getBlockSize()];
                    System.arraycopy(out, 8, out2, 0, out2.length);
                    return out2;
                }
                if (this.etype == 17 || this.etype == 18) {
                    byte[] Kebytes = KrbDecryptor.deriveRandom(key.getEncoded(), constant, "AES", this.etype == 17 ? 16 : 32);
                    Cipher c = Cipher.getInstance("AES/CBC/NoPadding");
                    SecretKeySpec Ke = new SecretKeySpec(Kebytes, "AES");
                    byte[] cipherData2 = new byte[this.cipherData.length - 12];
                    System.arraycopy(this.cipherData, 0, cipherData2, 0, cipherData2.length);
                    byte[] out = KrbDecryptor.aesCtsDecrypt(cipherData2, Ke);
                    byte[] out2 = new byte[out.length - c.getBlockSize()];
                    System.arraycopy(out, 8, out2, 0, out2.length);
                    return out2;
                }
                if (this.etype == 23 || this.etype == 24) {
                    byte[] K1;
                    boolean export = this.etype == 24;
                    byte[] checksum = new byte[16];
                    System.arraycopy(this.cipherData, 0, checksum, 0, 16);
                    byte[] confounder = new byte[8];
                    System.arraycopy(this.cipherData, 16, confounder, 0, 8);
                    byte[] in = new byte[this.cipherData.length - 16];
                    System.arraycopy(this.cipherData, 16, in, 0, in.length);
                    byte[] T = new byte[4];
                    T[0] = (byte)usage;
                    Mac m = Mac.getInstance("HmacMD5");
                    byte[] K = key.keyBytes;
                    if (export) {
                        byte[] L40 = new byte[]{102, 111, 114, 116, 121, 98, 105, 116, 115, 0, 0, 0, 0, 0};
                        L40[10] = (byte)this.etype;
                        m.init(new SecretKeySpec(K, "Hmac"));
                        K1 = m.doFinal(L40);
                    } else {
                        m.init(new SecretKeySpec(K, "Hmac"));
                        K1 = m.doFinal(T);
                    }
                    byte[] K2 = new byte[16];
                    System.arraycopy(K1, 0, K2, 0, 16);
                    if (export) {
                        for (int i = 0; i < 9; ++i) {
                            K1[i + 7] = -85;
                        }
                    }
                    m.init(new SecretKeySpec(K1, "Hmac"));
                    byte[] K3 = m.doFinal(checksum);
                    Cipher c = Cipher.getInstance("RC4");
                    c.init(2, new SecretKeySpec(K3, "RC4"));
                    byte[] in_dec = c.doFinal(in, 0, in.length);
                    byte[] confounder_dec = new byte[8];
                    System.arraycopy(in_dec, 0, confounder_dec, 0, 8);
                    byte[] out = new byte[in_dec.length - 8];
                    System.arraycopy(in_dec, 8, out, 0, in_dec.length - 8);
                    m.init(new SecretKeySpec(K2, "Hmac"));
                    m.update(confounder_dec);
                    byte[] checksum2 = m.doFinal(out);
                    if (!Arrays.equals(checksum, checksum2)) {
                        throw new ASN1FormatException("RC4  checksum mismatch");
                    }
                    return out;
                }
                throw new NoSuchAlgorithmException("Unsupported Algorithm " + this.etype);
            }
            catch (NoSuchAlgorithmException e) {
                ASN1FormatException ae = new ASN1FormatException("Decryption problem");
                ae.initCause((Throwable)e);
                throw ae;
            }
            catch (NoSuchPaddingException e) {
                ASN1FormatException ae = new ASN1FormatException("Decryption problem");
                ae.initCause((Throwable)e);
                throw ae;
            }
            catch (InvalidKeyException e) {
                ASN1FormatException ae = new ASN1FormatException("Decryption problem");
                ae.initCause((Throwable)e);
                throw ae;
            }
            catch (BadPaddingException e) {
                ASN1FormatException ae = new ASN1FormatException("Decryption problem");
                ae.initCause((Throwable)e);
                throw ae;
            }
            catch (IllegalBlockSizeException e) {
                ASN1FormatException ae = new ASN1FormatException("Decryption problem");
                ae.initCause((Throwable)e);
                throw ae;
            }
            catch (InvalidAlgorithmParameterException e) {
                ASN1FormatException ae = new ASN1FormatException("Decryption problem");
                ae.initCause((Throwable)e);
                throw ae;
            }
        }
    }
}

