/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.c14n.XMLC14NWithComments;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.xkms.Result;
import oracle.security.xmlsec.xkms.xkiss.LocateResult;
import oracle.security.xmlsec.xkms.xkiss.ValidateResult;
import oracle.security.xmlsec.xkms.xkrss.RecoverResult;
import oracle.security.xmlsec.xkms.xkrss.RegisterResult;
import oracle.security.xmlsec.xkms.xkrss.ReissueResult;
import oracle.security.xmlsec.xkms.xkrss.RevokeResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CompoundResult
extends Result {
    public CompoundResult(Element element) throws DOMException {
        super(element);
    }

    public CompoundResult(Document owner) throws DOMException {
        super(owner, "CompoundResult", null);
    }

    public CompoundResult(Document owner, String systemId) throws DOMException {
        super(owner, "CompoundResult", systemId);
    }

    public CompoundResult(Document owner, List results) throws DOMException {
        this(owner);
        int j = results.size();
        for (int i = 0; i < j; ++i) {
            this.addResult((Result)((Object)results.get(i)));
        }
    }

    public void addResult(Result result) throws DOMException {
        Element kiElement = null;
        try {
            byte[] kiBytes = new XMLC14NWithComments().canonicalize(result.getNode());
            Document kiDoc = XMLUtils.createDocBuilder().parse(new ByteArrayInputStream(kiBytes));
            kiElement = kiDoc.getDocumentElement();
        }
        catch (CanonicalizationException ex) {
            throw new DOMException(11, "Error canonicalizing xkms:Request");
        }
        catch (IOException ex) {
            throw new DOMException(11, "Error reading xkms:Request");
        }
        catch (SAXException ex) {
            throw new DOMException(11, "Error reading xkms:Request");
        }
        Element pn = (Element)this.getOwnerDocument().importNode(kiElement, true);
        this.insertChild(pn, new String[]{"Signature", "MessageExtension", "OpaqueClientData", "RequestSignatureValue"}, new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
        this.clearSignature();
    }

    public List getResults() throws DOMException {
        int i;
        ArrayList<Result> list = new ArrayList<Result>();
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "LocateResult");
        int j = nList.getLength();
        for (i = 0; i < j; ++i) {
            list.add(new LocateResult((Element)nList.item(i)));
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "ValidateResult");
        j = nList.getLength();
        for (i = 0; i < j; ++i) {
            list.add(new ValidateResult((Element)nList.item(i)));
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "RegisterResult");
        j = nList.getLength();
        for (i = 0; i < j; ++i) {
            list.add(new RegisterResult((Element)nList.item(i)));
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "ReissueResult");
        j = nList.getLength();
        for (i = 0; i < j; ++i) {
            list.add(new ReissueResult((Element)nList.item(i)));
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "RecoverResult");
        j = nList.getLength();
        for (i = 0; i < j; ++i) {
            list.add(new RecoverResult((Element)nList.item(i)));
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "RevokeResult");
        j = nList.getLength();
        for (i = 0; i < j; ++i) {
            list.add(new RevokeResult((Element)nList.item(i)));
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }
}

