/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.util.PlatformUtils;
import oracle.jdeveloper.deploy.Archive;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.DeploymentModuleIO;
import oracle.jdeveloper.deploy.DeploymentModuleIOFactory;
import oracle.jdevimpl.deploy.fwk.ArchiveIO;
import oracle.jdevimpl.deploy.res.StripeArb;
import oracle.jdevimpl.deploy.stripe.AbstractModuleIO;

public class DirectoryModuleIO
extends AbstractModuleIO {
    public static final String MODULE_MARKER = ".module_marker";
    private static final String logCopiedFiles = System.getProperty("oracle.jdevimpl.deploy.logCopiedFiles");
    private static final boolean isLogCopiedFiles = "true".equals(logCopiedFiles);

    @Override
    public void commitImpl() throws IOException {
        DeploymentModuleDirectoryIO io_ = new DeploymentModuleDirectoryIO(this);
        io_.write(this.archive_, this.getURL(), this.archive_.getPrintWriter());
    }

    @Override
    public void rollback() {
    }

    @Override
    public boolean isArchiveReadOnly() {
        return false;
    }

    public static class DeploymentModuleDirectoryIO
    extends ArchiveIO {
        protected AbstractModuleIO moduleIO_;
        protected Map<String, Set<String>> directoryMap_ = new HashMap<String, Set<String>>();
        private static final int MAX_PATH = 260;
        private boolean haveWarnedPathTooLong_ = false;
        WeakReference<byte[]> bufRef = new WeakReference<byte[]>(new byte[0]);
        int[] bufSize = new int[]{0};
        static final int MAX_BUF_SIZE = 0x100000;

        public DeploymentModuleDirectoryIO(AbstractModuleIO moduleIO) {
            this.moduleIO_ = moduleIO;
        }

        @Override
        public void removeArchive(URL url) throws IOException {
            if (URLFileSystem.exists((URL)url) && !JarUtil.isJarURL((URL)url) && URLFileSystem.isDirectory((URL)url)) {
                this.haveWarnedPathTooLong_ = false;
                this.recursiveListDirectories(url);
            }
        }

        private void recursiveListDirectories(URL url) throws IOException {
            HashSet<String> dirList = new HashSet<String>();
            URL[] dirContents = URLFileSystem.list((URL)url);
            if (dirContents != null) {
                for (URL listURL : dirContents) {
                    if (!JarUtil.isJarURL((URL)listURL) && URLFileSystem.isDirectory((URL)listURL)) {
                        URL moduleMarker = URLFactory.newURL((URL)listURL, (String)DirectoryModuleIO.MODULE_MARKER);
                        if (URLFileSystem.exists((URL)moduleMarker)) {
                            URLFileSystem.delete((URL)moduleMarker);
                            continue;
                        }
                        this.recursiveListDirectories(listURL);
                        continue;
                    }
                    dirList.add(listURL.getPath());
                }
            } else if (PlatformUtils.isWindows() && url.getPath().length() > 259) {
                if (!this.haveWarnedPathTooLong_) {
                    this.haveWarnedPathTooLong_ = true;
                    System.err.println(StripeArb.format(4, url));
                    System.err.println(StripeArb.getString(5));
                }
            } else {
                throw new IOException(StripeArb.format(4, url));
            }
            String urlPath = url.getPath();
            this.directoryMap_.put(urlPath, dirList);
        }

        private Set<String> getDirList(URL entryURL) {
            URL entryDirURL = URLFileSystem.getParent((URL)entryURL);
            String entryDirPath = entryDirURL.getPath();
            Set<String> dirList = this.directoryMap_.get(entryDirPath);
            return dirList;
        }

        @Override
        public void write(Archive archive, URL outputURL, PrintWriter printWriter, boolean forceRewrite) throws IOException {
            URL baseDirURL = URLFactory.newDirURL((URL)outputURL, (String)"");
            this.removeArchive(baseDirURL);
            URLFileSystem.mkdir((URL)baseDirURL);
            Iterator<ArchiveEntry> iter = archive.getArchiveEntries();
            while (iter.hasNext()) {
                Set<String> dirList;
                ArchiveEntry entry = iter.next();
                String entryName = entry.getName();
                if (entryName.endsWith("/") || entryName.endsWith("\\")) {
                    URL dirURL = URLFactory.newDirURL((URL)baseDirURL, (String)entryName);
                    URLFileSystem.mkdir((URL)dirURL);
                    continue;
                }
                URL fileURL = URLFactory.newURL((URL)baseDirURL, (String)entryName);
                if (!this.persistFileEntry(archive, entry, fileURL, printWriter) || (dirList = this.getDirList(fileURL)) == null) continue;
                dirList.remove(fileURL.getPath());
            }
            this.removeUnarchivedFiles(printWriter);
            URL moduleMarker = URLFactory.newURL((URL)baseDirURL, (String)DirectoryModuleIO.MODULE_MARKER);
            OutputStream o = URLFileSystem.openOutputStream((URL)moduleMarker);
            o.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean persistFileEntry(Archive archive, ArchiveEntry entry, URL fileURL, PrintWriter writer) throws IOException {
            block14: {
                URL entryURL = entry.getURL();
                if (entryURL != null && new File(entryURL.getPath()).isDirectory()) {
                    this.copyDirToUrl(entry, fileURL);
                } else {
                    boolean isEntryModified = this.moduleIO_.isModified(entry);
                    long entrylastModified = URLFileSystem.lastModified((URL)entryURL);
                    long targetLastModified = URLFileSystem.lastModified((URL)fileURL);
                    if (!isEntryModified && entrylastModified != -1L && targetLastModified != -1L && entrylastModified == targetLastModified) {
                        return true;
                    }
                    try (InputStream in = null;){
                        in = this.moduleIO_.getInputStream(entry);
                        this.copyStreamToUrl(in, fileURL);
                        if (!isEntryModified && entrylastModified >= 0L) {
                            URLFileSystem.setLastModified((URL)fileURL, (long)entrylastModified);
                        }
                        if (isLogCopiedFiles) {
                            if (isEntryModified || entrylastModified == -1L || targetLastModified == -1L) {
                                Assert.println((String)("%%% MODIFIED " + fileURL.toString()));
                            } else {
                                Assert.println((String)("%%% CHANGED " + fileURL.toString()));
                            }
                        }
                    }
                }
            }
            return true;
        }

        protected void copyDirToUrl(ArchiveEntry ent, URL fileURL) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void copyStreamToUrl(InputStream in, URL fileURL) throws IOException {
            File outFile = new File(fileURL.getPath());
            int[] nArray = this.bufSize;
            synchronized (this.bufSize) {
                byte[] buf = (byte[])this.bufRef.get();
                int size = Math.min(0x100000, Math.max(1024, in.available()));
                if (buf == null || this.bufSize[0] < size) {
                    buf = new byte[size];
                    this.bufSize[0] = size;
                    this.bufRef = new WeakReference<byte[]>(buf);
                }
                FileOutputStream os = null;
                try {
                    URLFileSystem.mkdirs((URL)URLFileSystem.getParent((URL)fileURL));
                    os = new FileOutputStream(outFile);
                    int bytes = in.read(buf);
                    while (bytes != -1) {
                        os.write(buf, 0, bytes);
                        bytes = in.read(buf);
                    }
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }

        private void removeUnarchivedFiles(PrintWriter writer) {
            for (Set<String> s : this.directoryMap_.values()) {
                for (String filePath : s) {
                    URLFileSystem.delete((URL)URLFactory.newURL((String)filePath));
                }
            }
        }
    }

    public static class DirectoryModuleIOFactory
    implements DeploymentModuleIOFactory {
        @Override
        public DeploymentModuleIO create(String moduleIO) {
            if ("Persistence.DIRECTORY".equals(moduleIO)) {
                return new DirectoryModuleIO();
            }
            return null;
        }
    }
}

