/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.spi.profilesupport;

import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.spi.ProfileFactory;
import oracle.jdeveloper.deploy.spi.ProfileInfo;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileRecognizer;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileSupport;
import oracle.jdeveloper.deploy.spi.providers.AbstractProfileRecognizerProvider;
import oracle.jdeveloper.deploy.tk.Toolkit;
import oracle.jdeveloper.deploy.tk.ToolkitBuilder;
import oracle.jdeveloper.deploy.tk.ToolkitRegistry;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;
import oracle.jdevimpl.deploy.spi.profilesupport.PS;

public class PSProfileRecognizerProvider
extends AbstractProfileRecognizerProvider {
    ProfileRecognizer recognizer;
    boolean initialized = false;
    final PS ps;

    PSProfileRecognizerProvider(MetaClass<ProfileSupport> profileSupportClass) {
        this.ps = new PS(profileSupportClass);
    }

    PSProfileRecognizerProvider(ProfileSupport profileSupport) {
        this.ps = new PS(profileSupport);
    }

    @Override
    protected boolean recognize(Element element, ToolkitContext tkContext, Cookie cookie) {
        if (this.getRecognizer() == null) {
            return false;
        }
        cookie.bind(ToolkitContext.class, tkContext);
        return this.getRecognizer().recognize(tkContext.getIdeContext());
    }

    @Override
    protected ProfileInfo getProfileInfo(Cookie cookie) {
        ToolkitContext tkCtx = cookie.get(ToolkitContext.class);
        assert (tkCtx != null);
        Context context = new Context(tkCtx.getIdeContext());
        ProfileInfo.SpiData spi = ProfileInfo.SpiData.getInstance(context);
        spi.setProfileClass(this.ps.getProfileClass());
        return this.getToolkit(tkCtx, context, ProfileInfo.class);
    }

    private synchronized ProfileRecognizer getRecognizer() {
        ProfileSupport support = this.ps.getProfileSupport();
        return support == null ? null : support.getRecognizer();
    }

    @Override
    protected ProfileFactory getProfileFactory(Cookie cookie) {
        ToolkitContext tkCtx = cookie.get(ToolkitContext.class);
        assert (tkCtx != null);
        Context context = new Context(tkCtx.getIdeContext());
        ProfileFactory.SpiData spi = ProfileFactory.SpiData.getInstance(context);
        spi.setProfileClass(this.ps.getProfileClass());
        return this.getToolkit(tkCtx, context, ProfileFactory.class);
    }

    <T extends Toolkit> T getToolkit(ToolkitContext tkc, Context context, Class<T> tkClass) {
        ToolkitRegistry reg = tkc.getMainToolkitRegistry();
        ToolkitBuilder builder = reg.getBuilder(context, tkClass);
        return (T)((Toolkit)builder.narrowBuildToolkits()[0]);
    }
}

