/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import oracle.ide.model.Dependable;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.util.Assert;
import oracle.ide.util.Copyable;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;
import oracle.jdeveloper.deploy.LinkedDirtyable;

public abstract class AbstractHashDependable
extends HashStructureAdapter
implements Dependable,
LinkedDirtyable,
Comparable,
Copyable,
Cloneable {
    public static final String ADAPTER_CLASS_KEY = "adapterClass";
    public static final String SOURCE_URL_KEY = "sourceURL";
    public static final String OWNER_URL_KEY = "ownerURL";
    private boolean reload_;
    final DefaultLinkedDirtyable dirtyableMgr_;

    public AbstractHashDependable() {
        this(HashStructure.newInstance());
    }

    public AbstractHashDependable(HashStructure hash) {
        super(hash);
        this.dirtyableMgr_ = new DefaultLinkedDirtyable(this);
        this.setReload(true);
    }

    @Deprecated
    public AbstractHashDependable(HashStructure hash, Class clazz) {
        super(hash);
        if (clazz != null) {
            this._hash.putString(ADAPTER_CLASS_KEY, clazz.getName());
        }
        this.dirtyableMgr_ = new DefaultLinkedDirtyable(this);
        this.setReload(true);
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public Element getSource() {
        if (this.isReload()) {
            this.setReload(!this.cache());
        }
        return this.getSourceImpl();
    }

    public abstract boolean cache();

    protected abstract Element getSourceImpl();

    public Iterator getDependencies() {
        return null;
    }

    public Folder getSourceOwner() {
        if (this.isReload()) {
            this.setReload(!this.cache());
        }
        return this.getSourceOwnerImpl();
    }

    protected abstract Folder getSourceOwnerImpl();

    protected void setReload(boolean value) {
        this.reload_ = value;
    }

    protected boolean isReload() {
        return this.reload_;
    }

    protected void maybeSetReload(Object first, Object second) {
        this.reload_ = !this.reload_ && ModelUtil.areDifferent((Object)first, (Object)second);
    }

    @Override
    public void linkContainingDirtyable(Dirtyable dirtyable) {
        this.dirtyableMgr_.linkContainingDirtyable(dirtyable);
    }

    @Override
    public void unlinkContainingDirtyable(Dirtyable dirtyable) {
        this.dirtyableMgr_.unlinkContainingDirtyable(dirtyable);
    }

    @Override
    public void linkEmbeddedDirtyable(Dirtyable dirtyable) {
        this.dirtyableMgr_.linkEmbeddedDirtyable(dirtyable);
    }

    @Override
    public void unlinkEmbeddedDirtyable(Dirtyable dirtyable) {
        this.dirtyableMgr_.unlinkEmbeddedDirtyable(dirtyable);
    }

    public int compareTo(Object o) {
        return 0;
    }

    public String toString() {
        return this.getSourceOwner() + ":" + this.getSource();
    }

    public void setOwner(Dirtyable owner) {
        this.dirtyableMgr_.setOwner(owner);
    }

    public boolean isDirty() {
        return this.dirtyableMgr_.isDirty() || this._hash.isDirty();
    }

    public void markDirty(boolean dirty) {
        this.dirtyableMgr_.markDirty(dirty);
    }

    public Object copyTo(Object target) {
        AbstractHashDependable copy = target != null ? (AbstractHashDependable)target : this.clone();
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(AbstractHashDependable copy) {
        this._hash.copyTo(copy._hash);
    }

    public AbstractHashDependable clone() {
        try {
            Constructor<?> ctor = this.getClass().getConstructor(new Class[0]);
            return (AbstractHashDependable)ctor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            Assert.printStackTrace((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Assert.printStackTrace((Throwable)e);
        }
        catch (InstantiationException e) {
            Assert.printStackTrace((Throwable)e);
        }
        catch (InvocationTargetException e) {
            Assert.printStackTrace((Throwable)e);
        }
        Assert.fail((String)"Unable to clone HashDependable");
        return null;
    }
}

