/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.navigator;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.ssh.navigator.SshBaseElement;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public abstract class SshFolderElement<T extends SshBaseElement>
extends SshBaseElement {
    private List<T> mChildren;

    protected SshFolderElement() {
    }

    public final synchronized Iterator getChildren() {
        if (this.mChildren == null) {
            this.mChildren = this.loadChildren();
        }
        return this.mChildren.iterator();
    }

    protected abstract List<T> loadChildren();

    protected final void addChild(T t) {
        if (this.mChildren != null) {
            this.mChildren.add(t);
            UpdateMessage.fireChildAdded((Subject)this, t);
        }
    }

    protected final void removeChild(T t) {
        this.mChildren.remove(t);
        UpdateMessage.fireChildRemoved((Subject)this, t);
    }

    protected final T findChild(Matcher<T> matcher) {
        SshBaseElement sshBaseElement = null;
        for (SshBaseElement sshBaseElement2 : this.mChildren) {
            if (!matcher.matches(sshBaseElement2)) continue;
            sshBaseElement = sshBaseElement2;
            break;
        }
        return (T)((Object)sshBaseElement);
    }

    public static interface Matcher<T> {
        public boolean matches(T var1);
    }
}

