/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.query;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRowIterator;
import oracle.dbtools.common.query.ResultRows;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.util.TransformIterator;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.common.util.URLEncoding;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public class HyperLinks
implements Transform<ResultRow, ResultRow> {
    private final URI docBase;
    private static final String HYPERLINK_PREFIX = "$";
    private static final String HYPERLINK_PROPERTY = "$ref";

    private HyperLinks(String docBase) {
        this.docBase = URIs.create((String)docBase);
    }

    public ResultRow apply(ResultRow x) {
        return new HyperLinkedRow(this, x);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HyperLinks [docBase=");
        builder.append(this.docBase);
        builder.append("]");
        return builder.toString();
    }

    private ResultRowIterator hyperlink(Iterator<ResultRow> rows) {
        return new HyperLinkedRows(this, rows);
    }

    public static ResultRowIterator hyperlink(String documentBase, Iterator<ResultRow> rows) {
        HyperLinks hyperlinks = new HyperLinks(documentBase);
        return hyperlinks.hyperlink(rows);
    }

    public static ResultRow hyperlink(String documentBase, ResultRow row) {
        HyperLinks hyperlinks = new HyperLinks(documentBase);
        return hyperlinks.apply(row);
    }

    private static final class HyperLinkedRows
    extends TransformIterator<ResultRow, ResultRow>
    implements ResultRowIterator {
        HyperLinkedRows(HyperLinks hyperlinks, Iterator<ResultRow> items) {
            super(items, (Transform)hyperlinks);
        }
    }

    private static final class HyperLinkedRow
    extends ResultRows.Base
    implements ResultRow {
        private final HyperLinks hyperlinks;
        private final ResultRow target;

        private HyperLinkedRow(HyperLinks hyperlinks, ResultRow target) {
            this.target = target;
            this.hyperlinks = hyperlinks;
        }

        public Object get(int index) {
            Object value = null;
            value = this.isHyperLink(index) ? this.hyperlink(index) : (this.isNested(index) ? this.nested(index) : this.target.get(index));
            return value;
        }

        public String name(int index) {
            if (this.isHyperLink(index)) {
                return this.target.name(index).substring(1);
            }
            return this.target.name(index);
        }

        public int size() {
            return this.target.size();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("HyperLinkedRow [docBase=");
            builder.append(this.hyperlinks.docBase);
            builder.append(", ");
            builder.append(super.toString());
            builder.append("]");
            return builder.toString();
        }

        private URI encode(String text) {
            try {
                return new URI(text);
            }
            catch (URISyntaxException e) {
                try {
                    return new URI(URLEncoding.encodePath((String)text));
                }
                catch (URISyntaxException e2) {
                    throw WebException.internalError(e2, new Reason[0]);
                }
            }
        }

        private ResultRow hyperlink(int index) {
            String text = PrimitiveTypes.string((Object)this.target.get(index));
            URI path = this.encode(text);
            try {
                URI absoluteUri = URIs.resolve((URI)this.hyperlinks.docBase, (URI)path);
                return ResultRows.row((ResultRows.ResultColumn[])new ResultRows.ResultColumn[]{ResultRows.column((String)HyperLinks.HYPERLINK_PROPERTY, (Object)absoluteUri.toASCIIString())});
            }
            catch (URIs.IllegalURIException e) {
                throw WebException.internalError(e, Reason.reason(this.target.name(index), e.getTranslatableMessage()));
            }
        }

        private boolean isHyperLink(int index) {
            String name = this.target.name(index);
            Object value = this.target.get(index);
            return name.startsWith(HyperLinks.HYPERLINK_PREFIX) && PrimitiveTypes.isPrimitive((Object)value);
        }

        private boolean isNested(int index) {
            Object value = this.target.get(index);
            return value instanceof Iterator;
        }

        private Iterator<ResultRow> nested(int index) {
            Object value = this.target.get(index);
            ResultRowIterator rows = ResultRows.adapt((Object)value);
            return this.hyperlinks.hyperlink((Iterator)rows);
        }
    }
}

