/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.jdbc.entity;

import java.security.Principal;
import java.util.Map;
import oracle.dbtools.common.identifiers.NumericIdentifiers;
import oracle.dbtools.common.query.ColumnIterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.PrimitiveTypes;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.home.tenants.TenantIdentifiers;
import oracle.dbtools.rt.jdbc.JDBCKey;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifier;
import oracle.dbtools.rt.jdbc.entity.JDBCTenantPrincipal;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.WebException;

public abstract class JDBCIdentifiers {
    public static final String ENTITY_ID_PARAM = "id";
    public static final String ID_COLUMN = "ID";
    public static final String TENANT_ID_PARAM = "tenant_id";
    private static final String[] NO_OTHER_KEYS = new String[0];

    private JDBCIdentifiers() {
    }

    public static void bind(Map<String, Object> params, CompoundPrincipal principal) {
        Number tenantId = JDBCIdentifiers.tenantId(principal);
        params.put(TENANT_ID_PARAM, tenantId);
    }

    public static void bind(Map<String, Object> params, CompoundPrincipal principal, TenantIdentifier id) {
        JDBCIdentifiers.bind(params, principal, id, ENTITY_ID_PARAM);
    }

    public static void bind(Map<String, Object> params, CompoundPrincipal principal, TenantIdentifier id, String entityIdColumn) {
        if (id != null) {
            params.put(entityIdColumn, JDBCIdentifiers.entityId(id));
        }
        JDBCIdentifiers.bind(params, principal);
    }

    public static int compare(JDBCIdentifier jdbcIdentifier, TenantIdentifier o) {
        return 0;
    }

    public static TenantIdentifier generatedId(CompoundPrincipal principal, Map<String, Object> generatedColumns) {
        Number tenantId = JDBCIdentifiers.tenantId(principal);
        Number entityId = (Number)PrimitiveTypes.valueOf((Object)generatedColumns.get(ID_COLUMN), Number.class);
        return JDBCIdentifiers.id(tenantId, entityId);
    }

    public static StatementBuilder keyParameter(StatementBuilder builder) {
        return JDBCIdentifiers.keyParameter(builder, ENTITY_ID_PARAM, NO_OTHER_KEYS);
    }

    public static StatementBuilder keyParameter(StatementBuilder builder, String entityIdName, String ... otherKeyParameters) {
        builder.parameter(TENANT_ID_PARAM, JDBCKey.class);
        if (entityIdName != null) {
            builder.parameter(entityIdName, JDBCKey.class);
        }
        for (String keyParameter : otherKeyParameters) {
            builder.parameter(keyParameter, JDBCKey.class);
        }
        return builder;
    }

    public static TenantIdentifier parseId(String text) {
        return TenantIdentifier.parseId(text);
    }

    public static StatementBuilder tenantKeyParameter(StatementBuilder builder) {
        return JDBCIdentifiers.keyParameter(builder, null, NO_OTHER_KEYS);
    }

    public static TenantPrincipal tenantPrincipal(String tenantName, TenantIdentifier id) {
        return new JDBCTenantPrincipal(tenantName, JDBCIdentifier.tenantId(id));
    }

    public static TenantIdentifier valueOf(ColumnIterator columns) {
        Number tenantId = (Number)columns.next(Number.class);
        Number entityId = (Number)columns.next(Number.class);
        return JDBCIdentifiers.id(tenantId, entityId);
    }

    public static TenantIdentifier valueOf(ColumnIterator columns, CompoundPrincipal principal) {
        Number tenantId = JDBCIdentifiers.tenantId(principal);
        Number entityId = (Number)columns.next(Number.class);
        return JDBCIdentifiers.id(tenantId, entityId);
    }

    public static TenantIdentifier valueOf(ColumnIterator columns, TenantIdentifier id) {
        Number tenantId = JDBCIdentifiers.id(id);
        Number entityId = (Number)columns.next(Number.class);
        return JDBCIdentifiers.id(tenantId, entityId);
    }

    public static TenantIdentifier valueOf(ResultRow row, int offset) {
        return JDBCIdentifiers.valueOf(row, offset, offset + 1);
    }

    public static TenantIdentifier valueOf(ResultRow row, int tenantIdOffset, int entityIdOffset) {
        Number tenantId = (Number)row.get(tenantIdOffset, Number.class);
        Number entityId = (Number)row.get(entityIdOffset, Number.class);
        return JDBCIdentifiers.id(tenantId, entityId);
    }

    public static TenantIdentifier valueOf(ResultRow row, String tenantIdColumn, String entityIdColumn) {
        Number tenantId = (Number)row.get(tenantIdColumn, Number.class);
        Number entityId = (Number)row.get(entityIdColumn, Number.class);
        return JDBCIdentifiers.id(tenantId, entityId);
    }

    public static void verify(CompoundPrincipal principal, TenantIdentifier id, boolean write) {
        Number expectedTenantId = JDBCIdentifiers.tenantId(principal);
        Number actualTenantId = JDBCIdentifiers.id(id);
        if (write ? !expectedTenantId.equals(actualTenantId) : !expectedTenantId.equals(actualTenantId) && !TenantIdentifiers.isInternal(id)) {
            throw WebException.notFound();
        }
    }

    public static Number entityId(TenantIdentifier id) {
        return JDBCIdentifier.entityId(id);
    }

    static TenantIdentifier id(Number tenantId, Number entityId) {
        if (tenantId == null || entityId == null) {
            return null;
        }
        return JDBCIdentifier.id(tenantId, entityId);
    }

    public static Number id(TenantIdentifier id) {
        return JDBCIdentifier.tenantId(id);
    }

    static Number parseNumber(String text) {
        return NumericIdentifiers.valueOf((String)text);
    }

    private static Number tenantId(CompoundPrincipal principal) {
        TenantPrincipal tenant = TenantPrincipal.tenant((Principal)principal);
        return TenantPrincipal.id(tenant);
    }
}

