/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.util;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.ui.AttributedStringBuilder;
import oracle.javatools.ui.SuperTextAttribute;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;

public final class JavaText {
    public static final Color PARAMETER_TYPE_FOREGROUND = new Color(0, 70, 120);
    public static final Color PARAMETER_TYPE_FOREGROUND_LIGHT = new Color(137, 205, 255);
    public static final Color PARAMETER_NAME_FOREGROUND = new Color(110, 90, 40);
    public static final Color PARAMETER_NAME_FOREGROUND_LIGHT = new Color(215, 195, 146);
    public static final Map<AttributedCharacterIterator.Attribute, Object> NAME_POSTFIX_ATTRIBUTES;
    public static final Map<AttributedCharacterIterator.Attribute, Object> NAME_POSTFIX_ATTRIBUTES_LIGHT;
    public static final Map<AttributedCharacterIterator.Attribute, Object> TYPE_PRETFIX_ATTRIBUTES;
    public static final Map<AttributedCharacterIterator.Attribute, Object> TYPE_PRETFIX_ATTRIBUTES_LIGHT;
    public static final Map<AttributedCharacterIterator.Attribute, Object> NAME_POSTFIX_ATTRIBUTES_BOLD;
    public static final Map<AttributedCharacterIterator.Attribute, Object> NAME_POSTFIX_ATTRIBUTES_BOLD_LIGHT;
    public static final Map<AttributedCharacterIterator.Attribute, Object> KEYWORD_ATTRIBUTES;
    public static final Map<AttributedCharacterIterator.Attribute, Object> KEYWORD_ATTRIBUTES_NO_BOLD;
    public static final Color FADED_FOREGROUND;
    public static final Color FADED_FOREGROUND_LIGHT;
    public static final Color OVERRIDE_FOREGROUND;
    public static final Color OVERRIDE_FOREGROUND_LIGHT;
    private static final CodingStyleOptions codingStyleOptions;

    private static int getFontSize(Flag[] flags) {
        int fontSize = 12;
        if (Flag.SMALL.isPresent(flags)) {
            --fontSize;
        }
        return fontSize;
    }

    public static AttributedString methodText(JavaMethod method, String methodNameAddition, Flag ... flags) {
        Object type;
        String packageName;
        String methodName = method.isConstructor() ? method.getOwningClass().getName() : method.getName();
        int fontSize = JavaText.getFontSize(flags);
        AttributedStringBuilder asb = new AttributedStringBuilder("");
        if (Flag.SUPER.isPresent(flags)) {
            asb.append("super", KEYWORD_ATTRIBUTES);
            asb.append(".", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        }
        if (Flag.PREFIX_CLASS.isPresent(flags)) {
            if (Flag.BOLD_CLASSNAME.isPresent(flags)) {
                asb.append(method.getOwningClass().getName(), (AttributedCharacterIterator.Attribute)TextAttribute.WEIGHT, (Object)TextAttribute.WEIGHT_BOLD);
            } else {
                asb.append(method.getOwningClass().getName(), (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
            }
            asb.append(".", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        }
        if (Flag.THIS_CONSTRUCTOR.isPresent(flags)) {
            asb.append("this", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        } else if (Flag.SUPER_CONSTRUCTOR.isPresent(flags)) {
            asb.append("super", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        } else if (method.isConstructor() && Flag.BOLD_CLASSNAME.isPresent(flags)) {
            asb.append(methodName, (AttributedCharacterIterator.Attribute)TextAttribute.WEIGHT, (Object)TextAttribute.WEIGHT_BOLD);
        } else {
            asb.append(methodName, (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        }
        if (method.isDeprecated()) {
            asb.addAttribute((AttributedCharacterIterator.Attribute)TextAttribute.STRIKETHROUGH, (Object)TextAttribute.STRIKETHROUGH_ON);
        }
        if (Flag.DIAMOND.isPresent(flags) && method.isConstructor()) {
            asb.append("<>", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        }
        JavaText.appendParameterTypesAndNames((AttributedStringBuilder<AttributedCharacterIterator.Attribute, Object>)asb, method, fontSize, flags);
        if (Flag.DEFINING_CLASS.isPresent(flags)) {
            if (Flag.PACKAGE.isPresent(flags)) {
                asb.append(" - " + method.getOwningClass().getQualifiedName(), Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_LIGHT : NAME_POSTFIX_ATTRIBUTES);
            } else {
                asb.append(" - " + method.getOwningClass().getName(), Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_LIGHT : NAME_POSTFIX_ATTRIBUTES);
            }
        } else if (Flag.PACKAGE.isPresent(flags) && (packageName = method.getOwningClass().getPackageName()).length() > 0) {
            asb.append(" - " + packageName, Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_LIGHT : NAME_POSTFIX_ATTRIBUTES);
        }
        if (methodNameAddition != null && !"".equals(methodNameAddition)) {
            asb.append(" " + methodNameAddition, Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_BOLD_LIGHT : NAME_POSTFIX_ATTRIBUTES_BOLD);
        }
        if (Flag.ARRAY_ELLIPSES.isPresent(flags)) {
            asb.append("[", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
            asb.append("...", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
            asb.append("]", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        }
        if (Flag.POSTFIX_TYPE.isPresent(flags)) {
            Collection typeVars;
            type = method.getReturnType();
            if (!(type == null || type.isPrimitive() && ((PrimitiveType)type).isVoid())) {
                asb.append(" : ", Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_LIGHT : NAME_POSTFIX_ATTRIBUTES);
                HashMap<AttributedCharacterIterator.Attribute, Object> typeAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                typeAttrs.put(TextAttribute.SIZE, 11);
                if (Flag.LIGHT.isPresent(flags)) {
                    typeAttrs.put(TextAttribute.FOREGROUND, FADED_FOREGROUND_LIGHT);
                } else {
                    typeAttrs.put(TextAttribute.FOREGROUND, FADED_FOREGROUND);
                }
                JavaText.appendType((AttributedStringBuilder<AttributedCharacterIterator.Attribute, Object>)asb, typeAttrs, (JavaType)type, false, flags);
            }
            if (!(typeVars = method.getTypeParameters()).isEmpty()) {
                asb.append(" : <", Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_LIGHT : NAME_POSTFIX_ATTRIBUTES);
                String sep = "";
                for (JavaTypeVariable typeVar : typeVars) {
                    asb.append(sep, Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_LIGHT : NAME_POSTFIX_ATTRIBUTES);
                    JavaText.appendType((AttributedStringBuilder<AttributedCharacterIterator.Attribute, Object>)asb, Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_LIGHT : NAME_POSTFIX_ATTRIBUTES, (JavaType)typeVar, false, flags);
                    String boundSep = " extends ";
                    for (JavaType boundType : typeVar.getBounds()) {
                        asb.append(boundSep, Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_LIGHT : NAME_POSTFIX_ATTRIBUTES);
                        JavaText.appendType((AttributedStringBuilder<AttributedCharacterIterator.Attribute, Object>)asb, Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_LIGHT : NAME_POSTFIX_ATTRIBUTES, boundType, false, flags);
                        boundSep = " & ";
                    }
                    sep = ", ";
                }
                asb.append(">", Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_LIGHT : NAME_POSTFIX_ATTRIBUTES);
            }
        }
        if (Flag.OVERRIDE.isPresent(flags) && (type = method.getOverriddenMethods().iterator()).hasNext()) {
            String hyperlink;
            JavaMethod override = (JavaMethod)type.next();
            JavaClass owningClass = override.getOwningClass();
            HashMap<TextAttribute, Object> OVERRIDE_ATTRIBUTES = new HashMap<TextAttribute, Object>();
            OVERRIDE_ATTRIBUTES.put(TextAttribute.FOREGROUND, Flag.LIGHT.isPresent(flags) ? new Color(0, 200, 200) : new Color(0, 160, 160));
            OVERRIDE_ATTRIBUTES.put(TextAttribute.SIZE, 11);
            if (Flag.HYPERLINK.isPresent(flags) && (hyperlink = JavaText.methodHyperlink(override)) != null) {
                OVERRIDE_ATTRIBUTES.put((TextAttribute)SuperTextAttribute.HYPERLINK, hyperlink);
            }
            String overClass = owningClass.getName();
            asb.append("  ");
            asb.append("\u2191\u200a" + overClass, OVERRIDE_ATTRIBUTES);
        }
        AttributedString as = asb.toAttributedString();
        return as;
    }

    private static void appendType(AttributedStringBuilder<AttributedCharacterIterator.Attribute, Object> asb, Map<AttributedCharacterIterator.Attribute, Object> attrs, JavaType type, boolean showTypeParameters, Flag ... flags) {
        Collection typeVars;
        if (type == null) {
            return;
        }
        if (type instanceof JavaClass && Flag.HYPERLINK.isPresent(flags)) {
            HashMap<AttributedCharacterIterator.Attribute, Object> typeAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
            typeAttrs.putAll(attrs);
            String hyperlink = JavaText.classHyperlink((JavaClass)type);
            if (hyperlink != null) {
                typeAttrs.put((AttributedCharacterIterator.Attribute)SuperTextAttribute.HYPERLINK, hyperlink);
            }
            asb.append(type.getName(), typeAttrs);
        } else {
            asb.append(type.getName(), attrs);
        }
        Collection typeParams = type.getActualTypeArguments();
        if (!typeParams.isEmpty()) {
            asb.append("<", attrs);
            String sep = "";
            for (JavaType typeParam : typeParams) {
                asb.append(sep, attrs);
                JavaText.appendType(asb, attrs, typeParam, false, flags);
                sep = ", ";
            }
            asb.append(">", attrs);
        }
        if (showTypeParameters && Flag.SHOW_TYPE_ARGUMENTS.isPresent(flags) && !(typeVars = type.getTypeParameters()).isEmpty()) {
            asb.append("<", attrs);
            String sep = "";
            for (JavaTypeVariable typeVar : typeVars) {
                asb.append(sep, attrs);
                JavaText.appendType(asb, attrs, (JavaType)typeVar, false, flags);
                String boundSep = " extends ";
                for (JavaType boundType : typeVar.getBounds()) {
                    asb.append(boundSep, attrs);
                    JavaText.appendType(asb, attrs, boundType, false, flags);
                    boundSep = " & ";
                }
                sep = ", ";
            }
            asb.append(">", attrs);
        }
    }

    public static AttributedString methodText(JavaMethod method, Flag ... flags) {
        return JavaText.methodText(method, null, flags);
    }

    public static AttributedString methodTextShort(JavaMethod method, Flag ... flags) {
        int fontSize = JavaText.getFontSize(flags);
        String methodName = method.isConstructor() ? method.getOwningClass().getName() : method.getName();
        AttributedStringBuilder asb = new AttributedStringBuilder("");
        if (Flag.SUPER.isPresent(flags)) {
            asb.append("super", KEYWORD_ATTRIBUTES);
            asb.append(".", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        }
        asb.append(methodName, (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        if (method.isDeprecated()) {
            asb.addAttribute((AttributedCharacterIterator.Attribute)TextAttribute.STRIKETHROUGH, (Object)TextAttribute.STRIKETHROUGH_ON);
        }
        if (method.getParameters().isEmpty()) {
            asb.append("()", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        } else {
            asb.append("(...)", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        }
        if (Flag.DEFINING_CLASS.isPresent(flags)) {
            asb.append(" - " + method.getOwningClass().getName(), Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_LIGHT : NAME_POSTFIX_ATTRIBUTES);
        }
        AttributedString as = asb.toAttributedString();
        return as;
    }

    public static AttributedString classText(JavaClass javaClass, Flag ... flags) {
        return JavaText.classText(javaClass, null, flags);
    }

    public static AttributedString classText(JavaClass javaClass, String name, Flag ... flags) {
        int fontSize = JavaText.getFontSize(flags);
        AttributedStringBuilder asb = new AttributedStringBuilder("");
        if (Flag.PREFIX_PIPE.isPresent(flags)) {
            asb.append("|" + (codingStyleOptions == null ? " " : (codingStyleOptions.getSpaceAroundBinaryOperator() ? " " : "")), (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        }
        if (Flag.SUPER.isPresent(flags)) {
            asb.append("super", KEYWORD_ATTRIBUTES);
            asb.append(".", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        }
        HashMap<AttributedCharacterIterator.Attribute, Object> nameAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        nameAttrs.put(TextAttribute.SIZE, fontSize);
        if (Flag.BOLD_CLASSNAME.isPresent(flags)) {
            nameAttrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (javaClass.isDeprecated()) {
            nameAttrs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if (name != null) {
            String hyperlink;
            if (Flag.HYPERLINK.isPresent(flags) && (hyperlink = JavaText.classHyperlink(javaClass)) != null) {
                nameAttrs.put((AttributedCharacterIterator.Attribute)SuperTextAttribute.HYPERLINK, hyperlink);
            }
            asb.append(name, nameAttrs);
        } else {
            JavaText.appendType((AttributedStringBuilder<AttributedCharacterIterator.Attribute, Object>)asb, nameAttrs, (JavaType)javaClass, true, flags);
        }
        if (Flag.DIAMOND.isPresent(flags)) {
            asb.append("<>", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        }
        String packageName = javaClass.getPackageName();
        if (Flag.PACKAGE.isPresent(flags) && packageName.length() > 0) {
            asb.append(" " + packageName, Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_LIGHT : NAME_POSTFIX_ATTRIBUTES);
        }
        return asb.toAttributedString();
    }

    private static void appendParameterTypesAndNames(AttributedStringBuilder<AttributedCharacterIterator.Attribute, Object> asb, JavaMethod method, int fontSize, Flag ... flags) {
        if (Flag.SPACE_BEFORE_PARAMETERS.isPresent(flags)) {
            asb.append(" ");
        }
        asb.append("(", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        Collection javaMethodParameters = method.getParameters();
        int numParameters = javaMethodParameters.size();
        Iterator iter = javaMethodParameters.iterator();
        HashMap<TextAttribute, Serializable> paramNameAttrs = new HashMap<TextAttribute, Serializable>();
        paramNameAttrs.put(TextAttribute.SIZE, Integer.valueOf(fontSize));
        paramNameAttrs.put(TextAttribute.FOREGROUND, Flag.LIGHT.isPresent(flags) ? PARAMETER_NAME_FOREGROUND_LIGHT : PARAMETER_NAME_FOREGROUND);
        if (Flag.ITALIC_LOCALS.isPresent(flags)) {
            paramNameAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        boolean isFirst = true;
        for (int i = 0; i < numParameters; ++i) {
            JavaVariable param;
            HashMap<TextAttribute, Object> paramAttrs = new HashMap<TextAttribute, Object>();
            paramAttrs.put(TextAttribute.SIZE, fontSize);
            paramAttrs.put(TextAttribute.FOREGROUND, Flag.LIGHT.isPresent(flags) ? PARAMETER_TYPE_FOREGROUND_LIGHT : PARAMETER_TYPE_FOREGROUND);
            if (Flag.ITALIC_LOCALS.isPresent(flags)) {
                paramAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            if ((param = (JavaVariable)iter.next()).isSynthetic() && (!method.isSynthetic() || method.isConstructor() && (method.getOwningClass().isMemberClass() || method.getOwningClass().isAnonymousClass()))) continue;
            JavaType type = param.getResolvedType();
            Object typeName = null;
            if (type != null) {
                String hyperlink;
                if (i == numParameters - 1 && method.isVarargs() && type.isArray() && type.getBaseComponentType() != null) {
                    typeName = type.getBaseComponentType().getUnqualifiedName() + "...";
                }
                if (typeName == null) {
                    typeName = type.getUnqualifiedName();
                }
                if (type instanceof JavaClass && Flag.HYPERLINK.isPresent(flags) && (hyperlink = JavaText.classHyperlink((JavaClass)type)) != null) {
                    paramAttrs.put((TextAttribute)SuperTextAttribute.HYPERLINK, hyperlink);
                }
            } else {
                typeName = "<unknown>";
            }
            String paramName = param.getName();
            if (!isFirst) {
                asb.append(", ");
            }
            isFirst = false;
            asb.append((String)typeName, paramAttrs);
            asb.append(" ");
            asb.append(paramName, paramNameAttrs);
        }
        asb.append(")", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
    }

    public static AttributedString defaultText(JavaElement element, Flag ... flags) {
        return JavaText.defaultText(element, JavaText.getName(element, Flag.PREFIX_CLASS), flags);
    }

    public static AttributedString defaultText(JavaElement element, String name, Flag ... flags) {
        JavaVariable var;
        JavaType type;
        int fontSize = JavaText.getFontSize(flags);
        if (element instanceof JavaMethod) {
            flags = Flag.addFlags(flags, Flag.PREFIX_CLASS);
            return JavaText.methodText((JavaMethod)element, flags);
        }
        if (element instanceof JavaClass) {
            flags = Flag.addFlags(flags, Flag.PACKAGE);
            return JavaText.classText((JavaClass)element, name, flags);
        }
        AttributedStringBuilder asb = new AttributedStringBuilder("");
        if (Flag.SUPER.isPresent(flags)) {
            asb.append("super", KEYWORD_ATTRIBUTES);
            asb.append(".", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        }
        if (Flag.BOLD_CLASSNAME.isPresent(flags)) {
            asb.append(name, (AttributedCharacterIterator.Attribute)TextAttribute.WEIGHT, (Object)TextAttribute.WEIGHT_BOLD);
        } else {
            asb.append(name, (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        }
        if (element instanceof JavaMember) {
            CharSequence postName;
            if (Flag.DEFINING_CLASS.isPresent(flags)) {
                String packageName;
                postName = new StringBuilder(((JavaMember)element).getOwningClass().getName());
                if (Flag.PACKAGE.isPresent(flags) && (packageName = ((JavaMember)element).getOwningClass().getPackageName()).length() > 0) {
                    if (((StringBuilder)postName).length() > 0) {
                        ((StringBuilder)postName).append(" ");
                    }
                    ((StringBuilder)postName).append(packageName);
                }
                if (((StringBuilder)postName).length() > 0) {
                    asb.append(" - " + ((StringBuilder)postName).toString() + name, Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_LIGHT : NAME_POSTFIX_ATTRIBUTES);
                }
            } else if (Flag.PACKAGE.isPresent(flags) && ((String)(postName = ((JavaMember)element).getOwningClass().getPackageName())).length() > 0) {
                asb.append(" - " + name, Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_LIGHT : NAME_POSTFIX_ATTRIBUTES);
            }
        }
        if (Flag.ARRAY_ELLIPSES.isPresent(flags)) {
            HashMap<TextAttribute, Serializable> paramNameAttrs = new HashMap<TextAttribute, Serializable>();
            paramNameAttrs.put(TextAttribute.FOREGROUND, Flag.LIGHT.isPresent(flags) ? PARAMETER_NAME_FOREGROUND_LIGHT : PARAMETER_NAME_FOREGROUND);
            if (Flag.ITALIC_LOCALS.isPresent(flags)) {
                paramNameAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            asb.append("[", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
            asb.append("...", paramNameAttrs);
            asb.append("]", (AttributedCharacterIterator.Attribute)TextAttribute.SIZE, (Object)fontSize);
        }
        if (element instanceof JavaVariable && Flag.POSTFIX_TYPE.isPresent(flags) && (type = (var = (JavaVariable)element).getResolvedType()) != null && !(type instanceof JavaTypeVariable)) {
            asb.append(" : ", Flag.LIGHT.isPresent(flags) ? NAME_POSTFIX_ATTRIBUTES_LIGHT : NAME_POSTFIX_ATTRIBUTES);
            HashMap<AttributedCharacterIterator.Attribute, Object> typeAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
            typeAttrs.put(TextAttribute.SIZE, 11);
            if (Flag.LIGHT.isPresent(flags)) {
                typeAttrs.put(TextAttribute.FOREGROUND, FADED_FOREGROUND_LIGHT);
            } else {
                typeAttrs.put(TextAttribute.FOREGROUND, FADED_FOREGROUND);
            }
            JavaText.appendType((AttributedStringBuilder<AttributedCharacterIterator.Attribute, Object>)asb, typeAttrs, type, false, flags);
        }
        AttributedString aText = asb.toAttributedString();
        if (element instanceof JavaLocalVariable && Flag.ITALIC_LOCALS.isPresent(flags) && !element.isFinal() && aText.getIterator().getEndIndex() > 0) {
            aText.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        return aText;
    }

    public static String getName(JavaElement element, Flag ... flags) {
        if (element instanceof JavaHasName) {
            if (element instanceof JavaMethod && ((JavaMethod)element).isConstructor()) {
                if (Flag.THIS_CONSTRUCTOR.isPresent(flags)) {
                    return "this";
                }
                if (Flag.SUPER_CONSTRUCTOR.isPresent(flags)) {
                    return "super";
                }
                return ((JavaMethod)element).getOwningClass().getName();
            }
            StringBuilder sb = new StringBuilder(((JavaHasName)element).getName());
            if (element instanceof JavaMember && Flag.PREFIX_CLASS.isPresent(flags)) {
                JavaMember member = (JavaMember)element;
                sb.insert(0, ".");
                if (member.getOwningClass() != null) {
                    sb.insert(0, member.getOwningClass().getName());
                }
            }
            if (element.getElementKind() == 9) {
                String name = sb.toString();
                int lastDot = name.lastIndexOf(46);
                if (lastDot != -1) {
                    return name.substring(lastDot + 1);
                }
                return name;
            }
            if (Flag.SUPER.isPresent(flags)) {
                sb.insert(0, "super.");
            }
            if (Flag.DIAMOND.isPresent(flags)) {
                sb.append("<>");
            }
            if (Flag.PREFIX_PIPE.isPresent(flags)) {
                sb.insert(0, "|" + (codingStyleOptions == null ? " " : (codingStyleOptions.getSpaceAroundBinaryOperator() ? " " : "")));
            }
            return sb.toString();
        }
        return "";
    }

    public static AttributedString dereferenceText(String referenceType, String realType) {
        AttributedStringBuilder typeBuilder = new AttributedStringBuilder(referenceType, TYPE_PRETFIX_ATTRIBUTES);
        typeBuilder.append(" ");
        typeBuilder.append(realType);
        return typeBuilder.toAttributedString();
    }

    private static String classHyperlink(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        SourceClass sourceClass = javaClass.getSourceElement();
        if (sourceClass != null) {
            URL url = sourceClass.getURL();
            if (url == null) {
                return null;
            }
            Object urlString = url.toExternalForm();
            SourceName sourceName = sourceClass.getNameElement();
            if (sourceName != null) {
                urlString = (String)urlString + "#" + sourceName.getStartOffset() + "," + sourceName.getEndOffset();
            }
            return urlString;
        }
        return null;
    }

    private static String methodHyperlink(JavaMethod javaMethod) {
        if (javaMethod == null) {
            return null;
        }
        SourceMethod sourceMethod = javaMethod.getSourceElement();
        if (sourceMethod != null) {
            SourceClass sourceClass = sourceMethod.getEnclosingClass();
            URL url = sourceClass.getURL();
            if (url == null) {
                return null;
            }
            Object urlString = url.toExternalForm();
            SourceName sourceName = sourceMethod.getNameElement();
            if (sourceName != null) {
                urlString = (String)urlString + "#" + sourceName.getStartOffset() + "," + sourceName.getEndOffset();
            }
            return urlString;
        }
        return null;
    }

    static {
        FADED_FOREGROUND = new Color(100, 100, 100);
        FADED_FOREGROUND_LIGHT = new Color(175, 175, 175);
        OVERRIDE_FOREGROUND = new Color(0, 178, 178);
        OVERRIDE_FOREGROUND_LIGHT = new Color(0, 137, 137);
        codingStyleOptions = CodingStyleManager.getCodingStyleManager().getCodingStyleOptions();
        KEYWORD_ATTRIBUTES = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        KEYWORD_ATTRIBUTES.put(TextAttribute.FOREGROUND, new Color(0, 99, 148));
        KEYWORD_ATTRIBUTES.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        KEYWORD_ATTRIBUTES_NO_BOLD = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        KEYWORD_ATTRIBUTES_NO_BOLD.put(TextAttribute.FOREGROUND, new Color(0, 99, 148));
        NAME_POSTFIX_ATTRIBUTES = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        NAME_POSTFIX_ATTRIBUTES.put(TextAttribute.FOREGROUND, FADED_FOREGROUND);
        NAME_POSTFIX_ATTRIBUTES.put(TextAttribute.SIZE, 11);
        NAME_POSTFIX_ATTRIBUTES_LIGHT = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        NAME_POSTFIX_ATTRIBUTES_LIGHT.put(TextAttribute.FOREGROUND, FADED_FOREGROUND_LIGHT);
        NAME_POSTFIX_ATTRIBUTES_LIGHT.put(TextAttribute.SIZE, 11);
        NAME_POSTFIX_ATTRIBUTES_BOLD = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        NAME_POSTFIX_ATTRIBUTES_BOLD.put(TextAttribute.FOREGROUND, FADED_FOREGROUND);
        NAME_POSTFIX_ATTRIBUTES_BOLD.put(TextAttribute.SIZE, 11);
        NAME_POSTFIX_ATTRIBUTES_BOLD.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        NAME_POSTFIX_ATTRIBUTES_BOLD_LIGHT = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        NAME_POSTFIX_ATTRIBUTES_BOLD_LIGHT.put(TextAttribute.FOREGROUND, FADED_FOREGROUND_LIGHT);
        NAME_POSTFIX_ATTRIBUTES_BOLD_LIGHT.put(TextAttribute.SIZE, 11);
        NAME_POSTFIX_ATTRIBUTES_BOLD_LIGHT.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        TYPE_PRETFIX_ATTRIBUTES = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        TYPE_PRETFIX_ATTRIBUTES.put(TextAttribute.FOREGROUND, FADED_FOREGROUND);
        TYPE_PRETFIX_ATTRIBUTES.put(TextAttribute.SIZE, 11);
        TYPE_PRETFIX_ATTRIBUTES.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        TYPE_PRETFIX_ATTRIBUTES_LIGHT = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        TYPE_PRETFIX_ATTRIBUTES_LIGHT.put(TextAttribute.FOREGROUND, FADED_FOREGROUND_LIGHT);
        TYPE_PRETFIX_ATTRIBUTES_LIGHT.put(TextAttribute.SIZE, 11);
        TYPE_PRETFIX_ATTRIBUTES_LIGHT.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
    }

    public static enum Flag {
        SUPER,
        DIAMOND,
        DEFINING_CLASS,
        PREFIX_CLASS,
        PACKAGE,
        ITALIC_LOCALS,
        PREFIX_PIPE,
        THIS_CONSTRUCTOR,
        SUPER_CONSTRUCTOR,
        BOLD_CLASSNAME,
        ARRAY_ELLIPSES,
        LIGHT,
        SMALL,
        POSTFIX_TYPE,
        SPACE_BEFORE_PARAMETERS,
        OVERRIDE,
        HYPERLINK,
        SHOW_TYPE_ARGUMENTS;


        public boolean isPresent(Flag[] flags) {
            if (flags == null) {
                return false;
            }
            for (Flag flag : flags) {
                if (flag != this) continue;
                return true;
            }
            return false;
        }

        public static Flag[] addFlags(Flag[] flags, Flag ... additionalFlags) {
            Flag[] newFlags = new Flag[flags.length + additionalFlags.length];
            System.arraycopy(flags, 0, newFlags, 0, flags.length);
            System.arraycopy(additionalFlags, 0, newFlags, flags.length, additionalFlags.length);
            return newFlags;
        }
    }
}

