/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.ClassKind;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.CreateTypeHelper;
import oracle.jdevimpl.java.CreateJavaFileCommand;

public class CreateTypeCommand
extends CreateJavaFileCommand {
    private String typeName;
    private int modifiers;
    Collection imports;
    private String[] superTypes;
    private String[] constructorTypes;
    private String body;
    protected static String COMMAND_NAME = "create-type-command";
    private static int commandId = 0;
    private List<SourceTypeArgument> typeArguments;
    private final JavaManager javaManager;

    public CreateTypeCommand(URL url, String typeName, int modifiers, Collection imports, String body, Project project, Workspace workspace) {
        this(url, typeName, modifiers, imports, null, null, project, workspace);
        this.body = body;
    }

    public CreateTypeCommand(URL url, String typeName, int modifiers, Collection imports, String[] superTypes, String[] constructorTypes, Project project, Workspace workspace) {
        this(url, typeName, modifiers, imports, superTypes, constructorTypes, project, workspace, null);
    }

    public CreateTypeCommand(URL url, String typeName, int modifiers, Collection imports, String[] superTypes, String[] constructorTypes, Project project, Workspace workspace, List<SourceTypeArgument> typeArguments) {
        super(CreateTypeCommand.id(COMMAND_NAME), "Create " + URLFileSystem.getName((URL)url), url, project, workspace);
        this.typeName = typeName;
        this.modifiers = modifiers;
        this.imports = imports;
        this.superTypes = superTypes;
        this.constructorTypes = constructorTypes;
        this.typeArguments = typeArguments;
        this.javaManager = JavaManager.getInstance(workspace, project);
    }

    @Override
    protected void doCreateContents(SourceFile file, Project project, Workspace workspace) {
        SourceClass type;
        SourceFactory factory = file.getFactory();
        String className = this.typeName;
        int dot = this.typeName.lastIndexOf(46);
        if (dot > 0) {
            className = this.typeName.substring(dot + 1);
            file.setPackageName(this.typeName.substring(0, dot));
        }
        this.ensureImports(this.imports);
        if (this.body == null) {
            ClassKind kind = (this.modifiers & 0x200) != 0 ? ClassKind.INTERFACE : ((this.modifiers & 0x4000) != 0 ? ClassKind.ENUM : ClassKind.CLASS);
            CreateTypeHelper typeHelper = new CreateTypeHelper(factory, className, kind, this.superTypes, this.javaManager, this.constructorTypes, this.typeArguments);
            CreateTypeHelper.CreatedTypeData createdType = typeHelper.createType();
            type = createdType.getNewSourceClass();
            this.ensureImports(createdType.getTypesToImport());
            this.ensureImports(createdType.getTypeNamesToImport());
        } else {
            type = factory.createClass(this.body);
        }
        file.getSourceClasses().add(type);
        type.setModifiers(this.modifiers);
    }

    protected static int id(String name) {
        if (commandId == 0) {
            commandId = Ide.findOrCreateCmdID((String)name);
        }
        return commandId;
    }
}

