/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.uieditor;

import java.awt.Component;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.layout.ViewId;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.Assert;
import oracle.jdeveloper.cmt.CmtMessage;
import oracle.jdeveloper.resource.UIEditorArb;
import oracle.jdeveloper.uieditor.UIEditor;

public final class UIEditorLogPage
extends DefaultLogPage {
    static final String PAGE_ID = "EditorLogPage";
    final DefaultMutableTreeNode root = new DefaultMutableTreeNode();
    final DefaultTreeModel model = new DefaultTreeModel(this.root);

    UIEditorLogPage() {
        super(new ViewId(PAGE_ID, UIEditorArb.getString((int)4)), UIEditorArb.getIcon((int)6), true);
        this.getTree().setModel(this.model);
        this.getTree().setCellRenderer(new MessageCellRenderer());
    }

    protected void activateObject(Object obj) {
        try {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            CmtMessage msg = (CmtMessage)node.getUserObject();
            Context context = Context.newIdeContext((Node)NodeFactory.find((URL)msg.getURL()));
            context.setProject(msg.getProject());
            NavigationManager mgr = NavigationManager.getNavigationManager();
            OffsetNavigationPoint point = new OffsetNavigationPoint(context, msg.getStartOffset(), msg.getEndOffset() - msg.getStartOffset());
            if (mgr != null) {
                mgr.navigateTo((NavigationPoint)point);
            } else {
                point.navigate();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void updateTreeModel(Collection message) {
        try {
            ModelErrorBuilder thread = new ModelErrorBuilder(this, message);
            thread.run();
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        super.clearAll();
        DefaultTreeModel defaultTreeModel = this.model;
        synchronized (defaultTreeModel) {
            for (int i = this.root.getChildCount() - 1; i >= 0; --i) {
                this.root.remove(i);
            }
            this.model.nodeChanged(this.root);
            this.getTree().setModel(this.model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll(UIEditor editor) {
        Node doc;
        if (editor == null) {
            return;
        }
        if (this.getCurrentView() != this.getTree()) {
            this.clearAll();
            return;
        }
        Context context = editor.getContext();
        Project project = context != null ? context.getProject() : null;
        Node node = doc = context != null ? context.getNode() : null;
        if (project == null || doc == null) {
            return;
        }
        DefaultTreeModel defaultTreeModel = this.model;
        synchronized (defaultTreeModel) {
            block12: {
                URL url = doc.getURL();
                Enumeration<TreeNode> e = this.root.children();
                DefaultMutableTreeNode target = null;
                block5: while (e.hasMoreElements()) {
                    DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)e.nextElement();
                    CmtMessage msg = (CmtMessage)node2.getUserObject();
                    if (msg.getProject() != project) continue;
                    e = node2.children();
                    while (e.hasMoreElements()) {
                        node2 = (DefaultMutableTreeNode)e.nextElement();
                        msg = (CmtMessage)node2.getUserObject();
                        if (msg.getURL() != url) continue;
                        target = node2;
                        break block5;
                    }
                    break block5;
                }
                if (target != null) {
                    if (target.getParent().getChildCount() == 1) {
                        target = (DefaultMutableTreeNode)target.getParent();
                    }
                    try {
                        this.model.removeNodeFromParent(target);
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ThreadDeath)) break block12;
                        throw (ThreadDeath)t;
                    }
                }
            }
        }
    }

    JTree inScopeGetTree() {
        return this.getTree();
    }

    private static final class MessageCellRenderer
    extends DefaultTreeCellRenderer {
        private MessageCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            CmtMessage msg = (CmtMessage)((DefaultMutableTreeNode)value).getUserObject();
            if (msg != null) {
                this.setIcon(msg.getIcon());
                this.setText(msg.getLongLabel());
            }
            return this;
        }
    }

    private static final class ModelErrorBuilder
    implements Runnable {
        Collection message;
        UIEditorLogPage page;

        ModelErrorBuilder(UIEditorLogPage page, Collection message) {
            this.page = page;
            this.message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.message == null) {
                return;
            }
            DefaultTreeModel defaultTreeModel = this.page.model;
            synchronized (defaultTreeModel) {
                Iterator iter = this.message.iterator();
                DefaultMutableTreeNode messageNode = null;
                while (iter.hasNext()) {
                    DefaultMutableTreeNode parent;
                    CmtMessage msg;
                    block10: {
                        DefaultMutableTreeNode child;
                        Enumeration<TreeNode> en;
                        URL url;
                        block9: {
                            msg = (CmtMessage)iter.next();
                            Project prj = msg.getProject();
                            url = prj != null ? prj.getURL() : null;
                            parent = this.page.root;
                            if (url != null) {
                                en = parent.children();
                                while (en.hasMoreElements()) {
                                    child = (DefaultMutableTreeNode)en.nextElement();
                                    if (!url.equals(((CmtMessage)child.getUserObject()).getURL())) continue;
                                    parent = child;
                                    break block9;
                                }
                                child = new DefaultMutableTreeNode(new ProjectMessage(msg));
                                parent.insert(child, parent.getChildCount());
                                parent = child;
                            }
                        }
                        if ((url = msg.getURL()) != null) {
                            en = parent.children();
                            while (en.hasMoreElements()) {
                                child = (DefaultMutableTreeNode)en.nextElement();
                                if (!url.equals(((CmtMessage)child.getUserObject()).getURL())) continue;
                                parent = child;
                                break block10;
                            }
                            child = new DefaultMutableTreeNode(new FileMessage(msg));
                            parent.insert(child, parent.getChildCount());
                            parent = child;
                        }
                    }
                    messageNode = new DefaultMutableTreeNode(msg);
                    parent.insert(messageNode, parent.getChildCount());
                }
                final DefaultMutableTreeNode lastMessage = messageNode;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        page.model.reload();
                        page.inScopeGetTree().expandPath(new TreePath(((DefaultMutableTreeNode)lastMessage.getParent()).getPath()));
                    }
                });
            }
        }
    }

    private static final class FileMessage
    extends ProjectMessage {
        Project prj;

        FileMessage(CmtMessage msg) {
            super(msg);
            this.node = NodeFactory.find((URL)msg.getURL());
            this.prj = msg.getProject();
        }

        @Override
        public Project getProject() {
            return this.prj;
        }
    }

    private static class ProjectMessage
    implements CmtMessage {
        Node node;
        int start;
        int end;
        int type;

        ProjectMessage(CmtMessage msg) {
            this.node = msg.getProject();
            this.start = msg.getStartOffset();
            this.end = msg.getEndOffset();
            this.type = msg.getType();
        }

        @Override
        public Project getProject() {
            return (Project)this.node;
        }

        @Override
        public int getStartOffset() {
            return this.start;
        }

        @Override
        public int getEndOffset() {
            return this.end;
        }

        @Override
        public int getType() {
            return this.type;
        }

        public final URL getURL() {
            return this.node.getURL();
        }

        public void setURL(URL url) {
        }

        public String getShortLabel() {
            return this.node.getShortLabel();
        }

        public final String getLongLabel() {
            return this.node.getLongLabel();
        }

        public final Icon getIcon() {
            return this.node.getIcon();
        }

        public String getToolTipText() {
            return this.node.getToolTipText();
        }

        public final String toString() {
            return this.node.toString();
        }
    }
}

