/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.stree;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.IOException;

public class JrsBoolean
extends JrsValue.Scalar {
    public static JrsBoolean TRUE = new JrsBoolean(true, JsonToken.VALUE_TRUE);
    public static JrsBoolean FALSE = new JrsBoolean(false, JsonToken.VALUE_FALSE);
    private final boolean _value;
    private final JsonToken _token;

    private JrsBoolean(boolean bl, JsonToken jsonToken) {
        this._value = bl;
        this._token = jsonToken;
    }

    public JsonToken asToken() {
        return this._token;
    }

    @Override
    public String asText() {
        return this._value ? "true" : "false";
    }

    public boolean booleanValue() {
        return this._value;
    }

    @Override
    protected void write(JsonGenerator jsonGenerator, JacksonJrsTreeCodec jacksonJrsTreeCodec) throws IOException {
        jsonGenerator.writeBoolean(this._value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JrsBoolean jrsBoolean = (JrsBoolean)object;
        return this._value == jrsBoolean._value;
    }

    public int hashCode() {
        return this._value ? 1 : 0;
    }
}

