/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime.ess;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.smime.ess.MLReceiptPolicy;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class MLData
implements ASN1Object {
    private IssuerAndSerialNo iasn;
    private byte[] ski;
    private ASN1Date expansionTime;
    private MLReceiptPolicy policy;
    private ASN1Sequence contents;

    public MLData(X509Certificate cert, Date date) throws CertificateEncodingException, IOException {
        this.iasn = new IssuerAndSerialNo(new X509(cert.getEncoded()));
        this.ski = null;
        this.expansionTime = new ASN1Date(date, true);
        this.contents = null;
    }

    public MLData(X509Certificate cert, Date date, boolean useSKI64) throws NoSuchAlgorithmException {
        this.iasn = null;
        this.ski = useSKI64 ? CMSUtils.generateSPKI64((X509Certificate)cert) : CMSUtils.generateSPKI160((X509Certificate)cert);
        this.expansionTime = new ASN1Date(date, true);
        this.contents = null;
    }

    public MLData(X509Certificate cert, Date date, MLReceiptPolicy policy) throws CertificateEncodingException, IOException {
        this.iasn = new IssuerAndSerialNo(new X509(cert.getEncoded()));
        this.ski = null;
        this.expansionTime = new ASN1Date(date, true);
        this.policy = policy;
        this.contents = null;
    }

    public MLData(X509Certificate cert, Date date, boolean useSKI64, MLReceiptPolicy policy) throws NoSuchAlgorithmException {
        this.iasn = null;
        this.ski = useSKI64 ? CMSUtils.generateSPKI64((X509Certificate)cert) : CMSUtils.generateSPKI160((X509Certificate)cert);
        this.expansionTime = new ASN1Date(date, true);
        this.policy = policy;
        this.contents = null;
    }

    public MLData(InputStream is) throws IOException {
        this.input(is);
        this.contents = null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MLData)) {
            return false;
        }
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)((MLData)o)));
    }

    public int hashCode() {
        return new String(Utils.toBytes((Streamable)this)).hashCode();
    }

    public IssuerAndSerialNo getIASN() {
        return this.iasn;
    }

    public byte[] getSKI() {
        return this.ski;
    }

    public ASN1Date getExpansionTime() {
        return this.expansionTime;
    }

    public MLReceiptPolicy getMLReceiptPolicy() {
        return this.policy;
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        if (seq.getCurrentTag() == 16) {
            this.iasn = new IssuerAndSerialNo((InputStream)seq);
            this.ski = null;
        } else if (seq.getCurrentTag() == 4) {
            this.iasn = null;
            this.ski = ASN1OctetString.inputValue((InputStream)seq);
        } else {
            throw new IOException("Unknown/Unsupported Entity Identifier Tag: " + seq.getCurrentTag());
        }
        this.expansionTime = new ASN1Date((InputStream)seq);
        if (seq.hasMoreData()) {
            this.policy = new MLReceiptPolicy((InputStream)seq);
        }
        seq.terminate();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            if (this.ski == null) {
                seq.addElement((ASN1Object)this.iasn);
            } else {
                seq.addElement((ASN1Object)new ASN1OctetString(this.ski));
            }
            seq.addElement((ASN1Object)this.expansionTime);
            if (this.policy != null) {
                seq.addElement((ASN1Object)this.policy);
            }
            this.contents = seq;
        }
        return this.contents;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Entity Identifier: ");
        if (this.iasn != null) {
            sb.append("IASN - " + this.iasn.toString());
        } else {
            sb.append("SPKI - " + Utils.toHexString((byte[])this.ski));
        }
        sb.append("\nExpansion Time: " + this.expansionTime.getValue());
        sb.append("\nMLReceiptPolicy: " + this.policy);
        return sb.toString();
    }
}

