/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.utils.comparator;

import oracle.dmt.dataminer.core.model.fe.common.Tag;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.model.filter.SortType;
import oracle.dmt.dataminer.core.utils.comparator.NullComparator;

public class TagComparator
extends NullComparator<Tag> {
    private SortType orderType;
    private SortDirection orderDirection;

    public TagComparator(SortType sortType, SortDirection sortDirection) {
        this.orderType = sortType;
        this.orderDirection = sortDirection;
    }

    @Override
    public int compareImpl(Tag tag, Tag tag2) {
        switch (this.orderType) {
            case NUMERICAL: {
                return SortDirection.ASCENDING.equals((Object)this.orderDirection) ? this.compareWeightThenText(tag, tag2) : this.compareWeightThenText(tag2, tag);
            }
        }
        return SortDirection.ASCENDING.equals((Object)this.orderDirection) ? this.compareTextThenSource(tag, tag2) : this.compareTextThenSource(tag2, tag);
    }

    public int compareWeightThenText(Tag tag, Tag tag2) {
        int n = Double.compare(tag.getWeight(), tag2.getWeight());
        if (n == 0) {
            return this.compareTextThenSource(tag, tag2);
        }
        return n;
    }

    private int compareTextThenSource(Tag tag, Tag tag2) {
        int n = 0;
        if (tag.getText() != null && tag2.getText() != null) {
            n = tag.getText().compareTo(tag2.getText());
        }
        if (n == 0) {
            return tag.getSource().compareTo(tag2.getSource());
        }
        return n;
    }
}

