/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.common.build;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDefaultMapper;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.MiningAttributeInfo;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetModelAttributesQuery
extends SqlQuery<MiningAttributeInfo, OraclePreparedStatement> {
    private static final String[] COLUMNS_11_2 = new String[]{"OWNER", "MODEL_NAME", "ATTRIBUTE_NAME", "ATTRIBUTE_TYPE", "DATA_TYPE", "DATA_LENGTH", "DATA_PRECISION", "DATA_SCALE", "USAGE_TYPE", "TARGET"};
    private static final String[] COLUMNS = new String[]{"OWNER", "MODEL_NAME", "ATTRIBUTE_NAME", "ATTRIBUTE_TYPE", "DATA_TYPE", "DATA_LENGTH", "DATA_PRECISION", "DATA_SCALE", "USAGE_TYPE", "TARGET", "ATTRIBUTE_SPEC"};
    private String _owner;
    private String _target;
    private String _dataType;
    private String _usageType;
    private List<String> _models = Collections.emptyList();

    public GetModelAttributesQuery(Version version) {
        super(version, new SqlDefaultMapper<MiningAttributeInfo>(MiningAttributeInfo.class));
    }

    @Override
    public String getSQLCommand() {
        String[] stringArray = DbVersionHelper.isDB121Up(this.dbVersion) ? COLUMNS : COLUMNS_11_2;
        SqlBuilder sqlBuilder = new SqlBuilder().select(stringArray).from("ALL_MINING_MODEL_ATTRIBUTES").where(Conditional.equals("OWNER", this._owner), Conditional.equals("TARGET", this._target), Conditional.equals("DATA_TYPE", this._dataType), Conditional.equals("USAGE_TYPE", this._usageType), Conditional.in("MODEL_NAME", this._models));
        String string = sqlBuilder.toString();
        return string;
    }

    public GetModelAttributesQuery setOwner(String string) {
        this._owner = string;
        return this;
    }

    public GetModelAttributesQuery setModels(List<String> list) {
        if (list != null) {
            this._models = list;
        }
        return this;
    }

    public GetModelAttributesQuery setModel(String string) {
        this._models = new ArrayList<String>(1);
        this._models.add(string);
        return this;
    }

    public GetModelAttributesQuery setDataType(String string) {
        this._dataType = string;
        return this;
    }

    public GetModelAttributesQuery setUsageType(String string) {
        this._usageType = string;
        return this;
    }

    public GetModelAttributesQuery setTarget(String string) {
        this._target = string;
        return this;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        if (StringUtils.isNotEmpty(this._owner)) {
            oraclePreparedStatement.setStringAtName("OWNER", this._owner);
        }
        if (StringUtils.isNotEmpty(this._target)) {
            oraclePreparedStatement.setStringAtName("TARGET", String.format("'%s'", this._target));
        }
        if (StringUtils.isNotEmpty(this._dataType)) {
            oraclePreparedStatement.setStringAtName("DATA_TYPE", String.format("'%s'", this._dataType));
        }
        if (StringUtils.isNotEmpty(this._usageType)) {
            oraclePreparedStatement.setStringAtName("USAGE_TYPE", String.format("'%s'", this._usageType));
        }
        if (!this._models.isEmpty()) {
            SqlUtils.setStringParameterList(oraclePreparedStatement, "MODEL_NAME", this._models);
        }
    }
}

