/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clus.common;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.mapping.clus.common.GetDivergenceHistogramCentroidMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.clus.ClusteringAlgorithm;
import oracle.dmt.dataminer.core.model.clus.compare.CompareClustersModelRow;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetDivergenceHistogramCentroidQuery
extends SqlBaseModelQuery<CompareClustersModelRow, OraclePreparedStatement> {
    private Integer clusterId1;
    private Integer clusterId2;
    private String clusterLabel1;
    private String clusterLabel2;
    private ClusteringAlgorithm algorithmType;
    private int numberOfRows;
    private ISqlQuery<OraclePreparedStatement> queryGenerator;

    public GetDivergenceHistogramCentroidQuery(Version version, ModelDescriptor modelDescriptor, Integer n, String string, Integer n2, String string2, int n3, ClusteringAlgorithm clusteringAlgorithm) {
        super(version, new GetDivergenceHistogramCentroidMapper(version, string, string2, n, n2), modelDescriptor);
        this.clusterId1 = n;
        this.clusterLabel1 = string;
        this.clusterId2 = n2;
        this.clusterLabel2 = string2;
        this.numberOfRows = n3;
        this.algorithmType = clusteringAlgorithm;
        this.queryGenerator = DbVersionHelper.isDB122Up(version) ? new DB12_2Query() : new DBOriginalQuery();
    }

    @Override
    protected String getSQLCommand() {
        String string = this.queryGenerator.getSQLCommand();
        return string;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        oraclePreparedStatement.setIntAtName("number_rows", this.numberOfRows);
        if (this.clusterId1 != null) {
            oraclePreparedStatement.setIntAtName("cluster_id1", this.clusterId1.intValue());
            if (this.algorithmType == ClusteringAlgorithm.OCLUSTER && this.clusterId2 == null) {
                this.clusterId2 = this.clusterId1;
            }
        } else {
            oraclePreparedStatement.setNullAtName("cluster_id1", 4);
        }
        SqlUtils.setIntOrNullAtName(oraclePreparedStatement, "cluster_id2", this.clusterId2);
        this.queryGenerator.setParameters(oraclePreparedStatement);
    }

    private class DB12_2Query
    implements ISqlQuery<OraclePreparedStatement> {
        String baseQuery = "WITH hist1 AS \n   (SELECT h.partition_name,\n           h.cluster_id,\n           h.attribute_name aname, \n           h.{$CATEGORICAL_VALUE},\n           h.count,\n           h.attribute_subname subname,\n           h.bin_id bin_id,\n           h.count/vd.record_count prob\n           {$BIN_BOUNDARY_COLUMNS}\n    FROM {$HISTOGRAM_VIEW} h\n    LEFT JOIN {$DESCRIPTION_VIEW} vd ON vd.cluster_id=h.cluster_id {$AND_PARTITION}\n    WHERE {$PARTITION} h.cluster_id=:cluster_id1 ),\n  hist2 AS\n   (SELECT h.partition_name,\n           h.cluster_id,\n           h.attribute_name aname,\n           h.{$CATEGORICAL_VALUE},\n           h.count,\n           h.attribute_subname subname,\n           h.bin_id bin_id,\n           h.count/vd.record_count prob\n           {$BIN_BOUNDARY_COLUMNS}\n    FROM {$HISTOGRAM_VIEW} h\n    LEFT JOIN {$DESCRIPTION_VIEW} vd ON vd.cluster_id=h.cluster_id {$AND_PARTITION}\n    WHERE {$PARTITION} h.cluster_id=:cluster_id2 )\nSELECT  divergence.ATTRIBUTE_NAME,\n        divergence.ATTRIBUTE_SUBNAME,\n        divergence.rnk,\n        divergence.sym_kld,\n        hist_cent_1.centroid centroid1,\n        hist_cent_1.histogram histogram1,\n        hist_cent_2.centroid centroid2,\n        hist_cent_2.histogram histogram2\nFROM (\n       WITH hist_av AS\n           (SELECT NVL(h1.aname, h2.aname) aname,\n                   NVL(h1.subname, h2.subname) subname,\n                   NVL(h1.bin_id, h2.bin_id) bin_id,\n                   (NVL(h1.prob,0) + NVL(h2.prob,0))/2 prob\n           FROM hist1 h1\n           FULL OUTER JOIN hist2 h2\n           ON h1.aname                 = h2.aname\n           AND NVL(h1.subname,h1.aname)=NVL(h2.subname, h2.aname)\n           AND h1.bin_id               = h2.bin_id),\n       kld AS\n          (SELECT aname,\n                  subname,\n                  SUM(kld)/2 sym_kld\n           FROM (\n                   SELECT ha.aname aname,\n                          ha.subname subname,\n                          SUM(h1.prob*ln(h1.prob/ha.prob)) kld\n                   FROM hist1 h1,\n                        hist_av ha\n                   WHERE h1.prob                > 0\n                   AND h1.aname                 = ha.aname\n                   AND NVL(h1.subname, h1.aname)=NVL(ha.subname, ha.aname)\n                   AND h1.bin_id                =ha.bin_id\n                   GROUP BY ha.aname, ha.subname\n                 UNION ALL\n                   SELECT ha.aname aname,\n                          ha.subname subname,\n                          SUM(h2.prob*ln(h2.prob/ha.prob)) kld\n                   FROM   hist2 h2,\n                          hist_av ha\n                   WHERE h2.prob                > 0\n                   AND h2.aname                 = ha.aname\n                   AND NVL(h2.subname, h2.aname)=NVL(ha.subname, ha.aname)\n                   AND h2.bin_id                =ha.bin_id\n                   GROUP BY ha.aname,ha.subname\n                )\n           GROUP BY aname,subname)\n       SELECT k.aname attribute_name,\n       k.subname attribute_subname,\n       rank() OVER (ORDER BY sym_kld DESC) rnk,\n       sym_kld\n       FROM kld k\n       ORDER BY rnk\n     ) divergence\nLEFT JOIN (\n            SELECT va.cluster_id,\n                   va.attribute_name,\n                   va.attribute_subname,\n                   CASE WHEN va.mean IS NULL THEN va.mode_value ELSE TO_CHAR(va.mean) END centroid,\n                   CAST( COLLECT(SYS.DM_HISTOGRAM_BIN(h.aname,h.subname,h.bin_id,{$LOWER_BIN_BOUNDARY},{$UPPER_BIN_BOUNDARY},h.{$CATEGORICAL_VALUE},h.count)) AS SYS.DM_HISTOGRAMS) histogram\n            FROM {$CENTROID_VIEW} va \n            RIGHT JOIN hist1 h ON h.cluster_id=va.cluster_id AND va.attribute_name=h.aname AND ((va.attribute_subname IS NULL) OR (va.attribute_subname=h.subname))\n            {$PARTITION_CONDITION}\n            GROUP BY (va.cluster_id,va.attribute_name,va.attribute_subname,va.mean,va.mode_value)\n          ) hist_cent_1 \nON  divergence.attribute_name=hist_cent_1.attribute_name AND ((divergence.attribute_subname IS NULL) OR (divergence.attribute_subname=hist_cent_1.attribute_subname))\nLEFT JOIN (\n            SELECT va.cluster_id,\n                   va.attribute_name,\n                   va.attribute_subname,\n                   CASE WHEN va.mean IS NULL THEN va.mode_value ELSE TO_CHAR(va.mean) END centroid,\n                   CAST( COLLECT(SYS.DM_HISTOGRAM_BIN(h.ANAME,h.SUBNAME,h.BIN_ID,{$LOWER_BIN_BOUNDARY},{$UPPER_BIN_BOUNDARY},h.{$CATEGORICAL_VALUE},h.COUNT)) AS SYS.DM_HISTOGRAMS) histogram\n            FROM {$CENTROID_VIEW} va \n            RIGHT JOIN hist2 h ON h.cluster_id=va.cluster_id AND va.attribute_name=h.aname AND ((va.attribute_subname IS NULL) OR (va.attribute_subname=h.subname))\n            {$PARTITION_CONDITION}\n            GROUP BY (va.cluster_id,va.attribute_name,va.attribute_subname,va.mean,va.mode_value)\n          ) hist_cent_2 \nON  divergence.attribute_name=hist_cent_2.attribute_name AND ((divergence.attribute_subname IS NULL) OR (divergence.attribute_subname=hist_cent_2.attribute_subname))\nWHERE rownum <= :number_rows\n";

        private DB12_2Query() {
        }

        @Override
        public String getSQLCommand() {
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "NULL";
            String string5 = "NULL";
            String string6 = "NULL";
            String string7 = "";
            if (GetDivergenceHistogramCentroidQuery.this.isPartitioned()) {
                string = " AND vd.partition_name=h.partition_name";
                string2 = " AND va.partition_name=h.partition_name \nWHERE va.partition_name = :partitionId \n";
                string3 = " vd.partition_name = :partitionId AND ";
            }
            if (ClusteringAlgorithm.KMEANS.equals((Object)GetDivergenceHistogramCentroidQuery.this.algorithmType) || ClusteringAlgorithm.EMCLUSTER.equals((Object)GetDivergenceHistogramCentroidQuery.this.algorithmType)) {
                string5 = "LOWER_BIN_BOUNDARY";
                string6 = "UPPER_BIN_BOUNDARY";
                string4 = "ATTRIBUTE_VALUE";
                string7 = ",LOWER_BIN_BOUNDARY,UPPER_BIN_BOUNDARY";
            } else if (GetDivergenceHistogramCentroidQuery.this.algorithmType == ClusteringAlgorithm.OCLUSTER) {
                string4 = "LABEL";
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("LOWER_BIN_BOUNDARY", string5);
            hashMap.put("UPPER_BIN_BOUNDARY", string6);
            hashMap.put("CATEGORICAL_VALUE", string4);
            hashMap.put("BIN_BOUNDARY_COLUMNS", string7);
            hashMap.put("PARTITION", string3);
            hashMap.put("PARTITION_CONDITION", string2);
            hashMap.put("AND_PARTITION", string);
            hashMap.put("DESCRIPTION_VIEW", GetDivergenceHistogramCentroidQuery.this.getViewName("DM$VD"));
            hashMap.put("CENTROID_VIEW", GetDivergenceHistogramCentroidQuery.this.getViewName("DM$VA"));
            hashMap.put("HISTOGRAM_VIEW", GetDivergenceHistogramCentroidQuery.this.getViewName("DM$VH"));
            String string8 = StringUtils.getReplacedString(this.baseQuery, hashMap);
            return string8;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "partitionId", GetDivergenceHistogramCentroidQuery.this.getPartitionId());
        }
    }

    private class DBOriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        String baseQuery = "WITH clus1_hist_cent AS(\n        SELECT t.cluster_id,\n             c.attribute_name aname, \n             c.attribute_subname subname,\n             ( SELECT CAST( COLLECT(SYS.DM_HISTOGRAM_BIN(h.attribute_name,\n                                                        h.attribute_subname,\n                                                        h.bin_id,\n                                                        h.lower_bound,\n                                                        h.upper_bound,\n                                                        h.label,\n                                                        h.count)) AS SYS.DM_HISTOGRAMS )\n                FROM TABLE(t.histogram) h\n                WHERE h.attribute_name=c.attribute_name\n                AND ((c.attribute_subname IS NULL) OR (h.attribute_subname=c.attribute_subname) )) histogram,\n             CASE WHEN c.mean IS NULL THEN c.mode_value ELSE TO_CHAR(c.mean) END centroid\n        FROM TABLE(DBMS_DATA_MINING.{$GET_MODEL_DETAILS} (:model,:cluster_id1, null, 1, 1, 0)) t, \n             TABLE(t.centroid) c),\n    clus2_hist_cent AS(\n        SELECT t.cluster_id,\n             c.attribute_name aname, \n             c.attribute_subname subname,\n             ( SELECT CAST( COLLECT(SYS.DM_HISTOGRAM_BIN(h.attribute_name,\n                                                        h.attribute_subname,\n                                                        h.bin_id,\n                                                        h.lower_bound,\n                                                        h.upper_bound,\n                                                        h.label,\n                                                        h.count)) AS SYS.DM_HISTOGRAMS )\n                FROM TABLE(t.histogram) h                 WHERE h.attribute_name=c.attribute_name \n                AND ( (c.attribute_subname IS NULL) OR (h.attribute_subname=c.attribute_subname) ) ) histogram,\n             CASE WHEN c.mean IS NULL THEN c.mode_value ELSE TO_CHAR(c.mean) END centroid\n        FROM TABLE(DBMS_DATA_MINING.{$GET_MODEL_DETAILS} (:model,:cluster_id2, null, 1, 1, 0)) t, \n             TABLE(t.centroid) c) \nSELECT divergence.attribute_name,  \n   divergence.attribute_subname, \n   divergence.rnk, \n   divergence.sym_kld,  \n   c1.centroid centroid1, \n   c1.histogram histogram1, \n   c2.centroid centroid2,  \n   c2.histogram histogram2 \nFROM (\n       WITH node1 AS (\n                       SELECT t.record_count rec_cnt,\n                              t.histogram\n                       FROM TABLE(DBMS_DATA_MINING.{$GET_MODEL_DETAILS}(:model,:cluster_id1,NULL, 0, 1, 0)) t),\n            node2 AS (\n                       SELECT t.record_count rec_cnt,\n                              t.histogram\n                       FROM TABLE(DBMS_DATA_MINING.{$GET_MODEL_DETAILS}(:model,:cluster_id2,NULL, 0, 1, 0)) t),\n            hist1 AS (\n                       SELECT h.attribute_name aname,\n                              h.attribute_subname subname,\n                              h.bin_id bin_id,\n                              h.count/t.rec_cnt prob\n                       FROM node1 t, \n                            TABLE(t.histogram) h),\n            hist2 AS (\n                       SELECT h.attribute_name aname,\n                              h.attribute_subname subname,\n                              h.bin_id bin_id,\n                              h.count/rec_cnt prob\n                       FROM node2 t, \n                            TABLE(t.histogram) h),\n            hist_av AS(\n                       SELECT nvl(h1.aname, h2.aname) aname,\n                              nvl(h1.subname, h2.subname) subname, \n                              nvl(h1.bin_id, h2.bin_id) bin_id,\n                              (nvl(h1.prob,0) + nvl(h2.prob,0))/2 prob \n                       FROM hist1 h1 full outer join hist2 h2 \n                       ON h1.aname = h2.aname \n                       AND nvl(h1.subname,h1.aname)=nvl(h2.subname, h2.aname)\n                       AND h1.bin_id = h2.bin_id),\n            kld AS (\n                       SELECT aname, \n                           subname, \n                           sum(kld)/2 sym_kld\n                       FROM ( SELECT h2.aname aname, \n                                     h2.subname subname, \n                                     sum(h1.prob*ln(h1.prob/h2.prob)) kld\n                              FROM hist1 h1, \n                                   hist_av h2\n                              WHERE h1.prob > 0 \n                              AND h1.aname = h2.aname \n                              AND nvl(h1.subname, h1.aname)=nvl(h2.subname, h2.aname) \n                              AND h1.bin_id=h2.bin_id \n                              GROUP BY h2.aname, h2.subname\n                            UNION ALL\n                               SELECT h2.aname aname, h2.subname subname, \n                                      sum(h1.prob*ln(h1.prob/h2.prob)) kld\n                               FROM   hist2 h1, \n                                      hist_av h2\n                               WHERE h1.prob > 0 \n                               AND h1.aname = h2.aname \n                               AND nvl(h1.subname, h1.aname)=nvl(h2.subname, h2.aname) \n                               AND h1.bin_id=h2.bin_id \n                               GROUP BY h2.aname, h2.subname )\n                       GROUP BY aname, subname)\n       SELECT k.aname attribute_name, \n              k.subname ATTRIBUTE_SUBNAME,  \n              rank() OVER (ORDER BY sym_kld DESC) rnk, \n              sym_kld \n       FROM kld k\n       ORDER BY rnk    ) divergence\n LEFT JOIN clus2_hist_cent c2 ON divergence.ATTRIBUTE_NAME=c2.aname AND ((divergence.ATTRIBUTE_SUBNAME IS NULL) OR (divergence.ATTRIBUTE_SUBNAME=c2.subname))\n LEFT JOIN clus1_hist_cent c1 ON divergence.ATTRIBUTE_NAME=c1.aname AND ((divergence.ATTRIBUTE_SUBNAME IS NULL) OR (divergence.ATTRIBUTE_SUBNAME=c1.subname))\nwhere rownum <= :number_rows";

        private DBOriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            String string = GetDivergenceHistogramCentroidQuery.this.algorithmType.getTableFunctionName();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("GET_MODEL_DETAILS", string);
            String string2 = StringUtils.getReplacedString(this.baseQuery, hashMap);
            return string2;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName("model", GetDivergenceHistogramCentroidQuery.this.getQualifiedName());
        }
    }
}

