/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clus.common;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.mapping.clus.common.GetClusterModelDetailsQueryMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.clus.ClusteringAlgorithm;
import oracle.dmt.dataminer.core.model.clus.ClusteringDetailRow;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetClusterModelDetailsQuery
extends SqlBaseModelQuery<ClusteringDetailRow, OraclePreparedStatement> {
    private int topN;
    private boolean levelDetailsAll;
    private ClusteringAlgorithm algorithmType;
    private ISqlQuery<OraclePreparedStatement> queryGenerator;

    public GetClusterModelDetailsQuery(Version version, ModelDescriptor modelDescriptor, int n, ClusteringAlgorithm clusteringAlgorithm, boolean bl) {
        super(version, new GetClusterModelDetailsQueryMapper(version, clusteringAlgorithm, bl), modelDescriptor);
        this.algorithmType = clusteringAlgorithm;
        this.topN = n;
        this.levelDetailsAll = bl;
        this.queryGenerator = DbVersionHelper.isDB122Up(version) ? new DB12_2Query() : (DbVersionHelper.isDB121(version) ? new DB12Query() : new DB11Query());
    }

    @Override
    public String getSQLCommand() {
        String string = this.queryGenerator.getSQLCommand();
        return string;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.queryGenerator.setParameters(oraclePreparedStatement);
    }

    private class DB12_2Query
    implements ISqlQuery<OraclePreparedStatement> {
        private String baseQuery = "{$PREDICATES}{$CENTROID_RULE}SELECT vd.CLUSTER_ID,\n       vd.CLUSTER_NAME,\n       vd.RECORD_COUNT,\n       vd.PARENT,\n       vd.TREE_LEVEL,\n       vd.LEFT_CHILD_ID,\n       vd.RIGHT_CHILD_ID\n       {$CENTROID_RULE_COLUMNS}\n       {$EXTRA_COLUMNS}\nFROM {$DESCRIPTION_VIEW} vd\n{$CENTROID_RULE_JOIN} {$SPLIT_PREDICATE_JOIN} {$PARTITION}\n";

        private DB12_2Query() {
        }

        @Override
        public String getSQLCommand() {
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            Object object = "";
            String string5 = "";
            if (GetClusterModelDetailsQuery.this.levelDetailsAll) {
                string4 = ",centroids.CENTROID\n       ,rules.RULE";
                if (!ClusteringAlgorithm.OCLUSTER.equals((Object)GetClusterModelDetailsQuery.this.algorithmType)) {
                    object = (String)object + "WITH";
                }
                object = (String)object + " attributes_order_by_confidence AS\n   (SELECT     CLUSTER_ID,\n               ATTRIBUTE_NAME,\n               ATTRIBUTE_SUBNAME\n    FROM\n         ( SELECT   ad.CLUSTER_ID,\n                    ad.ATTRIBUTE_NAME,\n                    ad.ATTRIBUTE_SUBNAME,\n                    ad.CONFIDENCE,\n                    ROW_NUMBER() OVER (PARTITION BY ad.CLUSTER_ID ORDER BY ad.CONFIDENCE desc) RN\n           FROM     (SELECT DISTINCT CONFIDENCE,\n                                     CLUSTER_ID,\n                                     ATTRIBUTE_NAME,\n                                     ATTRIBUTE_SUBNAME \n                     FROM {$RULE_VIEW} \n                          {$PARTITION} \n                     ORDER BY CLUSTER_ID,\n                              CONFIDENCE DESC ) ad)\n     WHERE RN <= :topN ),\ncentroids AS\n   (SELECT va.CLUSTER_ID, \n           CAST(COLLECT(SYS.DM_CENTROID(va.ATTRIBUTE_NAME,\n                                        va.ATTRIBUTE_SUBNAME,\n                                        va.MEAN,\n                                        va.MODE_VALUE,\n                                        va.VARIANCE))AS SYS.DM_CENTROIDS) AS CENTROID\n   FROM {$CENTROID_VIEW} va   RIGHT JOIN attributes_order_by_confidence oa ON oa.CLUSTER_ID = va.CLUSTER_ID \n                                                 AND oa.ATTRIBUTE_NAME=va.ATTRIBUTE_NAME\n                                                 AND ((oa.ATTRIBUTE_SUBNAME IS NULL) OR (oa.ATTRIBUTE_SUBNAME=va.ATTRIBUTE_SUBNAME))\n   {$PARTITION}\n   GROUP BY va.CLUSTER_ID),\nrules AS\n   (SELECT vr.CLUSTER_ID,\n           SYS.DM_RULE(vr.CLUSTER_ID,\n                       CAST(COLLECT(SYS.DM_PREDICATE(vr.ATTRIBUTE_NAME,\n                                                     vr.ATTRIBUTE_SUBNAME,\n                                                     vr.OPERATOR,\n                                                     vr.NUMERIC_VALUE,\n                                                     vr.ATTRIBUTE_VALUE,\n                                                     vr.SUPPORT,\n                                                     vr.CONFIDENCE)) AS SYS.DM_PREDICATES), \n                                                     NULL,\n                                                     vr.RULE_SUPPORT,\n                                                     vr.RULE_CONFIDENCE,\n                                                     NULL,\n                                                     NULL,\n                                                     NULL,\n                                                     NULL) AS RULE\n    FROM {$RULE_VIEW} vr    RIGHT JOIN attributes_order_by_confidence oa ON oa.CLUSTER_ID = vr.CLUSTER_ID \n                                                 AND oa.ATTRIBUTE_NAME=vr.ATTRIBUTE_NAME\n                                                 AND ((oa.ATTRIBUTE_SUBNAME IS NULL) OR (oa.ATTRIBUTE_SUBNAME=vr.ATTRIBUTE_SUBNAME))\n    {$PARTITION}\n    GROUP BY(vr.CLUSTER_ID,vr.RULE_SUPPORT,vr.RULE_CONFIDENCE) )\n";
                string5 = "LEFT JOIN rules ON rules.CLUSTER_ID = vd.CLUSTER_ID\nLEFT JOIN centroids ON centroids.CLUSTER_ID=vd.CLUSTER_ID\n";
            }
            if (ClusteringAlgorithm.OCLUSTER.equals((Object)GetClusterModelDetailsQuery.this.algorithmType)) {
                string2 = "WITH predicates AS \n    (SELECT vd.CLUSTER_ID,\n       CAST(COLLECT(SYS.DM_PREDICATE(  vd.ATTRIBUTE_NAME,\n                                       vd.ATTRIBUTE_SUBNAME,\n                                       vd.OPERATOR,\n                                       NULL,\n                                       xml_value.ELEMENT_VALUE,\n                                       NULL,\n                                       NULL)) AS SYS.DM_PREDICATES)  AS SPLIT_PREDICATE\n    FROM {$DESCRIPTION_VIEW} vd, XMLTable (  '/Element'  \n                                             PASSING vd.VALUE\n                                             COLUMNS  \n                                             ELEMENT_VALUE VARCHAR2(4000) PATH '.'\n                                           ) xml_value  {$PARTITION}    GROUP BY vd.CLUSTER_ID ),\n";
                string = ",predicates.SPLIT_PREDICATE";
                string3 = "LEFT JOIN predicates ON predicates.CLUSTER_ID=vd.CLUSTER_ID\n";
            } else if (ClusteringAlgorithm.KMEANS.equals((Object)GetClusterModelDetailsQuery.this.algorithmType)) {
                string = ",vd.DISPERSION\n";
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("PREDICATES", string2);
            hashMap.put("CENTROID_RULE", (String)object);
            String string6 = StringUtils.getReplacedString(this.baseQuery, hashMap);
            String string7 = GetClusterModelDetailsQuery.this.isPartitioned() ? " WHERE PARTITION_NAME = :partitionId" : "";
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("CENTROID_RULE_COLUMNS", string4);
            hashMap2.put("CENTROID_RULE_JOIN", string5);
            hashMap2.put("CENTROID_VIEW", GetClusterModelDetailsQuery.this.getViewName("DM$VA"));
            hashMap2.put("RULE_VIEW", GetClusterModelDetailsQuery.this.getViewName("DM$VR"));
            hashMap2.put("SPLIT_PREDICATE_JOIN", string3);
            hashMap2.put("EXTRA_COLUMNS", string);
            hashMap2.put("PARTITION", string7);
            hashMap2.put("DESCRIPTION_VIEW", GetClusterModelDetailsQuery.this.getViewName("DM$VD"));
            String string8 = StringUtils.getReplacedString(string6, hashMap2);
            return string8;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "partitionId", GetClusterModelDetailsQuery.this.getPartitionId());
            if (GetClusterModelDetailsQuery.this.levelDetailsAll) {
                SqlUtils.setIntAtName(oraclePreparedStatement, "topN", GetClusterModelDetailsQuery.this.topN);
            }
        }
    }

    private class DB12Query
    implements ISqlQuery<OraclePreparedStatement> {
        String baseQuery = "SELECT id,\n       cluster_id,\n       record_count,\n       parent,\n       tree_level,\n       dispersion,\n       split_predicate,\n       child\n       {$DETAILS}\n FROM TABLE(DBMS_DATA_MINING.{$GET_MODEL_DETAILS}(:model,NULL,NULL,1,0,2,{$ATTRIBUTE_SUBNAME}:topn))\n";

        public DB12Query() {
            assert (ClusteringAlgorithm.EMCLUSTER.equals((Object)GetClusterModelDetailsQuery.this.algorithmType) || GetClusterModelDetailsQuery.this.levelDetailsAll) : "Incompatible model to build with less Level Details";
        }

        @Override
        public String getSQLCommand() {
            String string = GetClusterModelDetailsQuery.this.algorithmType.getTableFunctionName();
            String string2 = "";
            String string3 = "";
            if (ClusteringAlgorithm.KMEANS.equals((Object)GetClusterModelDetailsQuery.this.algorithmType) || ClusteringAlgorithm.EMCLUSTER.equals((Object)GetClusterModelDetailsQuery.this.algorithmType)) {
                string2 = ":attributesubname,";
            }
            if (GetClusterModelDetailsQuery.this.levelDetailsAll) {
                string3 = ",centroid, RULE";
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("GET_MODEL_DETAILS", string);
            hashMap.put("ATTRIBUTE_SUBNAME", string2);
            hashMap.put("DETAILS", string3);
            String string4 = StringUtils.getReplacedString(this.baseQuery, hashMap);
            return string4;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName("model", GetClusterModelDetailsQuery.this.getQualifiedName());
            SqlUtils.setIntAtName(oraclePreparedStatement, "topn", GetClusterModelDetailsQuery.this.topN);
            if (!ClusteringAlgorithm.OCLUSTER.equals((Object)GetClusterModelDetailsQuery.this.algorithmType)) {
                oraclePreparedStatement.setNullAtName("attributesubname", 12);
            }
        }
    }

    private class DB11Query
    implements ISqlQuery<OraclePreparedStatement> {
        String baseQuery = "WITH first_query AS\n  (SELECT a.ID,\n    d.attribute_name,\n    d.attribute_subname,\n    d.attribute_confidence,\n    nvl2 (d.attribute_subname, d.attribute_name\n    || '.'\n    || d.attribute_subname, d.attribute_name) full_name\n   FROM TABLE(DBMS_DATA_MINING.{$GET_MODEL_DETAILS}(:model_name,null,null,0,0,2{$ATTRIBUTE_SUBNAME})) a,\n    TABLE(a.rule.ANTECEDENT) D\n  ),\n  antecedents_query AS\n  (SELECT id,\n    attribute_name,\n    attribute_subname,\n    attribute_confidence,\n    full_name\n  FROM first_query order by attribute_confidence desc, full_name\n  ),\n  top_items_txn_query AS\n  (SELECT id,\n    attribute_name,\n    attribute_subname,\n    attribute_confidence,\n    full_name,\n    ROW_NUMBER () over (partition BY id order by attribute_confidence DESC) AS rank\n  FROM antecedents_query\n  GROUP BY id,\n    attribute_name,\n    attribute_subname,\n    attribute_confidence,\n    full_name\n  ),\n  top_items_txn_filtered AS\n  (SELECT /*+ MATERIALIZE */ * FROM top_items_txn_query WHERE rank <= :topN\n  ),\n centroid_subq AS\n  (SELECT /*+ MATERIALIZE */ A.id, c.*\n   FROM\n    TABLE(DBMS_DATA_MINING.{$GET_MODEL_DETAILS}(:model_name,null,null,1,0,0{$ATTRIBUTE_SUBNAME})) a,\n    TABLE (A.centroid) c\n  ),\n  centroids_txn AS\n  (SELECT\n    c.*,\n    top_items_txn_filtered.attribute_confidence,\n    top_items_txn_filtered.rank\n    FROM centroid_subq c,\n    top_items_txn_filtered\n  WHERE c.id = top_items_txn_filtered.id\n  AND nvl2 (c.attribute_subname, c.attribute_name\n    || '.'\n    || c.attribute_subname, c.attribute_name) = top_items_txn_filtered.full_name\n  ),\n  top_centroids_txn AS\n  (SELECT *\n  FROM\n    (SELECT id,\n      attribute_name,\n      attribute_subname,\n      attribute_confidence,\n      mean,\n      mode_value,\n      variance,\n      rank\n    FROM centroids_txn\n    )\n  ),\n  top_centroids AS\n    (SELECT id,\n      CAST (collect (DM_CENTROID (attribute_name, attribute_subname, mean, mode_value, variance)) AS DM_CENTROIDS) AS centroid\n    FROM top_centroids_txn\n    GROUP BY ID\n    )\n SELECT clusters.id, \n    clusters.cluster_id, \n    clusters.record_count, \n    clusters.parent, \n    clusters.tree_level, \n    clusters.dispersion, \n    clusters.split_predicate, \n    clusters.child, \n    top_centroids.centroid,\n    clusters.rule \n  FROM\n    TABLE(DBMS_DATA_MINING.{$GET_MODEL_DETAILS}(:model_name,null,null,0,0,2{$ATTRIBUTE_SUBNAME})) clusters,\n  top_centroids\nWHERE clusters.ID = top_centroids.ID(+)\n order by id";

        private DB11Query() {
            assert (!ClusteringAlgorithm.EMCLUSTER.equals((Object)GetClusterModelDetailsQuery.this.algorithmType)) : "Incompatible Model";
        }

        @Override
        public String getSQLCommand() {
            String string = GetClusterModelDetailsQuery.this.algorithmType.getTableFunctionName();
            String string2 = "";
            if (ClusteringAlgorithm.KMEANS.equals((Object)GetClusterModelDetailsQuery.this.algorithmType)) {
                string2 = ",:attributesubname";
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("GET_MODEL_DETAILS", string);
            hashMap.put("ATTRIBUTE_SUBNAME", string2);
            String string3 = StringUtils.getReplacedString(this.baseQuery, hashMap);
            return string3;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            if (ClusteringAlgorithm.KMEANS.equals((Object)GetClusterModelDetailsQuery.this.algorithmType)) {
                oraclePreparedStatement.setNullAtName("attributesubname", 12);
            }
            SqlUtils.setIntAtName(oraclePreparedStatement, "topN", GetClusterModelDetailsQuery.this.topN);
            oraclePreparedStatement.setStringAtName("model_name", GetClusterModelDetailsQuery.this.getQualifiedName());
        }
    }
}

