/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.clas.glm;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.mapping.clas.glm.GetCoefficientsMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.clas.common.GLMCoefficient;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.filter.SortSpec;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetCoefficientsQuery
extends SqlBaseModelQuery<GLMCoefficient, OraclePreparedStatement> {
    private Object targetValue;
    private boolean flipSign;
    private Integer fetchSize;
    private boolean filterAndSortByAbs;
    private List<SortSpec> sorting;
    private boolean isClassification;
    private ISqlQuery<OraclePreparedStatement> query;
    private static final String BASE_QUERY = "select * from ( \n  select * from ( \n    select * from ( \n      select nvl2(ATTRIBUTE_SUBNAME,ATTRIBUTE_NAME || '.' || ATTRIBUTE_SUBNAME, ATTRIBUTE_NAME) \"ATTRIBUTE_NAME_SUBNAME\", \n             {$FEATURE_EXPRESSION}             ATTRIBUTE_NAME ATTRIBUTE_NAME, ATTRIBUTE_VALUE ATTRIBUTE_VALUE, COEFFICIENT COEFFICIENT, \n             STD_ERROR, TEST_STATISTIC, P_VALUE, STD_COEFFICIENT STD_COEFFICIENT, \n             LOWER_COEFF_LIMIT, UPPER_COEFF_LIMIT, EXP_COEFFICIENT, EXP_LOWER_COEFF_LIMIT, EXP_UPPER_COEFF_LIMIT \n      from \n        (select ATTRIBUTE_NAME, ATTRIBUTE_SUBNAME, {$FEATURE_EXPRESSION} ATTRIBUTE_VALUE,\n                STD_ERROR, TEST_STATISTIC, P_VALUE, {$STD_COEFFICIENT}, \n                {$LOWER_COEFF_LIMIT}, {$UPPER_COEFF_LIMIT}, {$EXP_COEFFICIENT}, {$EXP_LOWER_COEFF_LIMIT}, \n                {$EXP_UPPER_COEFF_LIMIT}, {$COEFFICIENT_VALUE} \n         from {$TABLE} \n         {$PARTITION} \n         {$TARGET}) \n    )\n  ) {$ORDER_BY} \n) {$FETCH_SIZE}";

    public GetCoefficientsQuery(Version version, ModelDescriptor modelDescriptor, Object object, boolean bl, boolean bl2, List<SortSpec> list, Integer n) {
        super(version, new GetCoefficientsMapper(version), modelDescriptor);
        assert (list != null) : "Sorting can not be null";
        this.targetValue = object;
        this.flipSign = bl;
        this.fetchSize = n;
        this.filterAndSortByAbs = bl2;
        this.sorting = list;
        this.isClassification = true;
        this.initQueryInstance(version);
    }

    public GetCoefficientsQuery(Version version, ModelDescriptor modelDescriptor, boolean bl, boolean bl2, List<SortSpec> list, Integer n) {
        this(version, modelDescriptor, null, bl, bl2, list, n);
        this.isClassification = false;
        this.initQueryInstance(version);
    }

    private void initQueryInstance(Version version) {
        this.query = DbVersionHelper.isDB122Up(version) ? new Db122Query() : new OriginalQuery();
    }

    @Override
    public String getSQLCommand() {
        return this.query.getSQLCommand();
    }

    private String replaceStringSQLCommon(String string) {
        Object object;
        Object object2;
        String string2 = this.flipSign ? "nvl(-coefficient,0) as coefficient" : "coefficient";
        String string3 = this.flipSign ? "nvl(-STD_COEFFICIENT,0) as STD_COEFFICIENT" : "STD_COEFFICIENT";
        String string4 = this.flipSign ? "( nvl(TO_BINARY_DOUBLE(-coefficient),0) + (nvl(TO_BINARY_DOUBLE(UPPER_COEFF_LIMIT),0) - nvl(TO_BINARY_DOUBLE(coefficient),0))) as UPPER_COEFF_LIMIT" : "UPPER_COEFF_LIMIT";
        String string5 = this.flipSign ? "(nvl(TO_BINARY_DOUBLE(-coefficient),0) - (nvl(TO_BINARY_DOUBLE(UPPER_COEFF_LIMIT),0) - nvl(TO_BINARY_DOUBLE(coefficient),0))) as LOWER_COEFF_LIMIT" : "LOWER_COEFF_LIMIT";
        String string6 = this.flipSign ? "exp(nvl(TO_BINARY_DOUBLE(-coefficient),0))  as EXP_COEFFICIENT" : "EXP_COEFFICIENT";
        String string7 = this.flipSign ? "exp( ( nvl(TO_BINARY_DOUBLE(-coefficient),0) - ( nvl(TO_BINARY_DOUBLE(UPPER_COEFF_LIMIT),0) - nvl(TO_BINARY_DOUBLE(coefficient),0)))  )  as EXP_LOWER_COEFF_LIMIT" : "EXP_LOWER_COEFF_LIMIT";
        String string8 = this.flipSign ? "exp( ( nvl(TO_BINARY_DOUBLE(-coefficient),0) + ( nvl(TO_BINARY_DOUBLE(UPPER_COEFF_LIMIT),0) - nvl(TO_BINARY_DOUBLE(coefficient),0)))  )  as EXP_UPPER_COEFF_LIMIT" : "EXP_UPPER_COEFF_LIMIT";
        List<SortSpec> list = SortSpec.getEnabledSortSpec(this.sorting);
        StringBuilder stringBuilder = new StringBuilder();
        if (list.size() > 0) {
            stringBuilder.append("order by ");
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (SortSpec)object2.next();
                if ("attribute_name_subname".equals(((SortSpec)object).getAttributeName()) || ((SortSpec)object).getAttributeName().equals("ATTRIBUTE_VALUE")) {
                    stringBuilder.append(((SortSpec)object).getAttributeName());
                    stringBuilder.append(" ");
                } else if (this.filterAndSortByAbs) {
                    if (((SortSpec)object).isUseIt()) {
                        stringBuilder.append("ABS(");
                    }
                    stringBuilder.append(((SortSpec)object).getAttributeName());
                    if (((SortSpec)object).isUseIt()) {
                        stringBuilder.append(")");
                    }
                    stringBuilder.append(" ");
                } else {
                    stringBuilder.append(((SortSpec)object).getAttributeName());
                    stringBuilder.append(" ");
                }
                if (((SortSpec)object).isAscending()) {
                    stringBuilder.append("ASC ");
                } else {
                    stringBuilder.append("DESC NULLS LAST ");
                }
                if (!object2.hasNext()) continue;
                stringBuilder.append(",");
            }
        }
        object2 = this.fetchSize != null ? " where rownum <= " + this.fetchSize : "";
        string7 = !this.isClassification ? "null AS EXP_LOWER_COEFF_LIMIT" : string7;
        string8 = !this.isClassification ? "null AS EXP_UPPER_COEFF_LIMIT" : string8;
        string6 = !this.isClassification ? "null AS EXP_COEFFICIENT" : string6;
        object = new HashMap();
        object.put("COEFFICIENT_VALUE", string2);
        object.put("STD_COEFFICIENT", string3);
        object.put("UPPER_COEFF_LIMIT", string4);
        object.put("LOWER_COEFF_LIMIT", string5);
        object.put("EXP_COEFFICIENT", string6);
        object.put("EXP_LOWER_COEFF_LIMIT", string7);
        object.put("EXP_UPPER_COEFF_LIMIT", string8);
        object.put("ORDER_BY", stringBuilder.toString());
        object.put("FETCH_SIZE", object2);
        String string9 = StringUtils.getReplacedString(string, (Map<String, String>)object);
        return string9;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        if (this.isClassification) {
            if (this.targetValue instanceof Number) {
                oraclePreparedStatement.setBigDecimalAtName("target", BigDecimal.valueOf(((Number)this.targetValue).doubleValue()));
            } else {
                oraclePreparedStatement.setStringAtName("target", this.targetValue.toString());
            }
        }
        this.query.setParameters(oraclePreparedStatement);
    }

    private class Db122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private Db122Query() {
        }

        @Override
        public String getSQLCommand() {
            String string = GetCoefficientsQuery.this.replaceStringSQLCommon(GetCoefficientsQuery.BASE_QUERY);
            Object object = "";
            if (GetCoefficientsQuery.this.isClassification) {
                object = GetCoefficientsQuery.this.isPartitioned() ? (String)object + "and " : (String)object + "where ";
                object = (String)object + "TARGET_VALUE = :target";
            }
            String string2 = GetCoefficientsQuery.this.isPartitioned() ? "where PARTITION_NAME = :partitionId" : "";
            String string3 = GetCoefficientsQuery.this.getViewName("DM$VD");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("FEATURE_EXPRESSION", "FEATURE_EXPRESSION, \n");
            hashMap.put("PARTITION", string2);
            hashMap.put("TABLE", string3);
            hashMap.put("TARGET", (String)object);
            String string4 = StringUtils.getReplacedString(string, hashMap);
            return string4;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "partitionId", GetCoefficientsQuery.this.getPartitionId());
        }
    }

    private class OriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private OriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            String string = GetCoefficientsQuery.this.replaceStringSQLCommon(GetCoefficientsQuery.BASE_QUERY);
            String string2 = GetCoefficientsQuery.this.isClassification ? "WHERE CLASS = :target" : "";
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("FEATURE_EXPRESSION", "");
            hashMap.put("TABLE", "table(DBMS_DATA_MINING.GET_MODEL_DETAILS_GLM(:model))");
            hashMap.put("PARTITION", "");
            hashMap.put("TARGET", string2);
            String string3 = StringUtils.getReplacedString(string, hashMap);
            return string3;
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName("model", GetCoefficientsQuery.this.getQualifiedName());
        }
    }
}

