/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.mapping.clas.common;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionColumn;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionTestResult;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;

public class GetModelPartitionsMapper
extends SqlMapper<PartitionTestResult> {
    private double testRowCount;
    private double buildRowCount;
    private Map<String, Date> mapModelDates;
    private Map<String, String> mapModelAlgo;

    public GetModelPartitionsMapper(double d, double d2, Map<String, Date> map, Map<String, String> map2) {
        this.testRowCount = d;
        this.buildRowCount = d2;
        this.mapModelDates = map;
        this.mapModelAlgo = map2;
    }

    @Override
    public PartitionTestResult map(ResultSet resultSet) throws Exception {
        PartitionTestResult partitionTestResult = new PartitionTestResult();
        StringBuilder stringBuilder = new StringBuilder();
        partitionTestResult.setModelName(resultSet.getString("MODEL_NAME"));
        String string = resultSet.getString("PARTITION_NAME");
        String string2 = resultSet.getString("ATTRIBUTE_NAME");
        String string3 = resultSet.getString("DATA_TYPE");
        String string4 = resultSet.getString("COLUMN_VALUE");
        String string5 = resultSet.getString("METRICS");
        String string6 = resultSet.getString("METRICS_VALUES");
        String[] stringArray = string2.split(Character.toString('\u0000'));
        String[] stringArray2 = string3.split(Character.toString('\u0000'));
        String[] stringArray3 = string4.split(Character.toString('\u0000'));
        String[] stringArray4 = string5.split(Character.toString('\u0000'));
        String[] stringArray5 = string6.split(Character.toString('\u0000'));
        ArrayList<PartitionColumn> arrayList = new ArrayList<PartitionColumn>();
        for (int i = 0; i < stringArray.length; ++i) {
            PartitionColumn partitionColumn = new PartitionColumn(stringArray[i], stringArray2[i], stringArray3[i]);
            arrayList.add(partitionColumn);
            stringBuilder.append(stringArray3[i]);
            stringBuilder.append("_");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        PartitionVO partitionVO = new PartitionVO(string, stringBuilder.toString(), arrayList);
        partitionTestResult.setPartitionInfo(partitionVO);
        int n = 0;
        String[] stringArray6 = stringArray4;
        int n2 = stringArray6.length;
        block25: for (int i = 0; i < n2; ++i) {
            String string7;
            switch (string7 = stringArray6[i]) {
                case "ACCURACY": {
                    partitionTestResult.setClassOverallAccuracy(Double.parseDouble(stringArray5[n++]));
                    continue block25;
                }
                case "AVG_ACCURACY": {
                    partitionTestResult.setClassAverageAccuracy(Double.parseDouble(stringArray5[n++]));
                    continue block25;
                }
                case "COST": {
                    partitionTestResult.setClassCost(Double.parseDouble(stringArray5[n++]));
                    continue block25;
                }
                case "MEAN_ABSOLUTE_ERROR": {
                    partitionTestResult.setRegMeanAbsoluteError(Double.parseDouble(stringArray5[n++]));
                    continue block25;
                }
                case "MEAN_ACTUAL_VALUE": {
                    partitionTestResult.setRegMeanActualValue(Double.parseDouble(stringArray5[n++]));
                    continue block25;
                }
                case "MEAN_PREDICATED_VALUE": {
                    partitionTestResult.setRegMeanPredictedValue(Double.parseDouble(stringArray5[n++]));
                    continue block25;
                }
                case "MEAN_RMS_ERROR": {
                    partitionTestResult.setRegRootMeanSquareError(Double.parseDouble(stringArray5[n++]));
                    continue block25;
                }
                case "PREDICTIVE_CONFIDENCE": {
                    partitionTestResult.setPredictiveConfidence(Double.parseDouble(stringArray5[n++]));
                    continue block25;
                }
                case "NUM_ROWS": {
                    partitionTestResult.setBuildRows(Integer.parseInt(stringArray5[n++]));
                    continue block25;
                }
                case "TEST_ROWS": {
                    partitionTestResult.setTestRows(Integer.parseInt(stringArray5[n++]));
                    continue block25;
                }
                default: {
                    assert (false) : "Missing metric";
                    continue block25;
                }
            }
        }
        partitionTestResult.setBuildRowsPercent((double)partitionTestResult.getBuildRows().intValue() / this.buildRowCount * 100.0);
        partitionTestResult.setTestRowsPercent((double)partitionTestResult.getTestRows().intValue() / this.testRowCount * 100.0);
        partitionTestResult.setAlgorithmType(this.mapModelAlgo.get(partitionTestResult.getModelName()));
        partitionTestResult.setCreationDate(this.mapModelDates.get(partitionTestResult.getModelName()));
        return partitionTestResult;
    }
}

