/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.Ide;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.PropertyAccess;
import oracle.jdeveloper.debugger.support.DebuggerDataWindowOptions;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.InspectorController;
import oracle.jdevimpl.runner.debug.InspectorPanel;
import oracle.jdevimpl.runner.debug.InspectorWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

final class InspectorWindow
extends DataWindow {
    static final String INSPECTOR_WINDOW_ID = "Debugger.InspectorWindow";
    private static int countInspectorWindows = 0;
    static final String EXP_HISTORY_NAME = "DebuggerInspector";
    private InspectorPanel inspectorPanel;

    InspectorWindow(String windowId, Object expression) {
        super(windowId, DbgArb.getString(557), "f1_deb_inspectorwindow_html");
        if (expression != null) {
            this.inspectorPanel = new InspectorPanel(this, expression, InspectorWindowSettings.getInstance());
        } else {
            this.inspectorPanel = new InspectorPanel(this, InspectorWindowSettings.getInstance());
            InspectorWindow.useInspectorWindowId(windowId);
        }
    }

    @Override
    protected final DataPanel getDataPanel(boolean forceCreate) {
        return this.inspectorPanel;
    }

    @Override
    final void setUseFilters(boolean useFilters) {
        this.inspectorPanel.setUseFilters(useFilters);
    }

    @Override
    public String getTitleName() {
        EvaluatorItem ei;
        String name;
        Object titleWithExpression = this.title;
        DebuggerDataWindowOptions options = this.getDataPanel(true).getController().getDebuggerWindowOptions();
        if (options != null) {
            titleWithExpression = options.getTitleName();
        }
        titleWithExpression = (name = (ei = this.inspectorPanel.getEvaluatorItem()).getName()) != null ? (String)titleWithExpression + " - " + name : (String)titleWithExpression + " - " + ei.getExpression();
        return titleWithExpression;
    }

    @Override
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.FLOATING;
    }

    public boolean installByDefault() {
        return false;
    }

    @Override
    public void shutDown() {
        super.shutDown();
        this.inspectorPanel.saveExpression((PropertyAccess)Ide.getIdeProperties());
    }

    @Override
    public InspectorController getController() {
        return (InspectorController)this.inspectorPanel.getController();
    }

    void inspectorActiveView(boolean active) {
        if (active) {
            this.getController().setControllerForActions();
        } else {
            this.getController().clearControllerForActions();
        }
    }

    static String getNewInspectorWindowId() {
        return INSPECTOR_WINDOW_ID + countInspectorWindows++;
    }

    private static void useInspectorWindowId(String windowId) {
        if (windowId.startsWith(INSPECTOR_WINDOW_ID)) {
            try {
                String s = windowId.substring(INSPECTOR_WINDOW_ID.length());
                int i = Integer.parseInt(s);
                if (countInspectorWindows < i) {
                    countInspectorWindows = i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static boolean isInspectorWindowId(String windowId) {
        if (windowId.startsWith(INSPECTOR_WINDOW_ID)) {
            int len = INSPECTOR_WINDOW_ID.length();
            String s = windowId.substring(len);
            try {
                int i = Integer.parseInt(s);
                return i < countInspectorWindows;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public int getType() {
        return super.getType() | 1;
    }

    @Override
    public void stateChange(int newState) {
        super.stateChange(newState);
        if (newState == 3) {
            JDebugger.getInstance().removeInspectorWindow(this);
        }
    }

    void removeInspector() {
        this.inspectorPanel.removeInspector();
    }
}

