/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DockingParam;
import oracle.ide.docking.Site;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.ViewId;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.WindowManager;

final class DebugDockableFactory
implements DockableFactory {
    private Set<String> installedDockables = new LinkedHashSet<String>();

    private DebugDockableFactory() {
    }

    public void install() {
        LinkedHashSet<String> previousDockables = new LinkedHashSet<String>(this.installedDockables);
        this.installedDockables.clear();
        JDebugger jdebugger = JDebugger.getInstance();
        if (previousDockables.size() > 0) {
            WindowManager windowManager = jdebugger.getWindowManager();
            windowManager.reinstallWindows(previousDockables);
        } else {
            jdebugger.getBreakpointsWindow(true);
            jdebugger.getSmartWindow(true);
            jdebugger.getLocalsWindow(true);
            jdebugger.getWatchWindow(true);
            jdebugger.getStackWindow(true);
            jdebugger.getThreadsWindow(true);
        }
    }

    public Dockable getDockable(ViewId viewId) {
        String strId = viewId.getId();
        JDebugger jdebugger = JDebugger.getInstance();
        DockableWindow dockable = jdebugger.getOrCreateDebuggerWindow(strId);
        return dockable;
    }

    void installWindow(String windowID, DockableWindow dw, Dockable tabbedWith, int position) {
        if (this.installedDockables.contains(windowID)) {
            return;
        }
        this.installedDockables.add(windowID);
        if (!(dw instanceof DebuggerWindow)) {
            dw.setType(dw.getType() | 0x40);
        }
        switch (position) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                DockStation ds = DockStation.getDockStation();
                DockingParam dockingParam = new DockingParam();
                if (tabbedWith != null) {
                    dockingParam.setPosition(tabbedWith, 4, position);
                } else {
                    dockingParam.setPosition(position);
                }
                ds.dock((Dockable)dw, dockingParam);
                break;
            }
        }
    }

    void floatWindow(String windowID, DockableWindow dw, Rectangle floatingPosition) {
        if (this.installedDockables.contains(dw)) {
            return;
        }
        this.installedDockables.add(windowID);
        DockStation ds = DockStation.getDockStation();
        Point centerOfScreen = DebugDockableFactory.getCenterOfScreen((Dockable)dw);
        if (floatingPosition == null) {
            floatingPosition = new Rectangle(centerOfScreen.x, centerOfScreen.y, 400, 300);
        }
        DockingParam dockingParam = new DockingParam();
        dockingParam.setFloatingPosition(floatingPosition);
        ds.dock((Dockable)dw, dockingParam);
        if (dw.getDefaultVisibility(Layouts.getLayouts().getActive()) != 0) {
            ds.setDockableVisible((Dockable)dw, true);
            ds.activateDockable((Dockable)dw);
        }
    }

    static void updateSiteGeometry(Dockable dockable) {
        JComponent component = dockable.getHostedComponent();
        if (component != null) {
            Dimension d = component.getPreferredSize();
            Site site = dockable.getSite();
            site.geometry.width = d.width;
            site.geometry.height = d.height;
        }
    }

    static Point getCenterOfScreen(Dockable dockable) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension d = toolkit.getScreenSize();
        Point pt = new Point(d.width / 2, d.height / 2);
        Site site = dockable.getSite();
        pt.x -= site.geometry.width / 2;
        pt.y -= site.geometry.height / 2;
        return pt;
    }
}

