/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

final class DataPanelSettingsPanel
implements ActionListener {
    private JCheckBox[] showColumnCheckBoxes;
    private Map<String, boolean[]> showColumnsMap = new HashMap<String, boolean[]>();
    private DataPanelSettings settings;
    private JPanel chooseColumnsPanel;
    private JPanel sortPanel;
    private JPanel showPanel;
    private String currentVM;
    private Map<String, Boolean> sortFieldsByNameMap = new HashMap<String, Boolean>();
    private JCheckBox sortFieldsByNameCheckBox = new JCheckBox();
    private JCheckBox showPackagesCheckBox = new JCheckBox();
    private JCheckBox showStaticFieldsCheckBox = new JCheckBox();
    private JCheckBox showFinalFieldsCheckBox = new JCheckBox();
    private JCheckBox showNullArrayElementsCheckBox = new JCheckBox();
    private JCheckBox showSyntheticFieldsCheckBox = new JCheckBox();
    private JCheckBox showToolbarCheckBox = new JCheckBox();
    private JLabel selectViewLabel;
    private JComboBox selectViewCombo;
    private String windowId;

    public DataPanelSettingsPanel(String windowId) {
        this.windowId = windowId;
        this.showColumnCheckBoxes = new JCheckBox[8];
        for (int i = 0; i < 8; ++i) {
            this.showColumnCheckBoxes[i] = new JCheckBox();
            this.showColumnCheckBoxes[i].addActionListener(this);
        }
        this.showColumnCheckBoxes[0].setSelected(true);
        this.showColumnCheckBoxes[0].setEnabled(false);
        this.sortFieldsByNameCheckBox.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.sortFieldsByNameCheckBox, (String)DbgArb.getString(680));
        ResourceUtils.resButton((AbstractButton)this.showPackagesCheckBox, (String)DbgArb.getString(687));
        ResourceUtils.resButton((AbstractButton)this.showStaticFieldsCheckBox, (String)DbgArb.getString(682));
        ResourceUtils.resButton((AbstractButton)this.showFinalFieldsCheckBox, (String)DbgArb.getString(683));
        ResourceUtils.resButton((AbstractButton)this.showNullArrayElementsCheckBox, (String)DbgArb.getString(684));
        ResourceUtils.resButton((AbstractButton)this.showSyntheticFieldsCheckBox, (String)DbgArb.getString(685));
        ResourceUtils.resButton((AbstractButton)this.showToolbarCheckBox, (String)DbgArb.getString(866));
        this.selectViewCombo = new JComboBox<String>(new String[]{DbgArb.getString(690), DbgArb.getString(691)});
        this.selectViewLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.selectViewLabel, (Component)this.selectViewCombo, (String)DbgArb.getString(689));
        this.chooseColumnsPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        this.sortPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        this.showPanel = new JPanel(new GridLayout(0, 2, 0, 0));
    }

    JPanel makeChooseColumnsPanel(DataPanelSettings settings, String vmName, Insets borderInsets) {
        this.currentVM = vmName;
        this.chooseColumnsPanel.removeAll();
        TitledBorder border = BorderFactory.createTitledBorder(RunMgrArb.getString(91));
        this.chooseColumnsPanel.setBorder(border);
        if (borderInsets != null) {
            Insets temp = border.getBorderInsets(this.chooseColumnsPanel);
            borderInsets.top = temp.top;
            borderInsets.left = temp.left;
            borderInsets.bottom = temp.bottom;
            borderInsets.right = temp.right;
        }
        boolean[] columnsVisible = this.showColumnsMap.get(vmName);
        HashStructure hash = settings.getHash();
        List<String> columnNames = WindowSettingsColumnManager.getColumnNamesInPreferences(hash, vmName);
        for (int i = 0; i < columnNames.size(); ++i) {
            ResourceUtils.resButton((AbstractButton)this.showColumnCheckBoxes[i], (String)columnNames.get(i));
            this.showColumnCheckBoxes[i].setSelected(columnsVisible[i]);
            if (i == columnNames.size() - 1 && this.windowId == "Debugger.MonitorsWindow") continue;
            this.chooseColumnsPanel.add(this.showColumnCheckBoxes[i]);
        }
        return this.chooseColumnsPanel;
    }

    JPanel makeSortPanel(String vmName, JCheckBox otherCheckBox) {
        JPanel panel = new JPanel(new GridLayout(0, 2, 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(DbgArb.getString(677)));
        panel.add(this.sortFieldsByNameCheckBox);
        if (this.sortFieldsByNameMap.get(vmName) != null) {
            this.sortFieldsByNameCheckBox.setSelected(this.sortFieldsByNameMap.get(vmName));
        }
        if (otherCheckBox != null) {
            panel.add(otherCheckBox);
        }
        return panel;
    }

    JPanel makeShowPanel(List<JCheckBox> otherCheckBoxes) {
        JPanel panel = new JPanel(new GridLayout(0, 2, 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(DbgArb.getString(678)));
        panel.add(this.showPackagesCheckBox);
        panel.add(this.showToolbarCheckBox);
        panel.add(this.showStaticFieldsCheckBox);
        panel.add(this.showFinalFieldsCheckBox);
        panel.add(this.showNullArrayElementsCheckBox);
        panel.add(this.showSyntheticFieldsCheckBox);
        if (otherCheckBoxes != null) {
            for (JCheckBox b : otherCheckBoxes) {
                panel.add(b);
            }
        }
        return panel;
    }

    JPanel makeViewSelectPanel() {
        JPanel panel = new JPanel(new BorderLayout(10, 2));
        panel.add((Component)this.selectViewLabel, "West");
        panel.add((Component)this.selectViewCombo, "Center");
        return panel;
    }

    void onEntry(DataPanelSettings dataPanelSettings) {
        this.settings = dataPanelSettings;
        HashStructure hash = this.settings.getHash();
        this.showColumnsMap.clear();
        boolean y = true;
        List<String> vmNames = WindowSettingsColumnManager.getVMNames(hash);
        if (vmNames.size() > 0) {
            for (String vmName : vmNames) {
                boolean[] visibilities = new boolean[8];
                for (int j = 0; j < 8; ++j) {
                    visibilities[j] = WindowSettingsColumnManager.getActiveDataView(hash, vmName, this.windowId) == "TREE_TABLE" ? WindowSettingsColumnManager.getColumnVisible(hash, vmName, j) : WindowSettingsColumnManager.getColumnBreadcrumbVisible(hash, vmName, j);
                }
                this.showColumnsMap.put(vmName, visibilities);
                this.sortFieldsByNameMap.put(vmName, dataPanelSettings.isSortFieldsByName(vmName));
                if (WindowSettingsColumnManager.getActiveDataView(dataPanelSettings.getHash(), vmName, this.windowId).equals("TABLE_TABLE")) {
                    this.selectViewCombo.setSelectedItem(DbgArb.getString(691));
                    continue;
                }
                this.selectViewCombo.setSelectedItem(DbgArb.getString(690));
            }
        }
        this.showPackagesCheckBox.setSelected(dataPanelSettings.isShowPackages());
        this.showToolbarCheckBox.setSelected(dataPanelSettings.isShowingToolbar());
        this.showStaticFieldsCheckBox.setSelected(!dataPanelSettings.isHideStaticFields());
        this.showFinalFieldsCheckBox.setSelected(!dataPanelSettings.isHideFinalFields());
        this.showNullArrayElementsCheckBox.setSelected(!dataPanelSettings.isHideNullArrayElements());
        this.showSyntheticFieldsCheckBox.setSelected(!dataPanelSettings.isHideSyntheticFields());
    }

    void onExit(DataPanelSettings dataPanelSettings) throws TraversalException {
        HashStructure hash = dataPanelSettings.getHash();
        for (String vmName : this.showColumnsMap.keySet()) {
            if (this.selectViewCombo.getSelectedItem().equals(DbgArb.getString(691))) {
                WindowSettingsColumnManager.setActiveDataView(hash, vmName, this.windowId, "TABLE_TABLE");
            } else {
                WindowSettingsColumnManager.setActiveDataView(hash, vmName, this.windowId, "TREE_TABLE");
            }
            boolean[] columnVisibilities = this.showColumnsMap.get(vmName);
            for (int i = 0; i < columnVisibilities.length; ++i) {
                if (WindowSettingsColumnManager.getActiveDataView(hash, vmName, this.windowId) == "TREE_TABLE") {
                    WindowSettingsColumnManager.setColumnVisible(hash, vmName, i, columnVisibilities[i]);
                    continue;
                }
                WindowSettingsColumnManager.setColumnBreadcrumbVisible(hash, vmName, i, columnVisibilities[i]);
            }
            if (this.sortFieldsByNameMap.get(vmName) == null) continue;
            dataPanelSettings.setSortFieldsByName(vmName, this.sortFieldsByNameMap.get(vmName));
        }
        for (int i = 0; i < 8; ++i) {
            this.showColumnCheckBoxes[i].removeActionListener(this);
        }
        dataPanelSettings.setShowPackages(this.showPackagesCheckBox.isSelected());
        dataPanelSettings.setShowingToolbar(this.showToolbarCheckBox.isSelected());
        dataPanelSettings.setHideStaticFields(!this.showStaticFieldsCheckBox.isSelected());
        dataPanelSettings.setHideFinalFields(!this.showFinalFieldsCheckBox.isSelected());
        dataPanelSettings.setHideNullArrayElements(!this.showNullArrayElementsCheckBox.isSelected());
        dataPanelSettings.setHideSyntheticFields(!this.showSyntheticFieldsCheckBox.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.sortFieldsByNameCheckBox) {
            this.sortFieldsByNameMap.put(this.currentVM, this.sortFieldsByNameCheckBox.isSelected());
            return;
        }
        for (int i = 0; i < this.showColumnCheckBoxes.length; ++i) {
            if (e.getSource() != this.showColumnCheckBoxes[i]) continue;
            boolean[] visibilities = this.showColumnsMap.get(this.currentVM);
            visibilities[i] = this.showColumnCheckBoxes[i].isSelected();
            break;
        }
    }
}

