/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.Ide;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

final class DataArrayRange {
    private static int defaultArrayRangeMax = 0;
    private DebuggingProcess debuggingProcess;
    private DebugDataArrayInfo array;
    private int start;
    private int count;
    private int end;
    private int length;
    private Direction direction = Direction.FORWARD;
    private String key;
    private ScanStatus scanStatusBelowRange = ScanStatus.NOT_SCANNED;
    private ScanStatus scanStatusAboveRange = ScanStatus.NOT_SCANNED;

    DataArrayRange(DebuggingProcess debuggingProcess, DebugDataArrayInfo array) {
        this.debuggingProcess = debuggingProcess;
        this.array = array;
        this.start = array.getArrayStart();
        this.length = array.getArrayCount();
        this.count = array.getArrayCount();
        int max = DataArrayRange.getDefaultArrayRangeMax();
        if (this.count == -1 || this.count > max) {
            this.count = max;
        }
    }

    DebuggingProcess getDebuggingProcess() {
        return this.debuggingProcess;
    }

    int getStart() {
        return this.start;
    }

    void setStart(int start) {
        this.start = start;
    }

    ScanStatus getScanStatusBelowRange() {
        return this.scanStatusBelowRange;
    }

    void setScanStatusBelowRange(ScanStatus below) {
        this.scanStatusBelowRange = below;
    }

    ScanStatus getScanStatusAboveRange() {
        return this.scanStatusAboveRange;
    }

    void setScanStatusAboveRange(ScanStatus above) {
        this.scanStatusAboveRange = above;
    }

    int getEnd() {
        return this.end;
    }

    void setEnd(int end) {
        this.end = end;
    }

    Direction getDirection() {
        return this.direction;
    }

    void setDirection(Direction direction) {
        this.direction = direction;
    }

    int getCount() {
        return this.count;
    }

    void setCount(int count) {
        this.count = count;
    }

    int getLength() {
        return this.length;
    }

    DebugDataArrayInfo getArray() {
        return this.array;
    }

    void setArray(DebugDataArrayInfo array) {
        this.array = array;
    }

    String getKey() {
        return this.key;
    }

    void setKey(String key) {
        this.key = key;
    }

    private static synchronized int getDefaultArrayRangeMax() {
        if (defaultArrayRangeMax == 0) {
            defaultArrayRangeMax = 20;
            String max = Ide.getProperty((String)"DebuggerDefaultArrayRangeMax");
            if (max != null) {
                try {
                    defaultArrayRangeMax = Integer.parseInt(max);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return defaultArrayRangeMax;
    }

    static enum Direction {
        FORWARD,
        BACKWARD;

    }

    static enum ScanStatus {
        HAS_MORE,
        AT_END,
        NOT_SCANNED;

    }
}

