/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.shared;

class DebugSharedConstantPool {
    private int constantPoolCnt;
    private ConstantPoolEntry[] constantPoolVector;
    private int offset;
    private byte[] classFileData;
    private boolean parseSucceeded;
    private StringBuilder decodeBuf;

    DebugSharedConstantPool(int count, byte[] bytes) {
        this.constantPoolCnt = count;
        if (count > 0 && bytes != null) {
            this.parseSucceeded = this.parseConstantPool(bytes);
        }
        this.decodeBuf = new StringBuilder();
    }

    private boolean parseConstantPool(byte[] bytes) {
        try {
            this.offset = 0;
            this.classFileData = bytes;
            this.constantPoolVector = new ConstantPoolEntry[this.constantPoolCnt + 1];
            block15: for (int i = 1; i < this.constantPoolCnt; ++i) {
                byte cpIdx = this.getByte();
                switch (cpIdx) {
                    default: {
                        return false;
                    }
                    case 7: {
                        this.constantPoolVector[i] = new ConstantPoolClass(i, this.getUnsignedShort());
                        continue block15;
                    }
                    case 8: {
                        this.constantPoolVector[i] = new ConstantPoolString(i, this.getUnsignedShort());
                        continue block15;
                    }
                    case 3: {
                        this.constantPoolVector[i] = new ConstantPoolInteger(i, this.getInt());
                        continue block15;
                    }
                    case 4: {
                        this.constantPoolVector[i] = new ConstantPoolFloat(i, this.getFloat());
                        continue block15;
                    }
                    case 9: {
                        this.constantPoolVector[i] = new ConstantPoolFieldRef(i, this.getUnsignedShort(), this.getUnsignedShort());
                        continue block15;
                    }
                    case 10: {
                        this.constantPoolVector[i] = new ConstantPoolMethodRef(i, this.getUnsignedShort(), this.getUnsignedShort());
                        continue block15;
                    }
                    case 11: {
                        this.constantPoolVector[i] = new ConstantPoolInterfaceMethodRef(i, this.getUnsignedShort(), this.getUnsignedShort());
                        continue block15;
                    }
                    case 12: {
                        this.constantPoolVector[i] = new ConstantPoolNameAndType(i, this.getUnsignedShort(), this.getUnsignedShort());
                        continue block15;
                    }
                    case 5: {
                        this.constantPoolVector[i++] = new ConstantPoolLong(i, this.getLong());
                        continue block15;
                    }
                    case 6: {
                        this.constantPoolVector[i++] = new ConstantPoolDouble(i, this.getDouble());
                        continue block15;
                    }
                    case 1: {
                        int len = this.getShort();
                        char[] cbuf = new char[len];
                        int idx = 0;
                        int j = 0;
                        while (j < len) {
                            ++j;
                            byte b = this.getByte();
                            if ((b & 0x80) != 0) {
                                ++j;
                                byte b1 = this.getByte();
                                if ((b & 0xE0) == 192) {
                                    cbuf[idx++] = (char)((b & 0x1F) << 6 | b1 & 0x3F);
                                    continue;
                                }
                                ++j;
                                byte b2 = this.getByte();
                                cbuf[idx++] = (char)((b & 0xF) << 12 | (b1 & 0x3F) << 6 | b2 & 0x3F);
                                continue;
                            }
                            cbuf[idx++] = (char)(b & 0xFF);
                        }
                        this.constantPoolVector[i] = new ConstantPoolUtf8(i, cbuf);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    private long getLong() {
        return ((long)this.classFileData[this.offset++] & 0xFFL) << 56 | ((long)this.classFileData[this.offset++] & 0xFFL) << 48 | ((long)this.classFileData[this.offset++] & 0xFFL) << 40 | ((long)this.classFileData[this.offset++] & 0xFFL) << 32 | ((long)this.classFileData[this.offset++] & 0xFFL) << 24 | ((long)this.classFileData[this.offset++] & 0xFFL) << 16 | ((long)this.classFileData[this.offset++] & 0xFFL) << 8 | (long)this.classFileData[this.offset++] & 0xFFL;
    }

    private float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    private int getInt() {
        return (this.classFileData[this.offset++] & 0xFF) << 24 | (this.classFileData[this.offset++] & 0xFF) << 16 | (this.classFileData[this.offset++] & 0xFF) << 8 | this.classFileData[this.offset++] & 0xFF;
    }

    private int getShort() {
        return (this.classFileData[this.offset++] & 0xFF) << 8 | this.classFileData[this.offset++] & 0xFF;
    }

    private int getUnsignedShort() {
        return ((this.classFileData[this.offset++] & 0xFF) << 8 | this.classFileData[this.offset++] & 0xFF) & 0xFFFF;
    }

    private byte getByte() {
        return this.classFileData[this.offset++];
    }

    String decodeConstantPoolReference(int idx) {
        this.decodeBuf.setLength(0);
        this.decodeBuf.append("   # ");
        this.decodeBuf.append(idx);
        if (!this.parseSucceeded) {
            return this.decodeBuf.toString();
        }
        this.decodeBuf.append(": ");
        ConstantPoolEntry cpe = this.constantPoolVector[idx];
        if (cpe instanceof ConstantPoolInteger) {
            this.decodeBuf.append(((ConstantPoolInteger)cpe).ival);
        } else if (cpe instanceof ConstantPoolLong) {
            this.decodeBuf.append(((ConstantPoolLong)cpe).lval);
        } else if (cpe instanceof ConstantPoolFloat) {
            this.decodeBuf.append(((ConstantPoolFloat)cpe).fval);
        } else if (cpe instanceof ConstantPoolDouble) {
            this.decodeBuf.append(((ConstantPoolDouble)cpe).dval);
        } else if (cpe instanceof ConstantPoolString) {
            ConstantPoolString stringCpe = (ConstantPoolString)cpe;
            ConstantPoolUtf8 utf8Cpe = (ConstantPoolUtf8)this.constantPoolVector[stringCpe.strIndex];
            this.decodeBuf.append('\"');
            this.decodeBuf.append(utf8Cpe.valueString());
            this.decodeBuf.append('\"');
        } else if (cpe instanceof ConstantPoolClass) {
            ConstantPoolClass classCpe = (ConstantPoolClass)cpe;
            ConstantPoolUtf8 utf8Cpe = (ConstantPoolUtf8)this.constantPoolVector[classCpe.nameIndex];
            String str = utf8Cpe.valueString();
            if (str.charAt(0) == '[') {
                this.decodeTypeName(this.decodeBuf, str);
            } else {
                str = str.replace('/', '.');
                this.decodeBuf.append(str);
            }
        } else if (cpe instanceof ConstantPoolUtf8) {
            ConstantPoolUtf8 utf8Cpe = (ConstantPoolUtf8)cpe;
            this.decodeBuf.append(utf8Cpe.valueString());
        } else if (cpe instanceof ConstantPoolNameAndType) {
            ConstantPoolNameAndType nameAndTypeCpe = (ConstantPoolNameAndType)cpe;
            ConstantPoolUtf8 utf8Cpe = (ConstantPoolUtf8)this.constantPoolVector[nameAndTypeCpe.nameIndex];
            String nameStr = utf8Cpe.valueString();
            utf8Cpe = (ConstantPoolUtf8)this.constantPoolVector[nameAndTypeCpe.typeIndex];
            String typeStr = utf8Cpe.valueString();
            this.decodeBuf.append(DebugSharedConstantPool.signatureToString(typeStr.toCharArray(), nameStr.toCharArray(), false));
        } else if (cpe instanceof ConstantPoolRef) {
            StringBuilder sbName = new StringBuilder();
            ConstantPoolRef refCpe = (ConstantPoolRef)cpe;
            ConstantPoolClass classCpe = (ConstantPoolClass)this.constantPoolVector[refCpe.classIndex];
            ConstantPoolUtf8 utf8Cpe = (ConstantPoolUtf8)this.constantPoolVector[classCpe.nameIndex];
            String str = utf8Cpe.valueString();
            if (str.charAt(0) == '[') {
                this.decodeTypeName(sbName, str);
            } else {
                str = str.replace('/', '.');
                sbName.append(str);
            }
            sbName.append('.');
            ConstantPoolNameAndType nameAndTypeCpe = (ConstantPoolNameAndType)this.constantPoolVector[refCpe.nameAndTypeIndex];
            utf8Cpe = (ConstantPoolUtf8)this.constantPoolVector[nameAndTypeCpe.nameIndex];
            sbName.append(utf8Cpe.valueString());
            utf8Cpe = (ConstantPoolUtf8)this.constantPoolVector[nameAndTypeCpe.typeIndex];
            str = utf8Cpe.valueString();
            this.decodeBuf.append(DebugSharedConstantPool.signatureToString(str.toCharArray(), sbName.toString().toCharArray(), false));
        } else {
            this.decodeBuf.append("<unknown>");
        }
        return this.decodeBuf.toString();
    }

    private void decodeTypeName(StringBuilder sb, String str) {
        int dimension = (str = str.replace('/', '.')).lastIndexOf(91) + 1;
        if (dimension > 0) {
            str = str.substring(dimension);
        }
        if (str.length() == 1) {
            switch (str.charAt(0)) {
                default: {
                    sb.append("<unknown>");
                    break;
                }
                case 'Z': {
                    sb.append("boolean");
                    break;
                }
                case 'B': {
                    sb.append("byte");
                    break;
                }
                case 'S': {
                    sb.append("short");
                    break;
                }
                case 'C': {
                    sb.append("char");
                    break;
                }
                case 'I': {
                    sb.append("int");
                    break;
                }
                case 'J': {
                    sb.append("long");
                    break;
                }
                case 'F': {
                    sb.append("float");
                    break;
                }
                case 'D': {
                    sb.append("double");
                    break;
                }
            }
        } else {
            str = str.replace('/', '.');
            str = str.substring(1, str.length() - 1);
            sb.append(str);
        }
        while (--dimension >= 0) {
            sb.append("[]");
        }
    }

    static String signatureToString(char[] signature, char[] name, boolean suppressReturnType) {
        boolean isMethod;
        int dim;
        StringBuffer mtype;
        StringBuffer type;
        block27: {
            type = new StringBuffer();
            mtype = null;
            dim = 0;
            int i = 0;
            isMethod = false;
            block19: while (true) {
                switch (signature[i]) {
                    default: {
                        return "<unknown>";
                    }
                    case 'Z': {
                        type.append("boolean");
                        ++i;
                        break;
                    }
                    case 'B': {
                        type.append("byte");
                        ++i;
                        break;
                    }
                    case 'S': {
                        type.append("short");
                        ++i;
                        break;
                    }
                    case 'C': {
                        type.append("char");
                        ++i;
                        break;
                    }
                    case 'I': {
                        type.append("int");
                        ++i;
                        break;
                    }
                    case 'J': {
                        type.append("long");
                        ++i;
                        break;
                    }
                    case 'F': {
                        type.append("float");
                        ++i;
                        break;
                    }
                    case 'D': {
                        type.append("double");
                        ++i;
                        break;
                    }
                    case 'V': {
                        type.append("void");
                        ++i;
                        break;
                    }
                    case '(': {
                        isMethod = true;
                        type.append(' ');
                        type.append(name);
                        type.append('(');
                        ++i;
                        continue block19;
                    }
                    case ')': {
                        type.append(')');
                        mtype = type;
                        type = new StringBuffer();
                        ++i;
                        continue block19;
                    }
                    case '[': {
                        ++dim;
                        ++i;
                        continue block19;
                    }
                    case 'L': {
                        StringBuffer sb = new StringBuffer();
                        block20: while (true) {
                            char c = signature[++i];
                            switch (c) {
                                default: {
                                    sb.append(c);
                                    continue block20;
                                }
                                case '/': {
                                    sb.append('.');
                                    continue block20;
                                }
                                case ';': 
                            }
                            break;
                        }
                        ++i;
                        type.append(sb);
                        break;
                    }
                }
                if (i == signature.length) break block27;
                if (!isMethod) break;
                while (dim > 0) {
                    type.append("[]");
                    --dim;
                }
                if (signature[i] == ')') continue;
                type.append(", ");
            }
            return "<unknown>";
        }
        while (--dim >= 0) {
            type.append("[]");
        }
        if (!isMethod) {
            type.append(' ');
            type.append(name);
        } else if (suppressReturnType) {
            type = mtype;
        } else {
            type.append(mtype);
        }
        return type.toString();
    }

    abstract class ConstantPoolEntry {
        static final byte CONSTANT_Utf8 = 1;
        static final byte CONSTANT_Integer = 3;
        static final byte CONSTANT_Float = 4;
        static final byte CONSTANT_Long = 5;
        static final byte CONSTANT_Double = 6;
        static final byte CONSTANT_Class = 7;
        static final byte CONSTANT_String = 8;
        static final byte CONSTANT_Fieldref = 9;
        static final byte CONSTANT_Methodref = 10;
        static final byte CONSTANT_InterfaceMethodref = 11;
        static final byte CONSTANT_NameAndType = 12;
        short index;

        ConstantPoolEntry(int index) {
            this.index = (short)index;
        }
    }

    final class ConstantPoolClass
    extends ConstantPoolEntry {
        int nameIndex;

        ConstantPoolClass(int index, int nameIndex) {
            super(index);
            this.nameIndex = nameIndex;
        }

        public String toString() {
            return this.index + "  Class    " + this.nameIndex;
        }
    }

    final class ConstantPoolString
    extends ConstantPoolEntry {
        int strIndex;

        ConstantPoolString(int index, int strIndex) {
            super(index);
            this.strIndex = strIndex;
        }

        public String toString() {
            return this.index + "  String    " + this.strIndex;
        }
    }

    final class ConstantPoolInteger
    extends ConstantPoolEntry {
        int ival;

        ConstantPoolInteger(int index, int ival) {
            super(index);
            this.ival = ival;
        }

        public String toString() {
            return this.index + "  Integer    " + this.ival;
        }
    }

    final class ConstantPoolFloat
    extends ConstantPoolEntry {
        float fval;

        ConstantPoolFloat(int index, float fval) {
            super(index);
            this.fval = fval;
        }

        public String toString() {
            return this.index + "  Float    " + this.fval;
        }
    }

    final class ConstantPoolFieldRef
    extends ConstantPoolRef {
        ConstantPoolFieldRef(int index, int classIndex, int nameAndTypeIndex) {
            super(index, classIndex, nameAndTypeIndex);
        }

        public String toString() {
            return this.index + "  FieldRef    " + this.classIndex + ", " + this.nameAndTypeIndex;
        }
    }

    final class ConstantPoolMethodRef
    extends ConstantPoolRef {
        ConstantPoolMethodRef(int index, int classIndex, int nameAndTypeIndex) {
            super(index, classIndex, nameAndTypeIndex);
        }

        public String toString() {
            return this.index + "  MethodRef    " + this.classIndex + ", " + this.nameAndTypeIndex;
        }
    }

    final class ConstantPoolInterfaceMethodRef
    extends ConstantPoolRef {
        ConstantPoolInterfaceMethodRef(int index, int classIndex, int nameAndTypeIndex) {
            super(index, classIndex, nameAndTypeIndex);
        }

        public String toString() {
            return this.index + "  InterfaceMethodRef    " + this.classIndex + ", " + this.nameAndTypeIndex;
        }
    }

    final class ConstantPoolNameAndType
    extends ConstantPoolEntry {
        int nameIndex;
        int typeIndex;

        ConstantPoolNameAndType(int index, int nameIndex, int typeIndex) {
            super(index);
            this.nameIndex = nameIndex;
            this.typeIndex = typeIndex;
        }

        public String toString() {
            return this.index + "  NameAndType    " + this.nameIndex + ", " + this.typeIndex;
        }
    }

    final class ConstantPoolLong
    extends ConstantPoolEntry {
        long lval;

        ConstantPoolLong(int index, long lval) {
            super(index);
            this.lval = lval;
        }

        public String toString() {
            return this.index + "  Long    " + this.lval;
        }
    }

    final class ConstantPoolDouble
    extends ConstantPoolEntry {
        double dval;

        ConstantPoolDouble(int index, double dval) {
            super(index);
            this.dval = dval;
        }

        public String toString() {
            return this.index + "  Double    " + this.dval;
        }
    }

    final class ConstantPoolUtf8
    extends ConstantPoolEntry {
        char[] string;

        ConstantPoolUtf8(int index, char[] string) {
            super(index);
            this.string = string;
        }

        String valueString() {
            return new String(this.string);
        }

        String valueContent() {
            StringBuffer sb = new StringBuffer(this.string.length);
            sb.append(this.string);
            return this.makeHTMLsafe(sb.toString());
        }

        String makeHTMLsafe(String str) {
            return str.replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("\n", "<br>");
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.string.length + 20);
            sb.append(this.index);
            sb.append("  Utf8    \"");
            sb.append(this.string);
            sb.append('\"');
            return sb.toString();
        }
    }

    abstract class ConstantPoolRef
    extends ConstantPoolEntry {
        int classIndex;
        int nameAndTypeIndex;

        ConstantPoolRef(int index, int classIndex, int nameAndTypeIndex) {
            super(index);
            this.classIndex = classIndex;
            this.nameAndTypeIndex = nameAndTypeIndex;
        }
    }
}

