/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.SharedPropertiesAdapter;
import oracle.ide.model.SharedPropertiesManager;
import oracle.ide.model.Workspace;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunMgrArb;

public class RunConfigurations
extends SharedPropertiesAdapter {
    public static final String DATA_KEY = "oracle.jdeveloper.runner.RunConfigurations";
    public static final String RUN_CONFIGURATION_LIST = "runConfigurationList";
    public static final String RUN_CONFIGURATION_DEFINITIONS = "runConfigurationDefinitions";
    public static final String RUN_CONFIGURATION_NAME = "name";
    public static final String RUN_CONFIGURATION_ACTIVE_NAME = "activeName";
    private static final Logger LOG = Logger.getLogger(RunConfigurations.class.getName());
    private static final SharedPropertiesManager sharedPropertiesManager = SharedPropertiesManager.get();

    public RunConfigurations(HashStructure hash) {
        super(hash);
    }

    public static RunConfigurations getInstance(Project project, Workspace workspace) {
        project = RunConfigurations.checkProject(project);
        workspace = RunConfigurations.checkWorkspace(project, workspace);
        PropertyStorage ps = RunConfigurations.getActivePropertyStorage((Project)project, (Workspace)workspace, (String)DATA_KEY);
        boolean useWorkspaceSharedProperties = sharedPropertiesManager.isUsingSharedProperties(project, DATA_KEY);
        return RunConfigurations.getInstance(ps, useWorkspaceSharedProperties);
    }

    @Deprecated
    public static RunConfigurations getInstance(Project project, boolean useWorkspacePropertyStorage) {
        project = RunConfigurations.checkProject(project);
        if (useWorkspacePropertyStorage) {
            Workspace workspace = RunConfigurations.checkWorkspace(project, null);
            return RunConfigurations.getInstance((PropertyStorage)workspace, useWorkspacePropertyStorage);
        }
        return RunConfigurations.getInstance(project, useWorkspacePropertyStorage);
    }

    @Deprecated
    public static RunConfigurations getInstance(PropertyStorage ps) {
        if (ps instanceof Project) {
            return RunConfigurations.getInstance(ps, false);
        }
        if (ps instanceof Workspace) {
            return RunConfigurations.getInstance(ps, true);
        }
        return RunConfigurations.getInstance(ps, false);
    }

    public static RunConfigurations getInstance(PropertyStorage ps, boolean useWorkspacePropertyStorage) {
        HashStructure properties = ps.getProperties();
        HashStructure hash = properties.getOrCreateHashStructure(DATA_KEY);
        RunConfigurations instance = new RunConfigurations(hash);
        HashStructure defs = instance.getRunConfigurationDefinitions();
        ListStructure names = instance.getRunConfigurationList();
        if (defs.keySet().isEmpty()) {
            RunConfiguration runConfig = RunConfiguration.createNewInstance(null, null, false, useWorkspacePropertyStorage);
            defs.putPlaceholderHashStructure(runConfig.getName(), runConfig.getProperties());
            names.addPlaceholder((Object)runConfig.getName());
        } else if (names.isEmpty()) {
            for (String key : defs.keySet()) {
                names.addPlaceholder((Object)key);
            }
        }
        return instance;
    }

    @Deprecated
    public static void addRunConfiguration(Project project, RunConfiguration runConfiguration) {
        RunConfigurations.addRunConfiguration(project, null, runConfiguration);
    }

    public static void addRunConfiguration(Project project, Workspace workspace, RunConfiguration runConfiguration) {
        project = RunConfigurations.checkProject(project);
        workspace = RunConfigurations.checkWorkspace(project, workspace);
        String name = runConfiguration.getName();
        HashStructure runConfigurationHashStructure = runConfiguration.getProperties();
        PropertyStorage ps = RunConfigurations.getActivePropertyStorage((Project)project, (Workspace)workspace, (String)DATA_KEY);
        HashStructure activeProperties = ps.getProperties();
        HashStructure runConfigurationsProperties = activeProperties.getOrCreateHashStructure(DATA_KEY);
        HashStructure runConfigurationDefinitions = runConfigurationsProperties.getOrCreateHashStructure(RUN_CONFIGURATION_DEFINITIONS);
        runConfigurationDefinitions.putHashStructure(name, runConfigurationHashStructure);
        ListStructure runConfigurationList = runConfigurationsProperties.getOrCreateListStructure(RUN_CONFIGURATION_LIST);
        runConfigurationList.add((Object)name);
    }

    private HashStructure getRunConfigurationDefinitions() {
        return this.getHashStructure().getOrCreateHashStructure(RUN_CONFIGURATION_DEFINITIONS);
    }

    private ListStructure getRunConfigurationList() {
        return this.getHashStructure().getOrCreateListStructure(RUN_CONFIGURATION_LIST);
    }

    public static String getActiveName(Project project, Workspace workspace) {
        if (sharedPropertiesManager.isUsingSharedProperties(project, DATA_KEY)) {
            return RunConfigurations.getActiveName(project, workspace, true);
        }
        return RunConfigurations.getActiveName(project, workspace, false);
    }

    public static String getActiveName(Project project, Workspace workspace, boolean useWorkspacePropertyStorage) {
        project = RunConfigurations.checkProject(project);
        workspace = RunConfigurations.checkWorkspace(project, workspace);
        boolean isUsingSharedProperties = sharedPropertiesManager.isUsingSharedProperties(project, DATA_KEY);
        HashStructure userProperties = isUsingSharedProperties ? workspace.getUserPropertiesOnly() : project.getUserPropertiesOnly();
        String activeName = userProperties != null ? userProperties.getString(RUN_CONFIGURATION_ACTIVE_NAME) : null;
        PropertyStorage ps = RunConfigurations.getActivePropertyStorage((Project)project, (Workspace)workspace, (String)DATA_KEY);
        HashStructure properties = ps.getProperties();
        HashStructure activeProperties = properties.getOrCreateHashStructure(DATA_KEY);
        RunConfigurations runConfigurations = RunConfigurations.getInstance(project, workspace);
        ListStructure runConfigurationList = runConfigurations.getRunConfigurationList();
        HashStructure runConfigurationDefinitions = runConfigurations.getRunConfigurationDefinitions();
        if (activeName == null || !runConfigurationList.contains((Object)activeName) || !runConfigurationDefinitions.containsKey(activeName)) {
            String string = activeName = useWorkspacePropertyStorage ? RunMgrArb.getString(2) : RunMgrArb.getString(1);
        }
        if (activeName == null || !runConfigurationList.contains((Object)activeName) || !runConfigurationDefinitions.containsKey(activeName)) {
            activeName = RunMgrArb.getString(0);
        }
        if (activeName == null || !runConfigurationList.contains((Object)activeName) || !runConfigurationDefinitions.containsKey(activeName)) {
            int size = runConfigurationList.size();
            for (int i = 0; i < size; ++i) {
                String name = (String)runConfigurationList.get(i);
                if (!runConfigurationDefinitions.containsKey(name)) continue;
                activeName = name;
                activeProperties.putString(RUN_CONFIGURATION_ACTIVE_NAME, activeName);
                break;
            }
        }
        return activeName;
    }

    private static void setActiveName(Project project, Workspace workspace, String activeName) {
        HashStructure userProperties;
        boolean isUsingSharedProperties = sharedPropertiesManager.isUsingSharedProperties(project = RunConfigurations.checkProject(project), DATA_KEY);
        if (isUsingSharedProperties) {
            workspace = RunConfigurations.checkWorkspace(project, workspace);
        }
        HashStructure hashStructure = userProperties = isUsingSharedProperties ? workspace.getUserPropertiesOnly() : project.getUserPropertiesOnly();
        if (userProperties != null) {
            userProperties.putString(RUN_CONFIGURATION_ACTIVE_NAME, activeName);
        }
    }

    public Map<String, RunConfiguration> getDefinedRunConfigurations() {
        HashMap<String, RunConfiguration> map = new HashMap<String, RunConfiguration>();
        HashStructure runConfigurationDefinitions = this.getRunConfigurationDefinitions();
        for (String name : runConfigurationDefinitions.keySet()) {
            try {
                HashStructure runConfigurationHashStructure = runConfigurationDefinitions.getHashStructure(name);
                RunConfiguration runConfiguration = new RunConfiguration(runConfigurationHashStructure);
                map.put(name, runConfiguration);
            }
            catch (ClassCastException cce) {
                LOG.warning("Unable to load RunConfiguration " + name + " because " + cce.getMessage());
            }
        }
        return map;
    }

    public RunConfiguration[] getVisibleRunConfigurations() {
        ArrayList<RunConfiguration> list = new ArrayList<RunConfiguration>();
        ListStructure runConfigurationList = this.getRunConfigurationList();
        HashStructure runConfigurationDefinitions = this.getRunConfigurationDefinitions();
        for (int i = runConfigurationList.size() - 1; i >= 0; --i) {
            String name = (String)runConfigurationList.get(i);
            HashStructure runConfigurationHashStructure = runConfigurationDefinitions.getHashStructure(name);
            if (runConfigurationHashStructure != null) {
                RunConfiguration runConfiguration = new RunConfiguration(runConfigurationHashStructure);
                list.add(0, runConfiguration);
                continue;
            }
            runConfigurationList.remove(i);
        }
        return list.toArray(new RunConfiguration[list.size()]);
    }

    public void setRunConfigurations(RunConfiguration[] runConfigs, boolean editingCustomProperties) {
        HashStructure runConfigurationDefinitions = this.getRunConfigurationDefinitions();
        ArrayList<String> tempList = new ArrayList<String>();
        int size = runConfigs.length;
        for (int i = 0; i < size; ++i) {
            String[] names;
            String name = runConfigs[i].getName();
            tempList.add(name);
            if (runConfigurationDefinitions.containsKey(name)) continue;
            HashStructure h = runConfigs[i].getProperties();
            if (h.isAnyValueOverridden(names = new String[]{"custom"})) {
                h = HashStructure.newInstance();
                runConfigs[i].getProperties().copyTo(h);
            }
            runConfigurationDefinitions.putHashStructure(name, h);
        }
        Collections.sort(tempList);
        ListStructure runConfigurationList = this.getRunConfigurationList();
        runConfigurationList.mirror(tempList);
        String[] names = runConfigurationDefinitions.keySet().toArray(new String[runConfigurationDefinitions.size()]);
        for (int i = names.length - 1; i >= 0; --i) {
            String name = names[i];
            HashStructure runConfigurationHashStructure = null;
            try {
                runConfigurationHashStructure = runConfigurationDefinitions.getHashStructure(name);
            }
            catch (ClassCastException cce) {
                continue;
            }
            RunConfiguration runConfiguration = new RunConfiguration(runConfigurationHashStructure);
            if (runConfiguration.isCustom() != editingCustomProperties || tempList.contains(name)) continue;
            runConfigurationDefinitions.remove(name);
        }
    }

    public static boolean isActiveRunConfiguration(Project project, Workspace workspace, RunConfiguration runConfiguration, boolean useWorkspacePropertyStorage) {
        return RunConfigurations.getActiveName(project, workspace, useWorkspacePropertyStorage).equals(runConfiguration.getName());
    }

    public static void setActiveRunConfiguration(Project project, RunConfiguration runConfiguration) {
        RunConfigurations.setActiveName(project, null, runConfiguration.getName());
    }

    public static void setActiveRunConfiguration(Project project, Workspace workspace, RunConfiguration runConfiguration) {
        RunConfigurations.setActiveName(project, workspace, runConfiguration.getName());
    }

    private static RunConfiguration getRunConfigurationByName(Project project, String name, boolean createTemp) {
        RunConfigurations runConfigurations = RunConfigurations.getInstance(project, null);
        HashStructure runConfigurationDefinitions = runConfigurations.getRunConfigurationDefinitions();
        HashStructure runConfigurationHashStructure = runConfigurationDefinitions.getHashStructure(name);
        if (runConfigurationHashStructure == null) {
            if (createTemp) {
                runConfigurationHashStructure = HashStructure.newInstance();
            } else {
                return null;
            }
        }
        RunConfiguration runConfiguration = new RunConfiguration(runConfigurationHashStructure);
        return runConfiguration;
    }

    public static RunConfiguration getRunConfigurationByName(Project project, String name) {
        boolean createTemp = false;
        return RunConfigurations.getRunConfigurationByName(project, name, createTemp);
    }

    @Deprecated
    public static RunConfiguration getActiveRunConfiguration(Project project) {
        return RunConfigurations.getActiveRunConfiguration(project, null);
    }

    public static RunConfiguration getActiveRunConfiguration(Project project, Workspace workspace) {
        if (sharedPropertiesManager.isUsingSharedProperties(project = RunConfigurations.checkProject(project), DATA_KEY)) {
            return RunConfigurations.getActiveRunConfiguration(project, workspace, true);
        }
        return RunConfigurations.getActiveRunConfiguration(project, workspace, false);
    }

    public static RunConfiguration getActiveRunConfiguration(Project project, Workspace workspace, boolean useWorkspacePropertyStorage) {
        String name = RunConfigurations.getActiveName(project, workspace, useWorkspacePropertyStorage);
        return name == null ? null : RunConfigurations.getRunConfigurationByName(project, name, true);
    }

    private static Project checkProject(Project project) {
        if (project == null && (project = Ide.getActiveProject()) == null) {
            project = Ide.getDefaultProject();
        }
        return project;
    }

    private static Workspace checkWorkspace(Project project, Workspace workspace) {
        if (workspace == null && (workspace = (project = RunConfigurations.checkProject(project)).getWorkspace()) == null && (workspace = Ide.getActiveWorkspace()) == null) {
            workspace = Ide.getDefaultWorkspace();
        }
        return workspace;
    }
}

