/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.GridBagConstraints2;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.runner.RunMgrArb;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectArg2;
import oracle.jdevimpl.runner.debug.JDebugger;

public final class RemoteConnectDialog {
    public static final String DIALOG_ID = "RemoteConnectDialog";
    private JEWTDialog dlg;
    private JPanel panel = new JPanel(new GridBagLayout());
    private Listener listener = new Listener();
    private int count;
    private DebugConnectArg[] args;
    private boolean[] allowBlanks;
    private boolean[] save;
    private JLabel[] labels;
    private HistoryList[] historyLists;
    private JComponent[] components;
    private JTextField[] editors;
    private JCheckBox saveCheckBox;
    private JCheckBox dontAskCheckBox;
    private JCheckBox attachToDebugWithPid = null;
    private JCheckBox attachToLiveWithPid = null;
    private boolean[] isAttachPid = null;
    private int subIndex = -1;
    private static final String HistoryNamePrefix = "RemoteConnect";

    public static boolean showRemoteConnectDialog(String title, DebugConnectArg[] args) {
        return RemoteConnectDialog.showRemoteConnectDialog(title, args, null, null, null);
    }

    public static boolean showRemoteConnectDialog(String title, DebugConnectArg[] args, String helpId) {
        return RemoteConnectDialog.showRemoteConnectDialog(title, args, null, helpId, null);
    }

    public static boolean showRemoteConnectDialog(String title, DebugConnectArg[] args, boolean[] save) {
        return RemoteConnectDialog.showRemoteConnectDialog(title, args, save, null, null);
    }

    public static boolean showRemoteConnectDialog(String title, DebugConnectArg[] args, boolean[] save, String helpId) {
        return RemoteConnectDialog.showRemoteConnectDialog(title, args, save, helpId, null);
    }

    public static boolean showRemoteConnectDialog(String title, DebugConnectArg[] args, boolean[] save, String helpId, boolean[] isAttachPid) {
        if (save != null && save.length != 1) {
            throw new IllegalArgumentException("save.length must be 1");
        }
        RemoteConnectDialog rcd = new RemoteConnectDialog(args, save, isAttachPid);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)rcd.panel, (Component)rcd.getInitialFocus(), (String)title);
        rcd.setJEWTDialog(dlg);
        rcd.setLabels();
        dlg.setOKButtonEnabled(rcd.canOk());
        if (helpId != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)rcd.panel, helpId);
        }
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            rcd.finish();
            return true;
        }
        return false;
    }

    private RemoteConnectDialog(DebugConnectArg[] args, boolean[] save, boolean[] isAttachPid) {
        int jdiAttachMethodIndex = -1;
        int substr = 0;
        for (int n = 0; n < args.length; ++n) {
            if (!args[n].getName().equals("jdi_attach_method:")) continue;
            jdiAttachMethodIndex = n;
            ++substr;
            this.subIndex = n;
            break;
        }
        this.count = args.length;
        this.args = args;
        this.allowBlanks = new boolean[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.allowBlanks[i] = args[i].allowBlank();
        }
        this.save = save;
        this.isAttachPid = isAttachPid;
        int y = 0;
        this.labels = new JLabel[this.count - substr];
        this.components = new JComponent[this.count - substr];
        this.editors = new JTextField[this.count - substr];
        this.historyLists = new HistoryList[this.count - substr];
        int substract = 0;
        for (int i = 0; i < this.count; ++i) {
            if (i == jdiAttachMethodIndex) {
                ++substract;
                continue;
            }
            DebugConnectArg debugConnectArg = args[i];
            this.labels[i - substract] = new JLabel();
            this.historyLists[i - substract] = Ide.loadHistoryList((String)(HistoryNamePrefix + args[i].getLabel()));
            String[] choices = JDebugger.filterBlanksFromHistoryList(this.historyLists[i - substract].getHistory());
            boolean displayAsCheckbox = false;
            if (debugConnectArg instanceof DebugConnectArg2 && ((DebugConnectArg2)debugConnectArg).getAdditionalInfo("DISPLAY_AS_CHECKBOX") == Boolean.TRUE) {
                displayAsCheckbox = true;
            }
            if (displayAsCheckbox) {
                JCheckBox checkBox = new JCheckBox(debugConnectArg.getLabel());
                if (debugConnectArg.getValue().equalsIgnoreCase("true")) {
                    checkBox.setSelected(true);
                } else {
                    checkBox.setSelected(false);
                }
                this.components[i - substract] = checkBox;
                checkBox.addActionListener(this.listener);
                this.panel.add((Component)checkBox, new GridBagConstraints2(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
                continue;
            }
            JComboBox<String> combo = new JComboBox<String>(choices);
            combo.setEditable(true);
            this.components[i - substract] = combo;
            this.editors[i - substract] = (JTextField)combo.getEditor().getEditorComponent();
            JDebugger.selectHistoryString(combo, args[i].getValue());
            IdeUtil.addComboBoxDocumentListener(combo, (DocumentListener)this.listener);
            combo.addActionListener(this.listener);
            combo.addItemListener(this.listener);
            this.panel.add((Component)this.labels[i - substract], new GridBagConstraints2(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
            this.panel.add(combo, new GridBagConstraints2(1, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        if (save != null) {
            this.saveCheckBox = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this.saveCheckBox, (String)RunMgrArb.getString(22));
            this.panel.add((Component)this.saveCheckBox, new GridBagConstraints2(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        }
        this.dontAskCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.dontAskCheckBox, (String)RunMgrArb.getString(23));
        this.panel.add((Component)this.dontAskCheckBox, new GridBagConstraints2(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.panel.add((Component)new JLabel(), new GridBagConstraints2(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private Component getInitialFocus() {
        if (this.editors.length > 0) {
            return this.editors[0];
        }
        return null;
    }

    private void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
    }

    private void setLabels() {
        int mn;
        int buttonMask;
        int mn2;
        ArrayList<Integer> mnemonics = new ArrayList<Integer>();
        if (this.saveCheckBox != null && (mn2 = this.saveCheckBox.getMnemonic()) != 0) {
            mnemonics.add(mn2);
        }
        if (this.attachToDebugWithPid != null && (mn2 = this.attachToDebugWithPid.getMnemonic()) != 0) {
            mnemonics.add(mn2);
        }
        if (this.attachToLiveWithPid != null && (mn2 = this.attachToLiveWithPid.getMnemonic()) != 0) {
            mnemonics.add(mn2);
        }
        if (((buttonMask = this.dlg.getButtonMask()) & 1) != 0 && (mn = this.dlg.getButtonMnemonic(1)) != 0) {
            mnemonics.add(mn);
        }
        if ((buttonMask & 2) != 0 && (mn = this.dlg.getButtonMnemonic(2)) != 0) {
            mnemonics.add(mn);
        }
        if ((buttonMask & 4) != 0 && (mn = this.dlg.getButtonMnemonic(4)) != 0) {
            mnemonics.add(mn);
        }
        if ((buttonMask & 8) != 0 && (mn = this.dlg.getButtonMnemonic(8)) != 0) {
            mnemonics.add(mn);
        }
        int substract = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.args[i].getLabel().equals("jdi_attach_method:")) {
                ++substract;
                continue;
            }
            Object n = this.args[i].getLabel();
            Integer mnemonicChar = 0;
            for (int ic = 0; ic < ((String)n).length(); ++ic) {
                char c = ((String)n).charAt(ic);
                if (c >= 'a' && c <= 'z') {
                    c = (char)(c - 32);
                }
                if ((c < 'A' || c > 'Z') && (c < '0' || c > '9') || mnemonics.contains(mnemonicChar = Integer.valueOf(c))) continue;
                mnemonics.add(mnemonicChar);
                n = ((String)n).substring(0, ic) + "&" + ((String)n).substring(ic);
                break;
            }
            if (this.components[i - substract] instanceof JComboBox) {
                ResourceUtils.resLabel((JLabel)this.labels[i - substract], (Component)this.editors[i - substract], (String)RunMgrArb.format(21, n));
                continue;
            }
            if (!(this.components[i - substract] instanceof JCheckBox)) continue;
            ((JCheckBox)this.components[i - substract]).setMnemonic(mnemonicChar);
        }
    }

    private void enableOk() {
        this.dlg.setOKButtonEnabled(this.canOk());
    }

    private boolean canOk() {
        int substract = 0;
        for (int i = 0; i < this.count; ++i) {
            String value;
            if (i == this.subIndex) {
                ++substract;
                continue;
            }
            if (this.components[i - substract] instanceof JCheckBox || this.components[i - substract] == null || this.allowBlanks[i - substract] || (value = this.editors[i - substract].getText()).length() != 0) continue;
            return false;
        }
        return true;
    }

    private void finish() {
        int subtract = 0;
        for (int i = 0; i < this.count; ++i) {
            if (i == this.subIndex) {
                ++subtract;
            }
            HistoryList list = this.historyLists[i - subtract];
            if (this.components[i - subtract] instanceof JComboBox) {
                JComboBox combo = (JComboBox)this.components[i - subtract];
                String s = list.comboBoxGetSelectedItem(combo);
                this.args[i].setValue(s.trim());
                continue;
            }
            if (!(this.components[i - subtract] instanceof JCheckBox)) continue;
            JCheckBox checkbox = (JCheckBox)this.components[i - subtract];
            this.args[i].setValue(checkbox.isSelected() ? "true" : "false");
        }
        if (this.save != null) {
            this.save[0] = this.saveCheckBox.isSelected();
        }
        boolean hide = this.dontAskCheckBox.isSelected();
        MessageDialog.getPersistence().setHidden(DIALOG_ID, hide);
        if (this.attachToDebugWithPid != null) {
            this.isAttachPid[1] = this.attachToDebugWithPid.isSelected();
        }
        if (this.attachToLiveWithPid != null) {
            this.isAttachPid[2] = this.attachToLiveWithPid.isSelected();
        }
    }

    class Listener
    implements ActionListener,
    DocumentListener,
    ItemListener {
        Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (RemoteConnectDialog.this.attachToDebugWithPid != null && RemoteConnectDialog.this.attachToDebugWithPid == source) {
                if (RemoteConnectDialog.this.attachToLiveWithPid != null && RemoteConnectDialog.this.attachToLiveWithPid.isSelected()) {
                    RemoteConnectDialog.this.attachToLiveWithPid.setSelected(false);
                }
                if (RemoteConnectDialog.this.attachToDebugWithPid.isSelected()) {
                    ((JComboBox)RemoteConnectDialog.this.components[0]).setSelectedItem(null);
                    RemoteConnectDialog.this.components[0].setEnabled(false);
                } else {
                    RemoteConnectDialog.this.components[0].setEnabled(true);
                }
                return;
            }
            if (RemoteConnectDialog.this.attachToLiveWithPid != null && RemoteConnectDialog.this.attachToLiveWithPid == source) {
                if (RemoteConnectDialog.this.attachToDebugWithPid != null && RemoteConnectDialog.this.attachToDebugWithPid.isSelected()) {
                    RemoteConnectDialog.this.attachToDebugWithPid.setSelected(false);
                }
                if (RemoteConnectDialog.this.attachToLiveWithPid.isSelected()) {
                    ((JComboBox)RemoteConnectDialog.this.components[0]).setSelectedItem(null);
                    RemoteConnectDialog.this.components[0].setEnabled(false);
                } else {
                    RemoteConnectDialog.this.components[0].setEnabled(true);
                }
                return;
            }
            int subtract = 0;
            for (int i = 0; i < RemoteConnectDialog.this.count; ++i) {
                if (i == RemoteConnectDialog.this.subIndex) {
                    ++subtract;
                    continue;
                }
                if (source != RemoteConnectDialog.this.components[i - subtract]) continue;
                if (!(RemoteConnectDialog.this.components[i - subtract] instanceof JComboBox)) break;
                RemoteConnectDialog.this.editors[i - subtract].setText((String)((JComboBox)RemoteConnectDialog.this.components[i - subtract]).getSelectedItem());
                break;
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            RemoteConnectDialog.this.enableOk();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            RemoteConnectDialog.this.enableOk();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            RemoteConnectDialog.this.enableOk();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            RemoteConnectDialog.this.enableOk();
        }
    }
}

