/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.osgi.boot.api.IdeBootProperties;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Starter;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaModule;
import oracle.jdeveloper.java.JavaModel;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JavaOptionProvider;
import oracle.jdeveloper.runner.RunConfiguration;

public class JStarter
extends Starter {
    private static final List<JavaOptionProvider> javaOptionProviders = new ArrayList<JavaOptionProvider>();
    private Element[] explicitCompilationTargets = null;
    private static final int MAX_CLI_CLASSPATH_LENGTH = 7000;
    protected JRunProcess jrunProcess;
    protected String[] target;
    protected RunConfiguration runConfiguration;
    public static final String JAVA_HOME = "java.home";
    public static final String JAVA_VERSION = "java.specification.version";
    public static final String JAVA_ARCH_DATA_MODEL = "sun.arch.data.model";

    public static void addJavaOptionProvider(JavaOptionProvider javaOptionProvider) {
        javaOptionProviders.add(javaOptionProvider);
    }

    public static void removeJavaOptionProvider(JavaOptionProvider javaOptionProvider) {
        javaOptionProviders.remove(javaOptionProvider);
    }

    protected JStarter(JRunProcess jrunProcess, String[] target) {
        super((RunProcess)jrunProcess);
        this.jrunProcess = jrunProcess;
        Assert.check((jrunProcess != null ? 1 : 0) != 0, (String)"jrunProcess is null");
        this.target = target;
        this.runConfiguration = jrunProcess.getRunConfiguration();
        Assert.check((this.runConfiguration != null ? 1 : 0) != 0, (String)"runConfiguration is null");
    }

    public String[] getStartCommand() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.addJavaExecutableName(list)) {
            return new String[0];
        }
        if (!this.addJavaVmOption(list)) {
            return new String[0];
        }
        this.addFirstJavaCommandOptions(list);
        this.addEndorsedDirsOption(list);
        this.addBootClassPathOption(list);
        this.addClassPathOption(list);
        this.addModulePathOption(list);
        this.addJavaOptions(list);
        this.addModuleOptions(list);
        this.addLastJavaCommandOptions(list);
        this.addTarget(list);
        LinkedHashSet<String> uniqueOptions = new LinkedHashSet<String>(list.size());
        for (String option : list) {
            if (uniqueOptions.contains(option)) {
                uniqueOptions.remove(option);
            }
            uniqueOptions.add(option);
        }
        list.clear();
        list.addAll(uniqueOptions);
        this.addProgramArguments(list);
        return list.toArray(new String[list.size()]);
    }

    protected boolean addJavaExecutableName(List<String> list) {
        JDK jdk = this.jrunProcess.getJdkDefinition();
        if (jdk != null) {
            String java = jdk.getSDKBinJavaExecutableNoConsole();
            if (java != null) {
                list.add(java);
                return true;
            }
            java = jdk.getJavaExecutableNoConsole();
            if (java != null) {
                list.add(java);
                return true;
            }
        }
        return false;
    }

    protected boolean addJavaVmOption(List<String> list) {
        String vmName = this.getVMName();
        if (vmName != null && vmName.length() > 0) {
            String s = "-" + vmName;
            list.add(s);
        }
        if (!IdeBootProperties.isAssertTracingDisabled().booleanValue()) {
            list.add("-ea");
        }
        return true;
    }

    protected final String getVMName() {
        JDK jdk = this.jrunProcess.getJdkDefinition();
        return this.runConfiguration.getVMName(jdk);
    }

    protected final void addFirstJavaCommandOptions(List<String> list) {
        String[] a = (String[])this.jrunProcess.getValue("Java", null, "FirstJavaCommandOptions");
        if (a != null) {
            JStarter.addArrayToList(list, a);
        }
    }

    protected void addJavaOptions(List<String> list) {
        this.addJavaOptionProvidersJavaOptions(list);
        this.addProxyJavaOptions(list);
        this.addRunConfigurationJavaOptions(list);
    }

    protected void addModuleOptions(List<String> list) {
        List<String> moduleOptions = this.runConfiguration.getModuleOptions();
        list.addAll(moduleOptions);
    }

    protected void addRunConfigurationJavaOptions(List<String> list) {
        String s = this.runConfiguration.getJavaOptions();
        String[] a = IdeUtil.convertStringToStringArray((String)s, (boolean)true, (boolean)true);
        JStarter.addArrayToList(list, a);
    }

    protected void addJavaOptionProvidersJavaOptions(List<String> list) {
        int size = javaOptionProviders.size();
        for (int i = 0; i < size; ++i) {
            try {
                JavaOptionProvider javaOptionProvider = javaOptionProviders.get(i);
                String[] options = javaOptionProvider.getJavaOptions(this.jrunProcess);
                if (options == null || options.length <= 0) continue;
                JStarter.addArrayToList(list, options);
                continue;
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    protected void addProxyJavaOptions(List<String> list) {
        String[] jpo;
        ProxyOptions po;
        if (this.runConfiguration.isUseProxy() && (po = ProxyOptions.getProxyOptions()) != null && (jpo = po.getJavaProxyOptions()) != null) {
            int length = jpo.length;
            for (int i = 0; i < length; ++i) {
                list.add(jpo[i]);
            }
        }
    }

    protected final void addClassPathOption(List<String> list) {
        String classPath = this.getClassPath();
        if (classPath != null && classPath.length() > 0) {
            String[] a;
            if (classPath.length() > 7000) {
                Manifest manifest = new Manifest();
                manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
                String manifestClassPath = this.convertClasspathToManifestFormat(classPath.toString());
                manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, manifestClassPath);
                try {
                    File temporaryJar = File.createTempFile("jstarter-tmp-", ".jar");
                    temporaryJar.deleteOnExit();
                    JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(temporaryJar), manifest);
                    jarOutputStream.close();
                    classPath = temporaryJar.getAbsolutePath();
                }
                catch (IOException e) {
                    this.runProcess.log((Object)("Error creating temporary jar file encapsulating long classpath: " + e.getMessage() + "\n"));
                    e.printStackTrace();
                }
            }
            if ((a = this.makeClassPathOption(classPath)) != null) {
                JStarter.addArrayToList(list, a);
            }
        }
    }

    protected final void addModulePathOption(List<String> list) {
        String[] a;
        String modulePath = this.runConfiguration.getModulePath();
        if (modulePath != null && modulePath.length() > 0 && (a = this.makeModulePathOption(modulePath)) != null) {
            JStarter.addArrayToList(list, a);
        }
    }

    protected String getClassPath() {
        String processClassPath;
        Project jproject = this.jrunProcess.getJProject();
        Object classPath = PathsConfiguration.getInstance((Project)jproject).getRunClassPath().toString();
        if (classPath == null) {
            classPath = "";
        }
        if ((processClassPath = (String)this.jrunProcess.getValue("Java", null, "ClassPath")) != null && processClassPath.length() != 0) {
            if (((String)classPath).length() > 0) {
                classPath = (String)classPath + File.pathSeparator;
            }
            classPath = (String)classPath + processClassPath;
        }
        return classPath;
    }

    private String[] makeClassPathOption(String classPath) {
        if (classPath != null && classPath.length() > 0) {
            String[] option = new String[]{"-classpath", classPath};
            return option;
        }
        return new String[0];
    }

    private String[] makeModulePathOption(String modulePath) {
        if (modulePath != null && modulePath.length() > 0) {
            String[] option = new String[]{"--module-path", modulePath};
            return option;
        }
        return new String[0];
    }

    protected final void addBootClassPathOption(List<String> list) {
        String[] a;
        String classPath = this.getBootClassPath();
        if (classPath != null && classPath.length() > 0 && (a = this.makeBootClassPathOption(classPath)) != null) {
            JStarter.addArrayToList(list, a);
        }
    }

    protected final void addEndorsedDirsOption(List<String> list) {
        URLPath urlPath;
        String endorsedDirs;
        Project project = this.jrunProcess.getJProject();
        if (project != null && (endorsedDirs = (urlPath = PathsConfiguration.getInstance((Project)project).getEndorsedStandardsDirectories()).toString()) != null && endorsedDirs.trim().length() > 0) {
            String[] endorsedOption = new String[]{"-Djava.endorsed.dirs=" + endorsedDirs.trim()};
            JStarter.addArrayToList(list, endorsedOption);
        }
    }

    protected String getBootClassPath() {
        Object bootClassPath = "";
        String processBootClassPath = (String)this.jrunProcess.getValue("Java", null, "BootClassPath");
        if (processBootClassPath != null && processBootClassPath.length() != 0) {
            bootClassPath = (String)bootClassPath + processBootClassPath;
        }
        return bootClassPath;
    }

    void fireCompilationError() {
    }

    private String[] makeBootClassPathOption(String classPath) {
        if (classPath != null && classPath.length() > 0) {
            String[] option = new String[]{"-Xbootclasspath/a:" + classPath};
            return option;
        }
        return new String[0];
    }

    protected final void addLastJavaCommandOptions(List<String> list) {
        String[] a = (String[])this.jrunProcess.getValue("Java", null, "LastJavaCommandOptions");
        if (a != null) {
            JStarter.addArrayToList(list, a);
        }
    }

    private void addTarget(List<String> list) {
        if (this.target == null || this.target.length == 0) {
            return;
        }
        Project project = this.jrunProcess.getJProject();
        if (project != null && RunConfiguration.isJDK9OrLaterProject(project)) {
            URLPath sourcePath = PathsConfiguration.getInstance((Project)project).getProjectSourcePath();
            for (URL sourcePathEntry : sourcePath.getEntries()) {
                String moduleName;
                JavaModule module;
                URLPath classPath;
                JavaFile moduleInfoFile;
                URL moduleInfoPath = URLFactory.newURL((URL)sourcePathEntry, (String)"module-info.java");
                if (moduleInfoPath == null || !URLFileSystem.canRead((URL)moduleInfoPath) || (moduleInfoFile = JavaModel.getInstance((URLPath)sourcePath, (URLPath)(classPath = PathsConfiguration.getInstance((Project)project).getRunClassPath())).getFile(moduleInfoPath)) == null || (module = moduleInfoFile.getModule()) == null || (moduleName = module.getName()) == null) continue;
                ArrayList<Object> targetModule = new ArrayList<Object>();
                targetModule.add("-m");
                targetModule.add(moduleName + "/" + this.target[0]);
                if (this.target.length > 1) {
                    for (int i = 1; i < this.target.length; ++i) {
                        targetModule.add(this.target[i]);
                    }
                }
                this.target = targetModule.toArray(new String[targetModule.size()]);
                break;
            }
        }
        if (this.target != null) {
            JStarter.addArrayToList(list, this.target);
        }
    }

    protected void addProgramArguments(List<String> list) {
        String s = this.runConfiguration.getProgramArguments();
        String[] a = IdeUtil.convertStringToStringArray((String)s, (boolean)true, (boolean)true);
        JStarter.addArrayToList(list, a);
        int size = javaOptionProviders.size();
        for (int i = 0; i < size; ++i) {
            try {
                JavaOptionProvider javaOptionProvider = javaOptionProviders.get(i);
                String[] arguments = javaOptionProvider.getProgramArguments(this.jrunProcess);
                if (arguments == null || arguments.length <= 0) continue;
                JStarter.addArrayToList(list, arguments);
                continue;
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    protected static void addArrayToList(List<String> list, String[] a) {
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            list.add(a[i]);
        }
    }

    protected JRunProcess.CompilationScope getCompilationScope() {
        return this.jrunProcess.getCompilationScope();
    }

    protected Element[] getExplicitCompilationTargets() {
        return this.explicitCompilationTargets;
    }

    protected void setExplicitCompilationTargets(Element[] targets) {
        this.explicitCompilationTargets = targets;
    }

    public String getJdkSystemProperty(String key) {
        if (JAVA_HOME.equals(key) || JAVA_VERSION.equals(key) || JAVA_ARCH_DATA_MODEL.equals(key)) {
            return this.jrunProcess.getJdkDefinition().getSystemProperties().getProperty(key);
        }
        return null;
    }

    private String convertClasspathToManifestFormat(String classPath) {
        String[] paths = classPath.split(String.valueOf(File.pathSeparatorChar));
        StringBuilder resultPath = new StringBuilder();
        for (String path : paths) {
            try {
                resultPath.append(new File(path).toURI().toURL());
                resultPath.append(" ");
            }
            catch (MalformedURLException e) {
                assert (false) : "Logic error: there is some invalid construction in classpath construction code";
                this.runProcess.log((Object)("Invalid path '" + path + "'. Unable to include it in classpath. MalformedURLException: " + e.getMessage()));
            }
        }
        return resultPath.toString();
    }
}

