/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.CreateFile;
import oracle.ideimpl.deferredupdate.task.ReadPropertiesFile;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;
import oracle.ideimpl.deferredupdate.task.TaskStack;
import oracle.ideimpl.deferredupdate.task.WritePropertiesFile;

class ScheduleHookTask
extends AtomicTask {
    private String hookClass;
    private String hookRegistryFile;
    private String extensionId;
    private TaskStack _tasks;

    ScheduleHookTask(String hookClass, String hookRegistryFile, String extensionId) {
        this.hookClass = hookClass;
        this.hookRegistryFile = hookRegistryFile;
        this.extensionId = extensionId;
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        this._tasks = new TaskStack();
        File regFile = new File(this.hookRegistryFile);
        if (!regFile.exists()) {
            this._tasks.performTask(new CreateFile(regFile), tc);
        }
        ReadPropertiesFile readProperties = new ReadPropertiesFile(regFile);
        this._tasks.performTask(readProperties, tc);
        Properties originalProperties = readProperties.getLoadedProperties();
        Properties newProperties = new Properties();
        newProperties.putAll((Map<?, ?>)originalProperties);
        newProperties.put(this.hookClass, this.extensionId);
        this._tasks.performTask(new WritePropertiesFile(regFile, originalProperties, newProperties), tc);
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        if (this._tasks != null) {
            this._tasks.rollbackTasks(tc);
        }
    }

    @Override
    public void commit(TaskContext tc) throws TaskFailedException {
        this._tasks.commitTasks(tc);
    }
}

