/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Scanner;
import java.util.logging.Logger;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.DeleteExtraInfoTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;
import oracle.ideimpl.deferredupdate.task.TaskStack;

public class DeinstallCustomUpdateTask
extends AtomicTask {
    private static final Logger LOG = Logger.getLogger(DeinstallCustomUpdateTask.class.getName());
    private TaskStack _tasks;
    private String command;
    private String updateId;
    private String version;
    private String oracleHome;

    DeinstallCustomUpdateTask(String command, String updateId, String version, String oracleHome) {
        this.command = command;
        this.updateId = updateId;
        this.version = version;
        this.oracleHome = oracleHome;
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        this._tasks = new TaskStack();
        this.uninstallCustomUpdate();
        this._tasks.performTask(new DeleteExtraInfoTask(this.updateId), tc);
    }

    private void uninstallCustomUpdate() throws TaskFailedException {
        System.out.println(UpdateArb.format("CUSTOM_UPDATE_UNINSTALLING", this.updateId));
        int retCode = 0;
        try {
            String mwHome = this.oracleHome + (this.oracleHome.substring(this.oracleHome.length() - 1).equals(File.separator) ? "" : File.separator) + "..";
            ProcessBuilder pb = new ProcessBuilder((mwHome + File.separator + this.command).split(";"));
            pb.redirectErrorStream(true);
            Process p = pb.start();
            final BufferedWriter stdOutput = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            final Scanner scan = new Scanner(System.in);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (scan.hasNext()) {
                        String input = scan.nextLine();
                        try {
                            stdOutput.write(input + "\n");
                            stdOutput.flush();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }
            }).start();
            String s = stdInput.readLine();
            while (s != null) {
                System.out.println(s);
                s = stdInput.readLine();
            }
            retCode = p.waitFor();
            if (retCode == 0) {
                System.out.println(UpdateArb.format("CUSTOM_UPDATE_UNINSTALL_SUCCESS", this.updateId));
            } else {
                System.out.println(UpdateArb.format("CUSTOM_UPDATE_UNINSTALL_FAILED", this.updateId));
            }
        }
        catch (IOException ioe) {
            throw new TaskFailedException(UpdateArb.format("CUSTOM_UPDATE_NOT_FOUND", new Object[0]));
        }
        catch (InterruptedException ir) {
            throw new TaskFailedException(UpdateArb.format("CUSTOM_UPDATE_UNINSTALL_INTERRUPTED", this.updateId));
        }
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        if (this._tasks != null) {
            this._tasks.rollbackTasks(tc);
        }
    }

    @Override
    public void commit(TaskContext tc) throws TaskFailedException {
        this._tasks.commitTasks(tc);
    }
}

