/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BundlesInfoUtil {
    public static final String BUNDLES_INFO_SUFFIX = "bundles.info";
    public static final String CFU_BUNDLES_INFO = "cfu_bundles.info";
    public static final String CFU_BUNDLES_INFO_FILENAME = "file:cfu_bundles.info";
    public static final String EDT_BUNDLES_INFO = "edt_bundles.info";
    public static final String EDT_BUNDLES_INFO_FILENAME = "file:edt_bundles.info";
    public static final String SIMPLE_CONFIGURATOR = "org.eclipse.equinox.simpleconfigurator.configUrl";

    public static InstallationSource getInstallationSource(String oracleHomePath) {
        InstallationSource is = new InstallationSource(oracleHomePath);
        is.load();
        return is;
    }

    private static String getPathPart(String path) {
        try {
            return new URL(path).getPath();
        }
        catch (MalformedURLException e) {
            return path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, BundleData> readBundlesInfo(String path) throws FileNotFoundException, IOException {
        HashMap<String, BundleData> bundleEntries = new HashMap<String, BundleData>();
        if (new File(path).exists()) {
            try (BufferedReader in = new BufferedReader(new FileReader(path));){
                String str;
                while ((str = in.readLine()) != null) {
                    if (!BundlesInfoUtil.isEntryValid(str)) continue;
                    String[] fields = str.split(",");
                    String symbolicName = fields[0];
                    String version = fields[1];
                    String relativePath = fields[2];
                    int runLevel = Integer.parseInt(fields[3]);
                    boolean enabled = Boolean.parseBoolean(fields[4]);
                    long timestamp = 0L;
                    try {
                        timestamp = Long.parseLong(fields[5]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    String jarName = new File(relativePath).getName();
                    BundleData data = new BundleData(symbolicName, version, relativePath, runLevel, enabled, timestamp);
                    bundleEntries.put(jarName, data);
                }
            }
        }
        return bundleEntries;
    }

    public static boolean isEntryValid(String entry) {
        int lastIndex = -1;
        for (int i = 0; i < 4; ++i) {
            int index = entry.indexOf(44, lastIndex + 1);
            if (index < lastIndex + 2) {
                return false;
            }
            lastIndex = index;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeBundlesInfo(String path, Collection<BundleData> entries, boolean append) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(path, append));
            for (BundleData data : entries) {
                out.write(data.toString() + "\n");
            }
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                Logger.getLogger("oracle.ide.osgi.boot").log(Level.FINE, "Failed while closing buffered writer for path " + path, e);
            }
        }
        return true;
    }

    public static final class InstallationSource {
        private final Map<String, Collection<String>> m_savedEntries;
        private final Map<String, Collection<String>> m_changes;
        private final String m_configurationDirPath;
        private final Set<String> m_bundleFileSourcePrefixes;
        private boolean m_isEmpty = false;

        public static InstallationSource create(String oracleHomePath) {
            if (oracleHomePath == null) {
                throw new NullPointerException("oracleHomePath can't be null in InstallationSource.<ctor>(String)");
            }
            return new InstallationSource(oracleHomePath);
        }

        InstallationSource(String oracleHomePath) {
            StringBuilder configurationPathBuilder = new StringBuilder();
            configurationPathBuilder.append(oracleHomePath);
            if (!oracleHomePath.endsWith("/") && !oracleHomePath.endsWith("\\")) {
                configurationPathBuilder.append(File.separator);
            }
            configurationPathBuilder.append("configuration" + File.separator);
            this.m_configurationDirPath = configurationPathBuilder.toString();
            this.m_changes = new ConcurrentHashMap<String, Collection<String>>();
            this.m_savedEntries = new ConcurrentHashMap<String, Collection<String>>();
            this.m_bundleFileSourcePrefixes = new HashSet<String>();
            File configurationDirectory = new File(this.m_configurationDirPath);
            String[] bundleInfoFiles = configurationDirectory.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(BundlesInfoUtil.BUNDLES_INFO_SUFFIX) && !name.equals(BundlesInfoUtil.EDT_BUNDLES_INFO) && !name.equals(BundlesInfoUtil.CFU_BUNDLES_INFO) && !name.equals(BundlesInfoUtil.BUNDLES_INFO_SUFFIX);
                }
            });
            if (bundleInfoFiles == null) {
                this.m_isEmpty = true;
            } else {
                for (String prefix : bundleInfoFiles) {
                    this.m_bundleFileSourcePrefixes.add(prefix.substring(0, prefix.length() - BundlesInfoUtil.BUNDLES_INFO_SUFFIX.length()));
                }
            }
        }

        public boolean isEmpty() {
            return this.m_isEmpty;
        }

        public InstallationSource add(String bundleDatum, INSTALL_TYPE type) {
            if (bundleDatum == null || type == null) {
                throw new NullPointerException("null arguments not permitted in BundleInfoUtil.InstallationSource.add(String,INSTALL_TYPE)");
            }
            return this.add(bundleDatum, type.toString());
        }

        public InstallationSource add(String bundleDatum, String installPrefix) {
            if (bundleDatum == null || installPrefix == null) {
                throw new NullPointerException("null arguments not permitted in BundleInfoUtil.InstallationSource.add(String,String)");
            }
            this.m_changes.get(installPrefix).add(bundleDatum);
            return this;
        }

        public InstallationSource addAll(Collection<String> bundleData, INSTALL_TYPE type) {
            if (bundleData == null || type == null) {
                throw new NullPointerException("null arguments not permitted in BundleInfoUtil.InstallationSource.addAll(Collection<String>,INSTALL_TYPE)");
            }
            return this.addAll(bundleData, type.toString());
        }

        public InstallationSource addAll(Collection<String> bundleData, String installPrefix) {
            if (bundleData == null || installPrefix == null) {
                throw new NullPointerException("null arguments not permitted in BundleInfoUtil.InstallationSource.addAll(Collection<String>,String)");
            }
            this.m_changes.get(installPrefix).addAll(bundleData);
            return this;
        }

        private boolean removeFromPrefix(String prefix, String bundleSymbolicName) {
            boolean removedFromOriginals = InstallationSource._remove(this.m_savedEntries.get(prefix), bundleSymbolicName);
            boolean removedFromChanges = InstallationSource._remove(this.m_changes.get(prefix), bundleSymbolicName);
            return removedFromOriginals || removedFromChanges;
        }

        public boolean removeByName(String bundleSymbolicName) {
            for (INSTALL_TYPE type : INSTALL_TYPE.values()) {
                if (!this.removeFromPrefix(type.toString(), bundleSymbolicName)) continue;
                return true;
            }
            for (String prefix : this.m_bundleFileSourcePrefixes) {
                if (!this.removeFromPrefix(prefix, bundleSymbolicName)) continue;
                return true;
            }
            return false;
        }

        private static boolean _remove(Collection<String> bundleInfoList, String bundleSymbolicName) {
            String bd = InstallationSource._listFind(bundleInfoList, bundleSymbolicName);
            if (bd != null) {
                return bundleInfoList.remove(bd);
            }
            return false;
        }

        private File _getBundleInfoFilesLegacyStyle(INSTALL_TYPE type) {
            File configurationArea = new File(this.m_configurationDirPath);
            if (!configurationArea.exists()) {
                throw new IllegalStateException("Invalid configuration area path " + configurationArea.getPath());
            }
            String relativeFilePath = null;
            if (type.equals((Object)INSTALL_TYPE.DEFAULT)) {
                relativeFilePath = BundlesInfoUtil.getPathPart(System.getProperty(BundlesInfoUtil.SIMPLE_CONFIGURATOR));
            } else if (type.equals((Object)INSTALL_TYPE.EDT)) {
                relativeFilePath = BundlesInfoUtil.getPathPart(BundlesInfoUtil.EDT_BUNDLES_INFO_FILENAME);
            } else if (type.equals((Object)INSTALL_TYPE.CFU)) {
                relativeFilePath = BundlesInfoUtil.getPathPart(BundlesInfoUtil.CFU_BUNDLES_INFO_FILENAME);
            }
            return new File(configurationArea, relativeFilePath);
        }

        private File _getBundleInfoFile(String componentPrefix) {
            File configurationArea = new File(this.m_configurationDirPath);
            if (!configurationArea.exists()) {
                throw new IllegalStateException("Invalid configuration area path " + configurationArea.getPath());
            }
            StringBuilder sb = new StringBuilder();
            sb.append(componentPrefix).append(BundlesInfoUtil.BUNDLES_INFO_SUFFIX);
            return new File(configurationArea, sb.toString());
        }

        public void load() {
            this.loadComponentPrefixBundleInfos();
            this.loadLegacyBundleInfos();
        }

        private void loadComponentPrefixBundleInfos() {
            for (String prefix : this.m_bundleFileSourcePrefixes) {
                this.m_savedEntries.put(prefix, Collections.synchronizedList(new LinkedList()));
                this.m_changes.put(prefix, Collections.synchronizedList(new LinkedList()));
                this._parseBundlesInfoFile(prefix);
            }
        }

        private void loadLegacyBundleInfos() {
            for (INSTALL_TYPE type : INSTALL_TYPE.values()) {
                this.m_savedEntries.put(type.toString(), Collections.synchronizedList(new LinkedList()));
                this.m_changes.put(type.toString(), Collections.synchronizedList(new LinkedList()));
                this._parseBundlesInfoFile(type);
            }
        }

        private void _parseBundlesInfoFile(INSTALL_TYPE type) {
            this._parsePrefix(type.toString(), this._getBundleInfoFilesLegacyStyle(type));
        }

        private void _parseBundlesInfoFile(String prefix) {
            this._parsePrefix(prefix, this._getBundleInfoFile(prefix));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _parsePrefix(String prefix, File bundleInfoFile) {
            if (bundleInfoFile.exists()) {
                BufferedReader in = null;
                try {
                    String str;
                    ArrayList<String> bundleData = new ArrayList<String>();
                    in = new BufferedReader(new FileReader(bundleInfoFile.getPath()));
                    while ((str = in.readLine()) != null) {
                        int commaIndex;
                        if (!BundlesInfoUtil.isEntryValid(str) || (commaIndex = str.indexOf(44)) <= 0) continue;
                        bundleData.add(str);
                    }
                    this.m_savedEntries.get(prefix).addAll(bundleData);
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        Logger.getLogger("oracle.ide.osgi.boot").log(Level.FINE, "Failed while closing buffered reader for " + bundleInfoFile, e);
                    }
                }
            }
        }

        private static Collection<BundleData> _toBundleData(Collection<String> bundleDataAsStrings) {
            LinkedList<BundleData> bdata = new LinkedList<BundleData>();
            for (String bdString : bundleDataAsStrings) {
                bdata.add(BundleData.create(bdString));
            }
            return bdata;
        }

        public synchronized void saveChanges() {
            for (String prefix : this.m_savedEntries.keySet()) {
                this.save(prefix);
            }
        }

        public synchronized void save(INSTALL_TYPE type) {
            this.save(type.toString());
        }

        public synchronized void save(String prefix) {
            File bundleInfoFile;
            boolean writeSuccessful;
            Collection<String> changes = this.m_changes.get(prefix);
            if (!changes.isEmpty() && (writeSuccessful = BundlesInfoUtil.writeBundlesInfo((bundleInfoFile = this._getBundleInfoFile(prefix)).getPath(), InstallationSource._toBundleData(changes), true))) {
                this.m_savedEntries.get(prefix).addAll(changes);
            }
        }

        public synchronized boolean isDirty() {
            for (String prefix : this.m_savedEntries.keySet()) {
                if (this.m_changes.get(prefix).isEmpty()) continue;
                return true;
            }
            return false;
        }

        public synchronized boolean delete(INSTALL_TYPE type) {
            File bundleInfoFile = this._getBundleInfoFilesLegacyStyle(type);
            return bundleInfoFile.delete();
        }

        public Collection<String> getEDTSources() {
            ArrayList<String> EDTsources = new ArrayList<String>(this.m_savedEntries.get((Object)INSTALL_TYPE.EDT));
            EDTsources.addAll(this.m_changes.get((Object)INSTALL_TYPE.EDT));
            return EDTsources;
        }

        public Collection<String> getCFUSources() {
            ArrayList<String> CFUsources = new ArrayList<String>(this.m_savedEntries.get((Object)INSTALL_TYPE.CFU));
            CFUsources.addAll(this.m_changes.get((Object)INSTALL_TYPE.CFU));
            return CFUsources;
        }

        public Collection<String> getDefaultSources() {
            ArrayList<String> defaultSources = new ArrayList<String>(this.m_savedEntries.get((Object)INSTALL_TYPE.DEFAULT));
            defaultSources.addAll(this.m_changes.get((Object)INSTALL_TYPE.DEFAULT));
            return defaultSources;
        }

        public Collection<String> getAllSources() {
            ArrayList<String> allInstallationSources = new ArrayList<String>();
            for (String prefix : this.m_savedEntries.keySet()) {
                allInstallationSources.addAll(this.m_savedEntries.get(prefix));
                allInstallationSources.addAll(this.m_changes.get(prefix));
            }
            return allInstallationSources;
        }

        public synchronized Map<String, Collection<String>> getInstallationSource() {
            if (this.isDirty()) {
                this.saveChanges();
            }
            return this.m_savedEntries;
        }

        public int size() {
            int size = 0;
            for (String prefix : this.m_savedEntries.keySet()) {
                size += this.m_savedEntries.get(prefix).size();
                size += this.m_changes.get(prefix).size();
            }
            return size;
        }

        public String getConfigurationDirectoryPath() {
            return this.m_configurationDirPath;
        }

        public Boolean isLoaded() {
            return !this.m_changes.isEmpty();
        }

        public String find(String bundleSymbolicName) {
            for (String prefix : this.m_savedEntries.keySet()) {
                String entry = InstallationSource._listFind(this.m_savedEntries.get(prefix), bundleSymbolicName);
                if (entry != null) {
                    return entry;
                }
                entry = InstallationSource._listFind(this.m_changes.get(prefix), bundleSymbolicName);
                if (entry == null) continue;
                return entry;
            }
            return null;
        }

        private static String _listFind(Collection<String> bundleInfos, String bundleSymbolicName) {
            for (String bundleInfoDatum : bundleInfos) {
                int indexOfComma = bundleInfoDatum.indexOf(",");
                if (indexOfComma == -1 || !bundleSymbolicName.equals(bundleInfoDatum.substring(0, indexOfComma))) continue;
                return bundleInfoDatum;
            }
            return null;
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum INSTALL_TYPE {
            CFU{

                public String toString() {
                    return "cfu_";
                }
            }
            ,
            EDT{

                public String toString() {
                    return "edt_";
                }
            }
            ,
            DEFAULT{

                public String toString() {
                    return "";
                }
            };

        }
    }

    public static class BundleData {
        private static final char SEPARATOR = ',';
        String symbolicName;
        String version;
        String relativePath;
        int runLevel;
        boolean enabled;
        long timestamp;

        public static BundleData create(String bundleInfoDatum) {
            String[] fields = bundleInfoDatum.split(",");
            String symbolicName = fields[0];
            String version = fields[1];
            String relativePath = fields[2];
            int runLevel = Integer.parseInt(fields[3]);
            boolean enabled = Boolean.parseBoolean(fields[4]);
            long timestamp = 0L;
            try {
                timestamp = fields.length == 6 ? Long.parseLong(fields[5]) : 0L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new BundleData(symbolicName, version, relativePath, runLevel, enabled, timestamp);
        }

        public BundleData(String symbolicName, String version, String relativePath, int runLevel, boolean enabled, long timestamp) {
            this.symbolicName = symbolicName;
            this.version = version;
            this.relativePath = relativePath;
            this.runLevel = runLevel;
            this.enabled = enabled;
            this.timestamp = timestamp;
        }

        public String toString() {
            return this.symbolicName + "," + this.version + "," + this.relativePath + "," + this.runLevel + "," + this.enabled + "," + this.timestamp;
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public String getVersion() {
            return this.version;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof BundleData)) {
                return false;
            }
            BundleData other = (BundleData)object;
            return this.symbolicName != null ? this.symbolicName.equals(other.symbolicName) : other.symbolicName == null;
        }

        public int hashCode() {
            int PRIME = 37;
            int result = 1;
            result = 37 * result + (this.symbolicName == null ? 0 : this.symbolicName.hashCode());
            return result;
        }

        public int getRunLevel() {
            return this.runLevel;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

