/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.dbcart.tools.DbCartTool;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.export.wizard.TargetOptionsPanel;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class DbCartSaveAsTool
extends DbCartTool {
    public static final String TYPE = "Save_As";
    public static int ACTION = Ide.findOrCreateCmdID((String)"cart_save_as");
    private JEWTDialog _actionDialog;
    private TargetOptionsPanel _targetOptions;
    private TargetFormat _targetFormat;
    private String _name;

    public DbCartSaveAsTool() {
        super(TYPE, 0);
    }

    public DbCartSaveAsTool(String string, int n) {
        super(string, n);
    }

    @Override
    public IdeAction getAction() {
        if (this._action == null) {
            this._action = IdeAction.get((int)ACTION, null, (String)DbCartAddinArb.getString("CART_SAVE_AS_LABEL"), null, null, (Icon)RaptorImagesArb.getIcon((String)"SAVEAS"), null, (boolean)true);
            this._action.addController((Controller)this);
        }
        return this._action;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == ACTION) {
            this.showDialog();
            return true;
        }
        return false;
    }

    public void showDialog() {
        String string = DbCartAddinArb.getString("SAVE_AS_CART_DIALOG_TITLE");
        String string2 = DbCartAddinArb.format("SAVE_CART_INSTRUCTIONS", DbCartUtil.getTabPageName());
        JLabel jLabel = new JLabel(string2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_saveascartobjects_html");
        this._targetFormat = new TargetFormat(1, 3);
        this._targetFormat.setShowEncoding(true);
        this._targetFormat.setShowCompression(false);
        this._targetFormat.setShowSaveAsType(false);
        this._targetFormat.isCompressed(false);
        this._targetFormat.setSaveAsType(0);
        String string3 = File.separator;
        this._name = this._targetFormat.getDefaultDirectory();
        if (!this._name.endsWith(string3)) {
            this._name = this._name + string3;
        }
        this._name = this._name + DbCartUtil.getTabPageName() + ".sdcart";
        this._targetFormat.setSaveAs(this._name);
        this._targetOptions = new TargetOptionsPanel((Component)jPanel, this._targetFormat);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this._targetOptions.getPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 2, new Insets(16, 0, 0, 0), 0, 0));
        jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this._actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                    DbCartSaveAsTool.this._targetFormat = DbCartSaveAsTool.this._targetOptions.getFormat();
                    n = DbCartSaveAsTool.this._targetFormat.validateSaveAsFile((Component)Ide.getMainWindow());
                    if (n == 0) {
                        File file = new File(DbCartSaveAsTool.this._targetFormat.getSaveAs());
                        DbCartSaveAsTool.this.saveCart(file, DbCartSaveAsTool.this._targetFormat.getEncoding());
                        DbCartUtil.getTableModel().setSaveAs(DbCartSaveAsTool.this._targetFormat.getSaveAs());
                        DbCartUtil.getTableModel().setSaveAsEncoding(DbCartSaveAsTool.this._targetFormat.getEncoding());
                        if (!DbCartSaveAsTool.this._name.equals(DbCartSaveAsTool.this._targetFormat.getSaveAs())) {
                            DbCartUtil.setTabPageName(DbCartUtil.getTableModel().getSaveAsTabName());
                        }
                    }
                }
                if (n == 0) {
                    DbCartSaveAsTool.this._actionDialog.setVisible(false);
                    DbCartSaveAsTool.this._actionDialog.dispose();
                } else if (n == 1) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartSaveAsTool.this._targetFormat.getValidationMessage(), (String)DbCartAddinArb.getString("CART_SAVE_AS_LABEL"), (String)"DBCART_FILE_ERROR");
                }
            }
        };
        this._actionDialog.addActionListener(actionListener);
        Dimension dimension = jPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 200;
        this._actionDialog.setMinimumSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._actionDialog);
        WizardLauncher.runDialog((JDialog)this._actionDialog);
    }

    public void saveCart(File file, String string) {
        try {
            if (string == null) {
                string = IdeUtil.getIdeEncoding();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string);
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"" + string + "\" ?>\n");
            outputStreamWriter.write("<cart>\n");
            ArrayList<ExtractObject> arrayList = DbCartUtil.getTableModel().getAllRows();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (ExtractObject object : arrayList) {
                if (!object.isTypeDBO() || hashMap.containsKey(object.getSourceConnName())) continue;
                hashMap.put(object.getSourceConnName(), object.getSourceConnUser(false));
            }
            Set set = hashMap.keySet();
            if (!set.isEmpty()) {
                outputStreamWriter.write("<connections>\n");
            }
            for (String string2 : set) {
                outputStreamWriter.write("<connection>\n");
                outputStreamWriter.write("<displayname><![CDATA[" + Connections.getDisplayName((String)string2) + "]]></displayname>\n");
                outputStreamWriter.write("<connectionname><![CDATA[" + string2 + "]]></connectionname>\n");
                outputStreamWriter.write("<connectionuser><![CDATA[" + (String)hashMap.get(string2) + "]]></connectionuser>\n");
                outputStreamWriter.write("</connection>\n");
            }
            if (!set.isEmpty()) {
                outputStreamWriter.write("</connections>\n");
            }
            outputStreamWriter.write("<objects>\n");
            for (ExtractObject extractObject : arrayList) {
                outputStreamWriter.write(extractObject.toXML(0));
            }
            outputStreamWriter.write("</objects>\n");
            outputStreamWriter.write("</cart>");
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString((String)"ReportNavigatorContextMenu.73"), (String)Messages.getString((String)"ReportNavigatorContextMenu.74"), (String)"f1_exportbadfile_html");
        }
    }

    @Override
    public void openConfigOptions() {
    }

    @Override
    public void saveConfigOptions() {
    }
}

