/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.util;

import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.vcs.svn.SVNAuthenticationManager;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.prefs.SVNEnvironmentPrefs;
import oracle.jdevimpl.vcs.svn.util.NullLogHandler;
import oracle.jdevimpl.vcs.svn.util.SVNLogHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public final class SVNRepositoryInfoValidator {
    private static final SVNLogHandler sNullHandler = new NullLogHandler();
    private SVNRepositoryInfo _reposInfo;
    private SVNWCClient _client;
    private SVNLogHandler _handler;

    public SVNRepositoryInfoValidator(SVNRepositoryInfo reposInfo, SVNWCClient client) {
        if (reposInfo == null || client == null) {
            throw new NullPointerException();
        }
        this._reposInfo = reposInfo;
        this._client = client;
    }

    public SVNRepositoryInfoValidator(SVNRepositoryInfo reposInfo, SVNWCClient client, SVNLogHandler notificationHandler) {
        this(reposInfo, client);
        this._handler = notificationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() throws TimeoutException {
        SVNEnvironmentPrefs prefs = SVNEnvironmentPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
        InfoRunnable ir = new InfoRunnable();
        try {
            Thread t = new Thread((Runnable)ir, "SVNRepositoryInfoValidator");
            t.start();
            t.join(prefs.getOperationTimeout() * 1000);
            if (ir._isRepoValid == null) {
                throw new TimeoutException();
            }
            boolean bl = ir._isRepoValid;
            return bl;
        }
        catch (TimeoutException te) {
            throw te;
        }
        catch (Exception e) {
            SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
            this.getHandler().writeMessage(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            SVNAuthenticationManager.getInstance().remove(this._reposInfo);
        }
    }

    private SVNLogHandler getHandler() {
        return this._handler != null ? this._handler : sNullHandler;
    }

    private final class InfoRunnable
    implements Runnable {
        private Boolean _isRepoValid = null;

        private InfoRunnable() {
        }

        @Override
        public void run() {
            try {
                SVNInfo info = SVNRepositoryInfoValidator.this._client.doInfo(SVNRepositoryInfoValidator.this._reposInfo.getSVNURL(), null, null);
                this._isRepoValid = info != null && info.getRevision() != null;
            }
            catch (SVNException ie) {
                SVNRepositoryInfoValidator.this.getHandler().writeMessage(ie.getMessage());
                this._isRepoValid = false;
            }
        }
    }

    public static final class TimeoutException
    extends Exception {
    }
}

