/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.jdevimpl.vcs.svn.op.ui.ExportPathListener;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRevisionLister;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class ExportFromReposPanel
extends JPanel {
    private final SVNRevision _revisionStart = SVNRevision.HEAD;
    private final SVNRevision _revisionEnd = new SVNRevision.Number(0L);
    private SVNUrl _reposUrl;
    private final Collection _listeners = new LinkedList();
    private JLabel _reposPathLabel;
    private JLabel _reposPath;
    private JLabel _destLabel;
    private FileField _fileField;
    private JButton _browseButton;
    private JCheckBox _revCheckBox;
    private JTextField _revField;
    private JButton _revButton;

    public ExportFromReposPanel(SVNUrl reposPath) {
        super(new GridBagLayout());
        this._reposUrl = reposPath;
        this.createComponents(reposPath);
        this.layoutComponents();
        this.initListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExportPathListener(ExportPathListener listener) {
        Collection collection = this._listeners;
        synchronized (collection) {
            this._listeners.add(listener);
        }
    }

    public URL getExportPath() {
        String path = this._fileField.getText();
        return path != null && path.length() > 0 ? URLFactory.newDirURL((String)path) : null;
    }

    public SVNRevision getRevision() {
        String revStr;
        if (this._revCheckBox.isSelected() && (revStr = this._revField.getText()) != null && revStr.length() > 0) {
            try {
                return SVNRevision.getRevision((String)revStr);
            }
            catch (ParseException pe) {
                return SVNRevision.INVALID_REVISION;
            }
        }
        return SVNRevision.HEAD;
    }

    private void createComponents(SVNUrl reposUrl) {
        this._reposPath = new JLabel();
        this._reposPath.setText(reposUrl.toString());
        this._reposPathLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._reposPathLabel, (Component)this._reposPath, (String)Resource.get("UI_EXP_REPOSPATH"));
        this._fileField = new FileField(true);
        this._fileField.setText("");
        this._destLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._destLabel, (Component)this._fileField, (String)Resource.get("UI_EXP_DEST"));
        this._browseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._browseButton, (String)Resource.get("UI_EXP_BROWSE"));
        this._revField = new JTextField();
        this._revField.setText("");
        this._revField.setEnabled(false);
        this._revCheckBox = new JCheckBox();
        this._revCheckBox.setSelected(false);
        ResourceUtils.resButton((AbstractButton)this._revCheckBox, (String)Resource.get("UI_EXP_REV"));
        this._revButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._revButton, (String)Resource.get("EXPORT_REVISION_BUTTON"));
    }

    private void layoutComponents() {
        this.add((Component)this._reposPathLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this._reposPath, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 17, 2, new Insets(6, 5, 0, 0), 0, 0));
        this.add((Component)this._destLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.add((Component)this._fileField, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(6, 5, 0, 0), 0, 0));
        this.add((Component)this._browseButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 5, 0, 0), 0, 0));
        this.add((Component)this._revCheckBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(16, 5, 5, 0), 0, 0));
        this.add((Component)this._revField, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(16, 5, 5, 0), 0, 0));
        this.add((Component)this._revButton, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(16, 5, 5, 0), 0, 0));
    }

    private void setRevisionField(SVNRevision svnRevision) {
        this._revField.setText(svnRevision.toString());
    }

    private SVNUrl getReposUrl() {
        return this._reposUrl;
    }

    private void initListeners() {
        this._revCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e != null && e.getSource() == ExportFromReposPanel.this._revCheckBox) {
                    ExportFromReposPanel.this._revField.setEnabled(ExportFromReposPanel.this._revCheckBox.isSelected());
                }
            }
        });
        this._browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e != null && e.getSource() == ExportFromReposPanel.this._browseButton) {
                    URL current = null;
                    String currentStr = ExportFromReposPanel.this._fileField.getText();
                    current = currentStr != null && currentStr.length() > 0 ? URLFactory.newDirURL((String)currentStr) : URLFactory.newDirURL((String)Ide.getWorkDirectory());
                    URLChooser chooser = DialogUtil.newURLChooser((URL)current);
                    chooser.setSelectionMode(0);
                    chooser.setSelectionScope(1);
                    if (chooser.showOpenDialog((Component)ExportFromReposPanel.this) == 0) {
                        ExportFromReposPanel.this._fileField.setText(URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL()));
                    }
                }
            }
        });
        this._fileField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.firePathSelected();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.firePathSelected();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.firePathSelected();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void firePathSelected() {
                String path = ExportFromReposPanel.this._fileField.getText();
                Collection collection = ExportFromReposPanel.this._listeners;
                synchronized (collection) {
                    Iterator it = ExportFromReposPanel.this._listeners.iterator();
                    while (it.hasNext()) {
                        ((ExportPathListener)it.next()).exportPathSelected(path);
                    }
                }
            }
        });
        this._revButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SVNRevisionLister revLister = new SVNRevisionLister(ExportFromReposPanel.this.getReposUrl(), ExportFromReposPanel.this._revisionStart, ExportFromReposPanel.this._revisionEnd);
                revLister.addObserver(new Observer(){

                    @Override
                    public void update(Observable o, Object arg) {
                        ExportFromReposPanel.this.setRevisionField((SVNRevision)arg);
                        ExportFromReposPanel.this._revCheckBox.setSelected(true);
                        ExportFromReposPanel.this._revField.setEnabled(true);
                    }
                });
                revLister.showLister();
            }
        });
    }
}

