/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteContainer;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.NewRemoteDirPanel;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNOperationNewRemoteDir
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.new-remote-directory";
    public static final String DIR_NAME_PROP_KEY = SVNOperationNewRemoteDir.class.getName() + ".dirName";
    private SVNRepositoryInfo _repos;
    private SVNUrl _parent;
    private boolean _useProgress = true;
    private String newDirName = null;
    private Component _parentComponent;

    public SVNOperationNewRemoteDir() {
        super(COMMAND_ID);
    }

    public SVNOperationNewRemoteDir(SVNRepositoryInfo repos, SVNUrl parent, boolean useProgressBar) {
        this();
        this._repos = repos;
        this._parent = parent;
        this._useProgress = useProgressBar;
    }

    public SVNOperationNewRemoteDir(SVNRepositoryInfo repos, SVNUrl parentURL, Component parentComponent, boolean useProgressBar) {
        this();
        this._repos = repos;
        this._parent = parentURL;
        this._useProgress = useProgressBar;
        this._parentComponent = parentComponent;
    }

    protected boolean isAvailableImpl(VCSProfile profile) throws Exception {
        if (this._repos != null && this._parent != null) {
            return true;
        }
        SVNRemoteNode node = SVNUtil.getSVNRemoteNode(this.getContext());
        return node != null && node instanceof SVNRemoteContainer;
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        SVNRemoteContainer aNode = null;
        if (this._repos == null || this._parent == null) {
            SVNRemoteNode node = SVNUtil.getSVNRemoteNode(this.getContext());
            if (node == null || !(node instanceof SVNRemoteContainer)) {
                return 1;
            }
            this._repos = (SVNRepositoryInfo)node.getParentRepository().getData();
            this._parent = node.getSVNUrl();
            aNode = (SVNRemoteContainer)node;
        }
        final NewRemoteDirPanel panel = new NewRemoteDirPanel(this._parent);
        final JEWTDialog dialog = this.createDialog(panel);
        SVNRemoteContainer toReload = aNode;
        panel.addDirectoryNameListener(new NewRemoteDirPanel.Listener(){

            @Override
            public void directoryNameChanged(String newName) {
                dialog.setOKButtonEnabled(newName != null && newName.length() > 0);
            }
        });
        dialog.addVetoableChangeListener(new VetoableChangeListener(){
            final /* synthetic */ Node val$toReload;
            {
                this.val$toReload = node;
            }

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                    return;
                }
                dialog.setOKButtonEnabled(false);
                new Thread((Runnable)new NewRemoteDirTask(dialog, panel, SVNOperationNewRemoteDir.this._repos, SVNOperationNewRemoteDir.this._parent, SVNOperationNewRemoteDir.this._useProgress, this.val$toReload), "svn-createremotedir-thread").start();
                throw new PropertyVetoException("", pce);
            }
        });
        boolean success = WizardLauncher.runDialog((JDialog)dialog);
        this.getContext().setProperty(DIR_NAME_PROP_KEY, (Object)(success ? panel.getDirectoryName() : null));
        return success ? 0 : 1;
    }

    private JEWTDialog createDialog(NewRemoteDirPanel panel) {
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)(this._parentComponent == null ? VCSWindowUtils.getCurrentWindow() : this._parentComponent), (Component)panel, (Component)panel.getInitialFocus(), (String)Resource.get("UI_CREATE_REMOTE_DIR_DIALOG_TITLE"), (int)7);
        dialog.setResizable(true);
        dialog.setOKButtonEnabled(false);
        dialog.setDefaultButton(1);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_svncreateremotedirectory_html");
        dialog.setName("CreateDirDialog");
        return dialog;
    }

    private final class NewRemoteDirTask
    implements Runnable {
        private final JEWTDialog _dialog;
        private final NewRemoteDirPanel _panel;
        private final SVNRepositoryInfo _repos;
        private final SVNUrl _parent;
        private final boolean _useProgress;
        private final Node _toReload;

        private NewRemoteDirTask(JEWTDialog dialog, NewRemoteDirPanel panel, SVNRepositoryInfo repos, SVNUrl parent, boolean useProgressBar, Node toReload) {
            this._dialog = dialog;
            this._panel = panel;
            this._repos = repos;
            this._parent = parent;
            this._useProgress = useProgressBar;
            this._toReload = toReload;
        }

        @Override
        public void run() {
            final WaitCursor wc = new WaitCursor((Component)this._panel);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    wc.show();
                }
            });
            try {
                if (this._useProgress) {
                    SVNOperationNewRemoteDir.this.newDirName = this._panel.getDirectoryName();
                    this.executeMkdirWithProgress(this._parent, this._panel.getDirectoryName(), this._panel.getComments());
                } else {
                    SVNOperationNewRemoteDir.this.newDirName = this._panel.getDirectoryName();
                    this.executeMkdir(this._parent, this._panel.getDirectoryName(), this._panel.getComments());
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewRemoteDirTask.this._dialog.setVisible(false);
                        NewRemoteDirTask.this._dialog.dispose();
                    }
                });
            }
            catch (Exception e) {
                try {
                    SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
                    ExceptionDialog.showExceptionDialog((Component)this._dialog, (Throwable)e, (String)Resource.get("ACTION_CREATE_REMOTE_DIR_ERROR_TITLE"), (String)Resource.format("ACTION_CREATE_REMOTE_DIR_ERROR_MESSAGE", this._parent.toString(), this._panel.getDirectoryName()), null);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NewRemoteDirTask.this._dialog.setOKButtonEnabled(true);
                        }
                    });
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new Runnable(){
                        final /* synthetic */ WaitCursor val$wc;
                        {
                            this.val$wc = waitCursor;
                        }

                        @Override
                        public void run() {
                            this.val$wc.hide();
                            NewRemoteDirTask.this.updateVersionNavigator();
                        }
                    });
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        private void updateVersionNavigator() {
            Context context = SVNOperationNewRemoteDir.this.getContext();
            View view = context.getView();
            if (this._toReload != null && view instanceof NavigatorWindow) {
                RevertNodeCommand.reload((Node)this._toReload, (boolean)false);
                TreeExplorer explorer = ((NavigatorWindow)view).getTreeExplorer();
                TNode tnode = explorer.searchTNodeBreadthFirst((Element)this._toReload, explorer.getRoot());
                if (tnode != null) {
                    explorer.expand(tnode, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeMkdirWithProgress(SVNUrl parentPath, String newDir, String comments) throws SVNClientException {
            IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)this._dialog, Resource.get("ACTION_CREATE_REMOTE_DIR_PROGRESS_TITLE"), (Object)Resource.get("ACTION_CREATE_REMOTE_DIR_PROGRESS_MESSAGE"), null);
            progress.setMillisToPopup(500);
            progress.setCloseOnFinish(true);
            progress.setCancellable(false);
            progress.start();
            try {
                ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
                SVNOperationLogger.getInstance().beginOperation(client, this._repos, progress);
                client.mkdir(parentPath.appendPath(newDir), comments);
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
                progress.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeMkdir(SVNUrl parentPath, String newDir, String comments) throws SVNClientException {
            try {
                ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
                SVNOperationLogger.getInstance().beginOperation(client, this._repos);
                client.mkdir(parentPath.appendPath(newDir), comments);
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
            }
        }
    }
}

