/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.adapter.javahl;

import java.io.File;
import oracle.jdevimpl.vcs.svn.adapter.OISVNClientAdapter;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.RevisionRange;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;
import org.tigris.subversion.svnclientadapter.javahl.JhlPropertyData;

public class OJhlClientAdapter
extends JhlClientAdapter
implements OISVNClientAdapter {
    @Override
    public ISVNProperty[] getProperties(SVNUrl url, SVNRevision revision) throws SVNClientException {
        String target = url.toString();
        return this.getProperties(target, revision);
    }

    @Override
    public ISVNProperty[] getProperties(File file, SVNRevision revision) throws SVNClientException {
        String target = file.toString();
        return this.getProperties(target, revision);
    }

    public ISVNProperty[] getProperties(String target, SVNRevision revision) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            this.notificationHandler.logCommandLine("proplist " + target);
            this.notificationHandler.setBaseDir();
            PropertyData[] propertiesData = this.svnClient.properties(target, JhlConverter.convert((SVNRevision)revision));
            if (propertiesData == null) {
                return new JhlPropertyData[0];
            }
            JhlPropertyData[] svnProperties = new JhlPropertyData[propertiesData.length];
            for (int i = 0; i < propertiesData.length; ++i) {
                svnProperties[i] = JhlPropertyData.newForUrl((PropertyData)propertiesData[i]);
            }
            return svnProperties;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException((Throwable)e);
        }
    }

    public void merge(SVNUrl url, SVNRevision pegRevision, SVNRevisionRange[] revisions, File localPath, boolean force, int depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(27);
            String target = OJhlClientAdapter.fileToSVNPath((File)localPath, (boolean)false);
            Object commandLine = "merge";
            if (dryRun) {
                commandLine = (String)commandLine + " --dry-run";
            }
            commandLine = (String)commandLine + this.depthCommandLine(depth);
            if (force) {
                commandLine = (String)commandLine + " --force";
            }
            if (ignoreAncestry) {
                commandLine = (String)commandLine + " --ignore-ancestry";
            }
            RevisionRange[] range = JhlConverter.convert((SVNRevisionRange[])revisions);
            for (int i = 0; i < revisions.length; ++i) {
                commandLine = (String)commandLine + " " + this.toMergeString(revisions[i]);
            }
            commandLine = (String)commandLine + " " + url.toString();
            commandLine = (String)commandLine + " " + target;
            this.notificationHandler.logCommandLine((String)commandLine);
            File baseDir = SVNBaseDir.getBaseDir((File)localPath);
            this.notificationHandler.setBaseDir(baseDir);
            Revision peg = JhlConverter.convert((SVNRevision)pegRevision);
            if (peg == null) {
                peg = Revision.HEAD;
            }
            this.svnClient.merge(url.toString(), peg, range, target, force, depth, ignoreAncestry, dryRun, recordOnly);
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge complete.");
            } else {
                this.notificationHandler.logCompleted("Merge complete.");
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge completed abnormally.");
            } else {
                this.notificationHandler.logCompleted("Merge completed abnormally.");
            }
            SVNClientException svnClientException = new SVNClientException((Throwable)e);
            svnClientException.setAprError(e.getAprError());
            throw svnClientException;
        }
    }

    private String depthCommandLine(int depth) {
        switch (depth) {
            case 0: {
                return " --depth=empty";
            }
            case 1: {
                return " --depth=files";
            }
            case 2: {
                return " --depth=immediates";
            }
            case 3: {
                return " --depth=infinity";
            }
        }
        return "";
    }

    private String toMergeString(SVNRevisionRange svnRevisionRange) {
        long toRev;
        SVNRevision from = svnRevisionRange.getFromRevision();
        SVNRevision to = svnRevisionRange.getToRevision();
        long fromRev = SVNRevisionRange.getRevisionAsLong((SVNRevision)from);
        if (fromRev + 1L == (toRev = SVNRevisionRange.getRevisionAsLong((SVNRevision)to).longValue())) {
            return "-c " + toRev;
        }
        return "-r " + from.toString() + ":" + to.toString();
    }

    public void mergeReintegrate(SVNUrl path, SVNRevision pegRevision, File localPath, boolean force, boolean dryRun) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(27);
            String target = OJhlClientAdapter.fileToSVNPath((File)localPath, (boolean)false);
            Object commandLine = "merge --reintegrate";
            if (dryRun) {
                commandLine = (String)commandLine + " --dry-run";
            }
            if (force) {
                commandLine = (String)commandLine + " --force";
            }
            commandLine = (String)commandLine + " " + path + " " + target;
            this.notificationHandler.logCommandLine((String)commandLine);
            File baseDir = SVNBaseDir.getBaseDir((File)localPath);
            this.notificationHandler.setBaseDir(baseDir);
            Revision peg = JhlConverter.convert((SVNRevision)pegRevision);
            if (peg == null) {
                peg = Revision.HEAD;
            }
            this.svnClient.mergeReintegrate(path.toString(), peg, target, dryRun);
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge complete.");
            } else {
                this.notificationHandler.logCompleted("Merge complete.");
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge completed abnormally.");
            } else {
                this.notificationHandler.logCompleted("Merge completed abnormally.");
            }
            SVNClientException svnClientException = new SVNClientException((Throwable)e);
            svnClientException.setAprError(e.getAprError());
            throw svnClientException;
        }
    }
}

