/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.syntax.BaseSyntax;
import oracle.olap.syntax.CubePrecomputeDimension;
import oracle.olapi.syntax.BinaryOperatorCondition;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.SymmetricCondition;
import oracle.olapi.syntax.SymmetricConditionElement;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.ValueComparisonCondition;

public class PrecomputeConditionSyntax
extends BaseSyntax {
    public static final String CUBE_PRECOMPUTE_DIMENSIONS_KEY = "CUBE_PRECOMPUTE_DIMENSIONS_KEY";
    private static PrecomputeConditionSyntax precomputeSyntaxInstance;

    private PrecomputeConditionSyntax() {
    }

    public static PrecomputeConditionSyntax getInstance() {
        if (precomputeSyntaxInstance == null) {
            precomputeSyntaxInstance = new PrecomputeConditionSyntax();
        }
        return precomputeSyntaxInstance;
    }

    private void getLevelsFromBinaryCondition(BinaryOperatorCondition binaryOperatorCondition, List<String> list) {
        if (binaryOperatorCondition.getOperator().equalsIgnoreCase("OR")) {
            Condition[] conditionArray;
            for (Condition condition : conditionArray = binaryOperatorCondition.getArguments()) {
                ValueComparisonCondition valueComparisonCondition;
                if (condition instanceof ValueComparisonCondition) {
                    valueComparisonCondition = (ValueComparisonCondition)condition;
                    list.add(valueComparisonCondition.getRhsArgument().toSyntax());
                    continue;
                }
                if (!(condition instanceof BinaryOperatorCondition)) continue;
                valueComparisonCondition = (BinaryOperatorCondition)condition;
                this.getLevelsFromBinaryCondition((BinaryOperatorCondition)valueComparisonCondition, list);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> fromSyntax(Cube cube, Map<String, CubeDimension> map, String string) {
        SymmetricCondition symmetricCondition;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string != null && string.length() > 0 && (symmetricCondition = (SymmetricCondition)SyntaxObject.fromSyntax((String)string, null)) != null) {
            SymmetricConditionElement[] symmetricConditionElementArray = symmetricCondition.getElements();
            for (int i = 0; i < symmetricConditionElementArray.length; ++i) {
                CubeDimensionality[] cubeDimensionalityArray;
                String string2 = symmetricConditionElementArray[i].getDimensionID();
                for (CubeDimensionality cubeDimensionality : cubeDimensionalityArray = cube.getDimensions()) {
                    Object object2;
                    BinaryOperatorCondition binaryOperatorCondition;
                    CubeDimension cubeDimension = map.get(cubeDimensionality.getName());
                    String string3 = cubeDimension.getName();
                    if (!string3.equalsIgnoreCase(string2)) continue;
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    String[] stringArray = symmetricConditionElementArray[i].getLevelIDs();
                    String string4 = symmetricConditionElementArray[i].getQualifier();
                    Condition condition = symmetricConditionElementArray[i].getCondition();
                    if (string4 != null && string4.equalsIgnoreCase("ALL")) {
                        void var24_30;
                        binaryOperatorCondition = cubeDimension.getLevels();
                        object2 = binaryOperatorCondition;
                        int n = ((Object[])object2).length;
                        boolean bl = false;
                        while (var24_30 < n) {
                            object = object2[var24_30];
                            arrayList2.add(object.getName());
                            ++var24_30;
                        }
                    } else if (condition != null) {
                        binaryOperatorCondition = new ArrayList();
                        if (condition instanceof BinaryOperatorCondition) {
                            object2 = (BinaryOperatorCondition)condition;
                            this.getLevelsFromBinaryCondition((BinaryOperatorCondition)object2, (List<String>)binaryOperatorCondition);
                            for (String string5 : binaryOperatorCondition) {
                                arrayList2.add(string5.replaceAll("'", ""));
                            }
                        }
                    } else if (stringArray != null) {
                        for (BinaryOperatorCondition binaryOperatorCondition2 : stringArray) {
                            object = binaryOperatorCondition2.substring(binaryOperatorCondition2.indexOf(".") + 1);
                            arrayList2.add((String)object);
                        }
                    }
                    binaryOperatorCondition = cubeDimension.getLevels();
                    object2 = new CubePrecomputeDimension(cube, string3);
                    ArrayList arrayList3 = new ArrayList();
                    for (Object object : arrayList2) {
                        for (BinaryOperatorCondition binaryOperatorCondition3 : binaryOperatorCondition) {
                            String string6 = binaryOperatorCondition3.getName();
                            if (!string6.equalsIgnoreCase((String)object)) continue;
                            arrayList3.add(binaryOperatorCondition3);
                        }
                    }
                    if (arrayList3.size() <= 0) continue;
                    ((CubePrecomputeDimension)object2).setPrecomputeLevels(arrayList3);
                    arrayList.add(object2);
                }
            }
        }
        hashMap.put(CUBE_PRECOMPUTE_DIMENSIONS_KEY, arrayList);
        return hashMap;
    }

    public String toSyntax(Cube cube, Map<String, CubeDimension> map, Map<String, Object> map2) {
        StringBuffer stringBuffer = new StringBuffer();
        List list = (List)map2.get(CUBE_PRECOMPUTE_DIMENSIONS_KEY);
        for (CubePrecomputeDimension cubePrecomputeDimension : list) {
            String string = cubePrecomputeDimension.getName();
            CubeDimensionality cubeDimensionality = cube.findDimensionality(string);
            CubeDimension cubeDimension = map.get(cubeDimensionality.getName());
            if (cubeDimensionality == null) continue;
            List<CubeDimensionLevel> list2 = cubePrecomputeDimension.getPrecomputeLevels();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CubeDimensionLevel cubeDimensionLevel : list2) {
                arrayList.add(cubeDimensionLevel.getName());
            }
            String string2 = this.getLevelConditionSyntax(cubeDimension, arrayList);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

