/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.editor;

import java.io.File;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.runner.ParamTableModel;
import oracle.dbtools.raptor.runner.debug.RaptorDebuggingHelper;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.ide.Context;
import oracle.ide.log.LogPage;
import oracle.ide.log.StyledMessage;
import oracle.ide.model.DefaultDisplayable;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Starter;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.jdbc.OracleConnection;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.runner.DatabaseRunHelper;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

public class OLAPStarterFactory
extends AbstractStarterFactory
implements JStarterFactory {
    private static final Map<String, Integer> s_activeConns = new HashMap<String, Integer>();
    Context context;

    public static synchronized boolean isDebugSessionActive(String string) {
        return OLAPStarterFactory.getCount(string) > 0;
    }

    private static synchronized Integer getCount(String string) {
        Integer n = s_activeConns.get(string);
        return n != null ? n : 0;
    }

    private static synchronized void putCount(String string, Integer n) {
        if (n > 0) {
            s_activeConns.put(string, n);
        } else {
            s_activeConns.remove(string);
        }
    }

    private static synchronized void incrementDebugSessionCount(String string) {
        OLAPStarterFactory.putCount(string, OLAPStarterFactory.getCount(string) + 1);
    }

    private static synchronized void decrementDebugSessionCount(String string) {
        OLAPStarterFactory.putCount(string, OLAPStarterFactory.getCount(string) - 1);
    }

    public OLAPStarterFactory() {
        Connections.getInstance().addConnectionDisconnectListener(new ConnectionDisconnectListener(){

            public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
                if (OLAPStarterFactory.getCount(connectionDetails.getQualifiedConnectionName()) > 0) {
                    throw new DisconnectVetoException(connectionDetails, "Debug session in progress");
                }
            }

            public void connectionDisconnected(ConnectionDetails connectionDetails) {
            }
        });
    }

    public String getName() {
        return null;
    }

    public Object canStart(RunProcess runProcess, Node node, List list) {
        Object object;
        if (runProcess instanceof JRunProcess && node instanceof RunnableSourceNode && (object = OLAPStarterFactory.findBaseTarget(node, list)) != null) {
            try {
                Connection connection = OLAPStarterFactory.getConnection(node);
                if (runProcess.canRun("Database", (Object)connection, node, list)) {
                    return object;
                }
            }
            catch (DBException dBException) {
                list.add(dBException.getLocalizedMessage());
            }
        }
        return null;
    }

    public Starter createStarter(RunProcess runProcess, Node node, Object object) {
        RunnableSourceNode runnableSourceNode = (RunnableSourceNode)object;
        return new OLAPStarter((JRunProcess)runProcess, runnableSourceNode);
    }

    public boolean enableRunDebugActions(Context context) {
        Node node = RunProcess.getContextNodeForRun((Context)context);
        return node instanceof RunnableSourceNode && Boolean.parseBoolean((String)((RunnableSourceNode)node).getProperty("RUNNABLE"));
    }

    public Displayable getDisplayable(RunProcess runProcess, Context context, Node node, Object object) {
        return new DefaultDisplayable(){

            public String getShortLabel() {
                return RunMgrArb.getString((int)84);
            }

            public String getLongLabel() {
                return RunMgrArb.getString((int)84);
            }

            public Icon getIcon() {
                return RaptorImagesArb.getIcon((String)"PROCEDURE");
            }
        };
    }

    private static Object findBaseTarget(Node node, List list) {
        URL uRL = node.getURL();
        if (DBURLFormatHelper.isDBURL((URL)uRL)) {
            if (node instanceof RunnableSourceNode) {
                RunnableSourceNode runnableSourceNode = ((RunnableSourceNode)node).getRunTarget();
                if (runnableSourceNode != null) {
                    return runnableSourceNode;
                }
                list.add("Source does not have a runnable target.");
            } else {
                list.add("Not a runnable DB source");
            }
        } else {
            String string = RunMgrArb.format((int)85, (Object)node.getShortLabel());
            list.add(string);
        }
        return null;
    }

    private static Connection getConnection(Node node) throws DBException {
        URL uRL = node.getURL();
        String string = DBURLFormatHelper.getConnectionName((URL)uRL);
        return Connections.getInstance().getConnection(string, true);
    }

    public static void bindParameters(String string, Statement statement, ParamTableModel paramTableModel) throws SQLException {
        boolean bl = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        Class.forName("oracle.jdbc.OracleDriver");
        Connection connection = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521:xe", "hr", "hr");
        final PreparedStatement preparedStatement = connection.prepareStatement("begin SLEEP_PROC; end;");
        final long l = System.currentTimeMillis();
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    preparedStatement.cancel();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("interrupted");
                }
                catch (SQLException sQLException) {
                    System.out.println("Exception" + sQLException.getMessage());
                }
                System.out.println("Cancelled after " + (System.currentTimeMillis() - l));
            }
        }.start();
        try {
            preparedStatement.execute();
        }
        finally {
            System.out.println("Finished after " + (System.currentTimeMillis() - l));
        }
    }

    public static class OLAPStarter
    extends JStarter {
        public static TextBuffer dialogOutput = null;
        public static ParamTableModel paramTableModel;
        private String sql;
        private Connection executionConnection;
        private String connName;
        private boolean connectHappened;
        private QueryWrapper m_queryWrapper;
        private Statement stmt = null;

        OLAPStarter(JRunProcess jRunProcess, RunnableSourceNode runnableSourceNode) {
            super(jRunProcess, null);
            this.jrunProcess = jRunProcess;
            URL uRL = runnableSourceNode.getURL();
            this.connName = DBURLFormatHelper.getConnectionName((URL)uRL);
        }

        public OLAPStarter(JRunProcess jRunProcess, String string, String string2, Context context) {
            super(jRunProcess, null);
            this.jrunProcess = jRunProcess;
            this.sql = string;
            this.connName = string2;
        }

        private Connection getConnection() {
            if (this.executionConnection == null && !this.connectHappened && this.connName != null) {
                try {
                    LogPage logPage = this.jrunProcess.getLogPage();
                    logPage.log((Object)RunMgrArb.format((int)88, (Object)Connections.getDisplayName((String)this.connName)));
                    this.executionConnection = Connections.getInstance().getUniqueConnection(this.connName);
                    OLAPStarterFactory.incrementDebugSessionCount(this.connName);
                    this.connectHappened = true;
                    this.m_queryWrapper = this.executionConnection instanceof OracleConnection ? new OracleQueryWrapper() : new TimesTenQueryWrapper();
                }
                catch (Exception exception) {
                    this.logError(exception);
                }
            }
            return this.executionConnection;
        }

        private void disconnect() {
            if (this.executionConnection != null) {
                this.jrunProcess.getLogPage().log((Object)RunMgrArb.format((int)89, (Object)Connections.getDisplayName((String)this.connName)));
                try {
                    this.executionConnection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                OLAPStarterFactory.decrementDebugSessionCount(this.connName);
            }
        }

        public File getStartDirectory() {
            return null;
        }

        public String[] getStartCommand() {
            return null;
        }

        public boolean canStart(List list) {
            return true;
        }

        public boolean start() {
            final DatabaseRunHelper databaseRunHelper = (DatabaseRunHelper)this.jrunProcess.getValue("Database", null, "DatabaseRunHelper");
            if (this.getConnection() == null) {
                this.disconnect();
                return false;
            }
            if (dialogOutput != null) {
                this.sql = dialogOutput.getString(0, dialogOutput.getLength());
            }
            if (this.sql == null) {
                this.disconnect();
                return false;
            }
            final boolean bl = this.jrunProcess instanceof DebuggingProcess;
            this.jrunProcess.setLabelOverride(Connections.getDisplayName((String)this.connName));
            final String[][] stringArray = databaseRunHelper != null ? databaseRunHelper.getDatabaseCommands((Object)new RaptorDebuggingHelper.DebugConnection(this.connName, this.executionConnection)) : null;
            Thread thread = new Thread("OLAP DML Starter Thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block8: {
                        try {
                            int n;
                            int n2;
                            int n3;
                            this.enableDbmsOutput();
                            boolean bl2 = false;
                            if (stringArray != null && stringArray.length >= 1 && stringArray[0] != null) {
                                n3 = stringArray[0].length;
                                for (n2 = 0; n2 < n3; ++n2) {
                                    n = this.executeSQL(stringArray[0][n2], true);
                                    if (n == 0) continue;
                                    if (databaseRunHelper != null) {
                                        databaseRunHelper.handleDatabaseError(stringArray, 0, n2, n);
                                    }
                                    bl2 = true;
                                    break;
                                }
                            }
                            if (bl2 || databaseRunHelper != null && !databaseRunHelper.waitForDatabase()) break block8;
                            n3 = this.executePlSqlNode();
                            int n4 = n2 = Connections.getInstance().isOracle(executionConnection) && (n3 == 6543 || n3 == 30687) ? 1 : 0;
                            if (stringArray != null && stringArray.length >= 2 && stringArray[1] != null) {
                                n = stringArray[1].length;
                                for (int i = 0; i < n; ++i) {
                                    int n5 = this.executeSQL(stringArray[1][i], true);
                                    if (n5 == 0 || databaseRunHelper == null) continue;
                                    databaseRunHelper.handleDatabaseError(stringArray, 1, i, n5);
                                }
                            }
                            if (n2 != 0) break block8;
                            this.logDbmsOutput();
                            if (!bl) {
                                this.exibitStructuredPanel();
                            }
                        }
                        catch (Throwable throwable) {
                            SwingUtilities.invokeLater(new Runnable(this){
                                final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                @Override
                                public void run() {
                                    jrunProcess.finished();
                                    this.this$1.this.finished();
                                }
                            });
                            throw throwable;
                        }
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            };
            thread.start();
            return true;
        }

        private void logMsg(String string) {
            this.logMsg(string, null);
        }

        private void logMsg(String string, AttributeSet attributeSet) {
            if (string != null) {
                String string2 = this.checkLineTerminator(string);
                if (attributeSet != null) {
                    this.jrunProcess.log((Object)new StyledMessage(attributeSet, string2));
                } else {
                    this.jrunProcess.log((Object)string2);
                }
            }
        }

        private String checkLineTerminator(String string) {
            return !string.endsWith("\n") ? string + "\n" : string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executeSQL(String string, boolean bl) {
            int n = 0;
            if (bl) {
                boolean bl2 = true;
                StringBuffer stringBuffer = new StringBuffer(RunMgrArb.getString((int)90));
                String string2 = stringBuffer.toString();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    this.logMsg(string2 + string3 + "\n");
                    if (!bl2) continue;
                    for (int i = stringBuffer.length() - 1; i >= 0; --i) {
                        stringBuffer.setCharAt(i, ' ');
                    }
                    string2 = stringBuffer.toString();
                    bl2 = false;
                }
            }
            Statement statement = null;
            try {
                statement = this.executionConnection.createStatement();
                statement.execute(string);
            }
            catch (SQLException sQLException) {
                n = this.handleError(sQLException, bl);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                    statement = null;
                }
            }
            return n;
        }

        private void logError(Exception exception) {
            Throwable throwable;
            Exception exception2 = exception;
            while ((exception2 instanceof ConnectionException || exception2 instanceof DBException) && (throwable = exception2.getCause()) instanceof Exception) {
                exception2 = (Exception)throwable;
            }
            this.logMsg(exception2.getMessage(), RunProcess.getSystemErrAttributeSet());
        }

        private int handleError(SQLException sQLException, boolean bl) {
            int n = sQLException.getErrorCode();
            String string = sQLException.getMessage();
            if (bl) {
                this.logMsg(string, RunProcess.getSystemErrAttributeSet());
            }
            return n;
        }

        private int executePlSqlNode() {
            int n = 0;
            if (this.sql != null) {
                try {
                    this.stmt = this.executionConnection.prepareCall(this.sql);
                    if (this.stmt instanceof CallableStatement && this.stmt instanceof PreparedStatement && paramTableModel != null) {
                        OLAPStarterFactory.bindParameters(this.sql, this.stmt, paramTableModel);
                        ((PreparedStatement)this.stmt).execute();
                    } else {
                        this.stmt.execute(this.sql);
                    }
                }
                catch (SQLException sQLException) {
                    n = this.handleError(sQLException, true);
                }
            }
            return n;
        }

        private String getSQL(String string) {
            return this.m_queryWrapper.getQuery(string).getSql();
        }

        private void enableDbmsOutput() {
            this.executeSQL(this.getSQL("DisableOutput"), false);
            this.executeSQL(this.getSQL("EnableOutput"), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logDbmsOutput() {
            while (true) {
                Statement statement = null;
                try {
                    if (this.executionConnection.isClosed()) {
                        return;
                    }
                    String string = this.getSQL("GetLine");
                    statement = this.executionConnection.prepareCall(string);
                    statement.registerOutParameter(1, 12);
                    statement.registerOutParameter(2, 4);
                    statement.execute();
                    String string2 = statement.getString(1);
                    int n = statement.getInt(2);
                    this.logMsg(string2, RunProcess.getSystemOutAttributeSet());
                    if (n <= 0) continue;
                }
                catch (SQLException sQLException) {
                    this.handleError(sQLException, true);
                    continue;
                }
                finally {
                    if (statement == null) continue;
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (Exception exception) {}
                    continue;
                }
                return;
                break;
            }
        }

        public boolean canTerminate() {
            return true;
        }

        public void terminate() {
            paramTableModel = null;
            try {
                this.stmt.cancel();
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException.getMessage());
            }
        }

        public void finished() {
            this.disconnect();
            super.finished();
        }

        private void exibitStructuredPanel() {
            if (!(this.stmt instanceof CallableStatement)) {
                return;
            }
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private class OracleQueryWrapper
        extends QueryWrapper {
            OracleQueryWrapper() {
                super("/oracle/dbtools/raptor/runner/source.xml");
            }
        }

        private class TimesTenQueryWrapper
        extends QueryWrapper {
            TimesTenQueryWrapper() {
                super("/oracle/dbtools/raptor/runner/x10source.xml");
            }
        }

        private abstract class QueryWrapper {
            private QueryXMLSupport m_xml;
            private Map<String, Query> m_queries = new HashMap<String, Query>();

            QueryWrapper(String string) {
                this.m_xml = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(this.getClass().getClassLoader(), string));
            }

            public Query getQuery(String string) {
                Query query = this.m_queries.get(string);
                if (query == null) {
                    query = this.m_xml.getQuery(string, OLAPStarter.this.executionConnection);
                    this.m_queries.put(string, query);
                }
                return query;
            }
        }
    }
}

