/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubeviewer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.olap.OLAPArb;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.table.TableCheckBoxCellEditor;
import oracle.olap.app.table.TableCheckBoxCellRenderer;
import oracle.olap.data.CubeMetadataContext;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;

public class CubeMeasureSelectionPanel
extends JPanel
implements TableModelListener {
    private DefaultTableModel measureTableModel;
    private JTable measureTable;
    private SearchField measureFilterFld;
    CheckBoxHeader checkBoxHeader;
    private CubeMetadataContext cubeMetadataContext;
    private List<PropertyChangeListener> listeners;
    private int totalRows = 0;
    private int selectedRows = 0;
    private static final int COL_SELECT = 0;
    private static final int COL_MEASURE_NAME = 1;
    private static final int COL_DESC = 2;
    private static final int COL_EXPRESSION = 3;

    public CubeMeasureSelectionPanel(CubeMetadataContext cubeMetadataContext) throws SQLException, IOException {
        this.cubeMetadataContext = cubeMetadataContext;
        this.measureTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 <= 1;
            }
        };
        this.measureTableModel.addTableModelListener(this);
        this.listeners = new ArrayList<PropertyChangeListener>();
        this.layoutComponents();
        this.initTable();
        this.loadMeasureTable();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    private void initTable() {
        this.measureTableModel.setRowCount(0);
        this.measureTableModel.setColumnCount(0);
        this.measureTableModel.addColumn(OLAPArb.get("MEASURE_SELECT_COLUMN"));
        this.measureTableModel.addColumn(OLAPArb.get("MEASURE_MEASURE_NAME_COLUMN"));
        this.measureTableModel.addColumn(OLAPArb.get("MEASURE_DESCRIPTION_COLUMN"));
        this.measureTableModel.addColumn(OLAPArb.get("MEASURE_EXPRESSION_COLUMN"));
        TableColumn tableColumn = this.measureTable.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(new TableCheckBoxCellEditor());
        tableColumn.setCellRenderer(new TableCheckBoxCellRenderer());
        this.checkBoxHeader = new CheckBoxHeader();
        tableColumn.setHeaderRenderer(this.checkBoxHeader);
        tableColumn.setPreferredWidth(70);
        tableColumn = this.measureTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(400);
    }

    private void loadMeasureTable() {
        String string = "";
        if (this.measureFilterFld.getText() != null) {
            string = this.measureFilterFld.getText();
        }
        this.measureTableModel.setRowCount(0);
        this.totalRows = 0;
        this.selectedRows = 0;
        Cube cube = this.cubeMetadataContext.getCube();
        for (Measure measure : cube.getMeasures()) {
            boolean bl;
            String string2 = measure.getName();
            if (string.length() > 0 && !(bl = string2.contains(string.toUpperCase()))) continue;
            Boolean bl2 = measure.isSelected();
            this.measureTableModel.addRow(new Object[]{bl2, measure.getName(), measure.getDescription(), measure.getExpression()});
            ++this.totalRows;
            if (!bl2.booleanValue()) continue;
            ++this.selectedRows;
        }
        this.updateSelectAll();
    }

    public int getSelectedMeasuresCount() {
        return this.selectedRows;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getColumn();
        if (n == -1) {
            return;
        }
        if (tableModelEvent.getSource() == this.measureTableModel && tableModelEvent.getType() == 0) {
            this.updateMeasureTableModelFromCell(n, n2);
        }
    }

    private void updateMeasureTableModelFromCell(int n, int n2) {
        if (n2 != 0) {
            return;
        }
        String string = (String)this.measureTable.getValueAt(n, 1);
        Object object = this.measureTable.getValueAt(n, n2);
        Boolean bl = (Boolean)object;
        Cube cube = this.cubeMetadataContext.getCube();
        for (Measure object2 : cube.getMeasures()) {
            if (!object2.getName().equals(string)) continue;
            object2.setSelected(bl);
            if (bl.booleanValue() && this.selectedRows < this.totalRows) {
                ++this.selectedRows;
                break;
            }
            if (bl.booleanValue() || this.selectedRows <= 0) break;
            --this.selectedRows;
            break;
        }
        this.updateSelectAll();
        for (PropertyChangeListener propertyChangeListener : this.listeners) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.measureTable, string, bl == false, bl);
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    private void layoutComponents() {
        JLabel jLabel = new JLabel(OLAPArb.get("CUBE_QUERY_TOP_LABEL"));
        jLabel.setName("topLabel");
        this.measureTable = new JTable(this.measureTableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (n2 == 3 && component instanceof JComponent) {
                    Object object = CubeMeasureSelectionPanel.this.measureTableModel.getValueAt(n, n2);
                    JComponent jComponent = (JComponent)component;
                    if (object != null) {
                        String string = object.toString();
                        Properties properties = new Properties();
                        properties.put("HTML", Boolean.TRUE);
                        OLAPISyntaxParser oLAPISyntaxParser = new OLAPISyntaxParser(null, properties);
                        String string2 = oLAPISyntaxParser.formatSyntax(string);
                        jComponent.setToolTipText(string2);
                    }
                }
                return component;
            }
        };
        this.measureTable.setName("measureTable");
        this.measureTable.setAutoResizeMode(0);
        JLabel jLabel2 = new JLabel(OLAPArb.get("MEASURE_FILTER"));
        jLabel2.setName("measureFilterLabel");
        this.measureFilterFld = new SearchField(SearchField.Style.FILTER);
        this.measureFilterFld.setName("measureFilterFld");
        JPanel jPanel = new JPanel();
        jPanel.setName("measuresPanel");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setName("measureScrollPane");
        jScrollPane.getViewport().add(this.measureTable);
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 5, 0));
        jPanel.add((Component)this.measureFilterFld, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 5, 0));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        n = 0;
        this.add((Component)jLabel, new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 5, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.measureFilterFld.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                CubeMeasureSelectionPanel.this.loadMeasureTable();
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
    }

    private void updateSelectAll() {
        if (this.selectedRows == this.totalRows && this.selectedRows > 0) {
            this.checkBoxHeader.setSelected(true);
        } else if (this.selectedRows < this.totalRows) {
            this.checkBoxHeader.setSelected(false);
        } else if (this.selectedRows == 0) {
            this.checkBoxHeader.setSelected(false);
        }
        this.measureTable.getTableHeader().repaint();
    }

    class CheckBoxHeader
    extends JCheckBox
    implements TableCellRenderer,
    MouseListener {
        protected CheckBoxHeader rendererComponent = this;
        protected int column;
        protected boolean mousePressed = false;

        public CheckBoxHeader() {
            this.rendererComponent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = actionEvent.getSource();
                    if (!(object instanceof AbstractButton)) {
                        return;
                    }
                    AbstractButton abstractButton = (AbstractButton)object;
                    boolean bl = abstractButton.isSelected();
                    int n = CubeMeasureSelectionPanel.this.measureTable.getRowCount();
                    for (int i = 0; i < n; ++i) {
                        CubeMeasureSelectionPanel.this.measureTable.setValueAt(new Boolean(bl), i, 0);
                    }
                }
            });
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.rendererComponent.setForeground(jTableHeader.getForeground());
                this.rendererComponent.setBackground(jTableHeader.getBackground());
                this.rendererComponent.setFont(jTableHeader.getFont());
                jTableHeader.addMouseListener(this.rendererComponent);
            }
            this.setColumn(n2);
            this.rendererComponent.setText(OLAPArb.get("MEASURE_SELECT_COLUMN"));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this.rendererComponent;
        }

        protected void setColumn(int n) {
            this.column = n;
        }

        public int getColumn() {
            return this.column;
        }

        protected void handleClickEvent(MouseEvent mouseEvent) {
            if (this.mousePressed) {
                this.mousePressed = false;
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                JTable jTable = jTableHeader.getTable();
                TableColumnModel tableColumnModel = jTable.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable.convertColumnIndexToModel(n);
                if (n == this.column && mouseEvent.getClickCount() == 1 && n2 != -1) {
                    this.doClick();
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.handleClickEvent(mouseEvent);
            ((JTableHeader)mouseEvent.getSource()).repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.mousePressed = true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

