/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubebuildprocess.buildprocbuilder;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.OLAPMetadataReader;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.templates.templatedialogimpl.TemplateHelperFactoryImpl;
import oracle.olap.cubebuildprocess.buildprocbuilder.BuildProcSyntaxParser;
import oracle.olap.cubebuildprocess.model.CubeBuildProcess;
import oracle.olap.syntaxbuilder.SyntaxBuilderPanel;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPSpec;
import oracle.olap.syntaxbuilder.olapihelpers.SyntaxBuilderLauncher;
import oracle.olap.util.OLAPErrorDisplay;
import oracle.olap.util.OLAPFetchIcon;

public class BuildProcBuilder {
    private CubeBuildProcess c;
    private SyntaxBuilderPanel builder;
    private Properties props;
    private boolean initialized = false;
    private TemplateHelperFactoryImpl thf;
    private BuildProcSyntaxParser parser;
    private OLAPSpec specParser;

    public SyntaxBuilderPanel createBuilder() throws SQLException, IOException {
        this.props = new Properties();
        this.props.setProperty("SHOW_LEAVES", Boolean.toString(false));
        this.props.setProperty("CONTEXT", "BUILDPROC");
        this.props.setProperty("VISIBLE_SYNTAXSPEC", Boolean.toString(false));
        this.props.setProperty("VISIBLE_DOCS", Boolean.toString(false));
        this.props.setProperty("CENTER_DIVIDER_POSITION", "150");
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(BuildProcBuilder.class.getResourceAsStream("buildproc.xml"), "UTF-8");
            this.parser = new BuildProcSyntaxParser(null, this.props);
            OLAPResources oLAPResources = new OLAPResources("/oracle/olap/cubebuildprocess/buildprocbuilder/buildtemplates.xml");
            OLAPFetchIcon oLAPFetchIcon = new OLAPFetchIcon();
            this.thf = new TemplateHelperFactoryImpl(this.props, null, null, this.parser, oLAPResources, oLAPFetchIcon);
            this.specParser = new OLAPSpec(this.props, inputStreamReader, this.parser, this.thf, new OLAPErrorDisplay(), oLAPResources, oLAPFetchIcon, null);
            this.builder = SyntaxBuilderLauncher.createPanelForCube(this.props, null, null, null, null, null, this.thf, this.specParser, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            OLAPErrorDisplay oLAPErrorDisplay = new OLAPErrorDisplay();
            oLAPErrorDisplay.show(unsupportedEncodingException, OLAPArb.getString("EXPRESSION_EDITOR_SPEC_ERROR_TITLE"), OLAPArb.getString("EXPRESSIONBUILDER_SPEC_ERROR_MESSAGE"), (Component)Ide.getMainWindow());
        }
        return this.builder;
    }

    public SyntaxBuilderPanel initialize(Connection connection, CubeBuildProcess cubeBuildProcess) {
        if (this.initialized) {
            return this.builder;
        }
        this.c = cubeBuildProcess;
        if (cubeBuildProcess != null) {
            this.props.setProperty("CUBE", cubeBuildProcess.getName());
            this.props.setProperty("AW", cubeBuildProcess.getAnalyticWorkspace());
            this.props.setProperty("SCHEMA", cubeBuildProcess.getSchema().getName());
            DatabaseImpl databaseImpl = new DatabaseImpl();
            databaseImpl.setConnection(connection);
            Schema schema = new Schema(this.props.getProperty("SCHEMA"));
            OLAPMetadataReader oLAPMetadataReader = new OLAPMetadataReader(databaseImpl, schema);
            try {
                oLAPMetadataReader.loadMetadata();
            }
            catch (Exception exception) {
                Logger.getLogger(BuildProcBuilder.class.getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
            this.specParser.setConn(connection);
            this.parser.setSchema(schema);
            this.thf.setSchema(schema);
            this.thf.setDatabase(databaseImpl);
        }
        this.builder.initialize();
        return this.builder;
    }
}

