/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.partition.query;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.Resources;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.app.db.RowSetCallBack;
import oracle.olap.app.olapmetadata.DimensionAWObjects;
import oracle.olap.app.table.Queries;
import oracle.olap.cube.partition.model.PartitionMemberAndCount;
import oracle.olap.cube.partition.model.PartitionQueryCancelExecuteContext;

public class CubePartitionQuery
implements RowSetCallBack {
    private Connection conn;
    private static Queries queries;
    private Resources resources;
    private boolean isInterrupted = false;
    private List<String> tooManyMemberHierarchyLevelNames;
    private List<PartitionMemberAndCount> resultsSetBreakout;
    private Object[] resultsSetSummary;
    private int activeQuery;
    private DimensionAWObjects dimensionAWObjects;
    private boolean isBusy = false;
    private static final int PARTITION_BREAKOUT_QUERY = 1;
    private static final int PARTITION_SUMMARY_QUERY = 2;

    public CubePartitionQuery(Connection connection, Resources resources, DimensionAWObjects dimensionAWObjects) {
        Object object;
        this.conn = connection;
        this.resources = resources;
        this.dimensionAWObjects = dimensionAWObjects;
        this.tooManyMemberHierarchyLevelNames = new ArrayList<String>();
        if (queries == null) {
            try {
                object = "oracle.olap.app.table";
                String string = JavaXMLBind.LoadDocument(this.getClass(), "ReportPartitionDML.xml");
                JavaXMLBind.BindToJavaStr(string, (String)object, this);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Error JavaXMLBind: " + exception, "Error", 0);
            }
        }
        object = PartitionQueryCancelExecuteContext.getInstance();
        ((PartitionQueryCancelExecuteContext)object).addCubePartitionQuery(this);
    }

    private boolean suppressRedundantError(String string) {
        boolean bl = false;
        for (String string2 : this.tooManyMemberHierarchyLevelNames) {
            if (!string.equalsIgnoreCase(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void createOrReplaceDMLReportPartitions() {
        try {
            if (!this.isExists()) {
                DatabaseUtils.ExecuteSPL(this.conn, this.getReportPartitionsDMLProgram());
            }
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(null, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.DML.ERROR.PROGRAM_CREATE.MSG") + sQLException, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.DML.ERROR.PROGRAM_CREATE.TITLE"), 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.DML.ERROR.PROGRAM_CREATE.MSG") + iOException, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.DML.ERROR.PROGRAM_CREATE.TITLE"), 0);
        }
    }

    public void createOrReplacePartitionInformationView() {
        try {
            DatabaseUtils.ExecuteSQL(this.conn, this.getPartitionOLAPTableView("SYS", "EXPRESS"));
        }
        catch (SQLException sQLException) {
            JOptionPane.showMessageDialog(null, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.ERROR.CREATE_VIEW.MSG") + sQLException, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.ERROR.CREATE_VIEW.TITLE"), 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.ERROR.CREATE_VIEW.MSG") + iOException, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.ERROR.CREATE_VIEW.TITLE"), 0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dropPartitionInformationView(String string) {
        try {
            List list = DatabaseUtils.GetViews(this.conn, string);
            if (list.size() > 0 && !list.contains("OLAP_PARTITION_INFO_VIEW")) return;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 942) return;
            JOptionPane.showMessageDialog(null, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.ERROR.DROP_VIEW.MSG") + sQLException, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.ERROR.DROP_VIEW.TITLE"), 0);
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void executeReportPartitionsProgram(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        String string5 = this.dimensionAWObjects.getAWOwner(string) + "." + this.dimensionAWObjects.getAWName(string);
        if (!this.isInterrupted) {
            List<String> list = null;
            try {
                list = this.dimensionAWObjects.getAWDimensionDeploymentObjects(string);
            }
            catch (SQLException sQLException) {
                JOptionPane.showMessageDialog(null, this.resources.getString("CUBE.PARTITION.QUERY.OBJORG.ERROR.MSG") + sQLException, this.resources.getString("CUBE.PARTITION.QUERY.OBJORG.ERROR.TITLE"), 0);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, this.resources.getString("CUBE.PARTITION.QUERY.OBJORG.ERROR.MSG") + iOException, this.resources.getString("CUBE.PARTITION.QUERY.OBJORG.ERROR.TITLE"), 0);
            }
            try {
                if (list != null) {
                    StringBuffer stringBuffer = new StringBuffer(255);
                    stringBuffer.append("call EXPRESS!report_partitions(");
                    stringBuffer.append("'" + string + "' ");
                    stringBuffer.append("'" + string2 + "' ");
                    stringBuffer.append("'" + string3 + "' ");
                    stringBuffer.append("'" + list.get(0) + "' ");
                    stringBuffer.append("'" + list.get(1) + "' ");
                    stringBuffer.append("'" + list.get(2) + "' ");
                    stringBuffer.append("'" + list.get(3) + "' ");
                    stringBuffer.append("'" + list.get(4) + "' ");
                    stringBuffer.append("'" + list.get(5) + "' ");
                    stringBuffer.append("'" + string4 + "' ");
                    if (bl) {
                        stringBuffer.append("'YES' ");
                    } else {
                        stringBuffer.append("'NO' ");
                    }
                    if (bl2) {
                        stringBuffer.append("'YES')");
                    } else {
                        stringBuffer.append("'NO')");
                    }
                    DatabaseUtils.ExecuteSPL(this.conn, stringBuffer.toString());
                    String string6 = "show EXPRESS!_REPORT_PARTITION_RET_CODE";
                    String string7 = DatabaseUtils.ExecuteSPL(this.conn, string6);
                    if (string7.equals("1000") && !this.suppressRedundantError(string2 + "." + string3)) {
                        JOptionPane.showMessageDialog(null, this.resources.getString("CUBE.PARTITION.QUERY.TOO_MANY_PARTITIONS.ERROR.MSG", string2 + "." + string3), this.resources.getString("CUBE.PARTITION.QUERY.TOO_MANY_PARTITIONS.ERROR.TITLE"), 2);
                        this.tooManyMemberHierarchyLevelNames.add(string2 + "." + string3);
                    }
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 1013) {
                    JOptionPane.showMessageDialog(null, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.ERROR.CALLING.PROGRAM.MSG") + sQLException, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.ERROR.CALLING.PROGRAM.TITLE"), 0);
                } else {
                    try {
                        DatabaseUtils.ExecuteSPL(this.conn, "aw detach " + string5);
                        DatabaseUtils.ExecuteSPL(this.conn, "aw attach " + string5 + " first rw");
                    }
                    catch (SQLException sQLException2) {
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.ERROR.CALLING.PROGRAM.MSG") + iOException, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.ERROR.CALLING.PROGRAM.TITLE"), 0);
            }
        }
    }

    public List<PartitionMemberAndCount> getPartitionCountsFromQuery(String string, boolean bl, String string2, String string3) {
        this.activeQuery = 1;
        if (!this.isInterrupted) {
            Object object = null;
            object = bl ? "select a.partition_count, b." + string3 + ",   a.partition_breakout from olap_partition_info_view a, " + string + "." + string2 + " b where a.partition_member = b.dim_key" : "select partition_count, to_char('''' || partition_member || ''''), partition_breakout from olap_partition_info_view";
            this.resultsSetBreakout = new ArrayList<PartitionMemberAndCount>();
            try {
                DatabaseUtils.ExecuteSQL(this.conn, (String)object, this);
            }
            catch (SQLException sQLException) {
                sQLException.fillInStackTrace();
                JOptionPane.showMessageDialog(null, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.ERROR.QUERYING_VIEW.MSG") + sQLException, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.ERROR.QUERYING_VIEW.TITLE"), 0);
            }
        }
        return this.resultsSetBreakout;
    }

    public Object[] getPartitionSummaryResultsFromQuery() {
        this.activeQuery = 2;
        if (!this.isInterrupted) {
            String string = "select count(partition_count),       sum(partition_count),       min(partition_count),       max(partition_count),       avg(partition_count),       stddev(partition_count) from olap_partition_info_view";
            try {
                this.resultsSetSummary = new Object[6];
                DatabaseUtils.ExecuteSQL(this.conn, string, this);
            }
            catch (SQLException sQLException) {
                sQLException.fillInStackTrace();
                JOptionPane.showMessageDialog(null, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.ERROR.QUERYING_VIEW.MSG") + sQLException, this.resources.getString("CUBE.PARTITION.QUERY.OLAP.ERROR.QUERYING_VIEW.TITLE"), 0);
            }
        }
        return this.resultsSetSummary;
    }

    @Override
    public void processRowSet(ResultSet resultSet) throws SQLException {
        if (this.activeQuery == 1) {
            long l = resultSet.getLong(1);
            String string = resultSet.getString(2);
            String string2 = resultSet.getString(3);
            this.resultsSetBreakout.add(new PartitionMemberAndCount((int)l, string, string2));
        } else if (this.activeQuery == 2) {
            long l = resultSet.getLong(1);
            long l2 = resultSet.getLong(2);
            long l3 = resultSet.getLong(3);
            long l4 = resultSet.getLong(4);
            double d = resultSet.getDouble(5);
            double d2 = resultSet.getDouble(6);
            this.resultsSetSummary[0] = new Integer((int)l);
            this.resultsSetSummary[1] = new Integer((int)l2);
            this.resultsSetSummary[2] = new Integer((int)l3);
            this.resultsSetSummary[3] = new Integer((int)l4);
            this.resultsSetSummary[4] = new Double(d);
            this.resultsSetSummary[5] = new Double(d2);
        }
    }

    public String getReportPartitionsDMLProgram() {
        String string = queries.getSQL("REPORT_PARTITIONS");
        return string;
    }

    public String getPartitionOLAPTableView(String string, String string2) {
        String string3 = String.format(queries.getSQL("PARTITION_VIEW"), string, string2);
        return string3;
    }

    public boolean isExists() throws SQLException, IOException {
        boolean bl = true;
        String string = String.format(queries.getSQL("DML_EXISTS"), "EXPRESS", "REPORT_PARTITIONS");
        List list = DatabaseUtils.ExecuteSQL(this.conn, string);
        List list2 = (List)list.get(0);
        bl = ((String)list2.get(0)).equalsIgnoreCase("1");
        return bl;
    }

    public void addQueries(Queries queries) {
        CubePartitionQuery.queries = queries;
    }

    public void update() {
        this.isInterrupted = true;
    }

    public boolean getIsInterrupted() {
        return this.isInterrupted;
    }

    public void setBusy(boolean bl) {
        this.isBusy = bl;
    }

    public boolean isBusy() {
        return this.isBusy;
    }
}

