/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.Ide;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.buildspec.BuildSpecBuilder;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeBuildCommand;
import oracle.olap.cube.model.CubeBuildSpecification;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.db.view.ChildObjectEditorPanel2;
import oracle.olap.syntax.BuildSyntax;
import oracle.olap.syntaxbuilder.SyntaxBuilderPanel;
import oracle.olapi.syntax.SyntaxException;

public class CubeBuildSpecificationEditorPanel
extends ChildObjectEditorPanel2<CubeBuildSpecification, Cube> {
    private static final Logger LOG = Logger.getLogger(CubeBuildSpecificationEditorPanel.class.getName());
    private JLabel lblName = new JLabel();
    private DBObjectProvider prov;
    private String analyticWorkspace;
    private String owner;
    private Connection conn;
    private Cube cube;
    private JCheckBox defaultCheckBox;
    private SyntaxBuilderPanel buildCommandExpressionEditorPanel;
    private String allstatDimCond;
    private JLabel lblBuildCommands = new JLabel(OLAPArb.get("BUILD.SPECIFICATION.COMMANDS.LABEL"));
    private transient BuildSpecBuilder builder;

    public CubeBuildSpecificationEditorPanel() {
        super("CubeBuildSpecificationEditorPanel", "BUILDSPECIFICATION");
        this.lblName.setName("lblName");
        this.lblBuildCommands.setName("lblBuildCommands");
        this.layoutComponents();
    }

    private void initFromBuildSpecificationData() {
        this.enableFields(true);
        String string = CubeBuildSpecification.getDefaultCubeMeasureSelection(this.cube);
        this.allstatDimCond = CubeBuildSpecification.getDefaultCubeDimensionCondition(this.cube);
        if (this.getChildObject() == null) {
            this.getNameField().setText("");
            this.buildCommandExpressionEditorPanel.setText("");
            this.enableFields(false);
        } else {
            String string2 = ((CubeBuildSpecification)this.getChildObject()).getName();
            CubeBuildCommand[] cubeBuildCommandArray = ((CubeBuildSpecification)this.getChildObject()).getBuildCommands();
            this.getNameField().setText(string2);
            String string3 = ((CubeBuildSpecification)this.getChildObject()).getSyntax();
            String string4 = null;
            if (string3 == null) {
                string4 = " ";
            } else {
                int n = string3.indexOf("(") + 1;
                int n2 = string3.lastIndexOf(")");
                string4 = string3.substring(n, n2);
            }
            this.buildCommandExpressionEditorPanel.setText(string4);
            ArrayList arrayList = new ArrayList();
            Collections.addAll(arrayList, cubeBuildCommandArray);
            for (CubeBuildCommand cubeBuildCommand : arrayList) {
                String string5;
                Object object;
                String string6 = cubeBuildCommand.getType();
                String string7 = cubeBuildCommand.getMeasureSelection();
                CubeMeasure[] cubeMeasureArray = this.cube.getMeasures();
                String string8 = this.cube.getName();
                ArrayList<CallSite> arrayList2 = new ArrayList<CallSite>();
                for (int i = 0; i < cubeMeasureArray.length; ++i) {
                    object = string8 + "." + cubeMeasureArray[i].getName();
                    arrayList2.add((CallSite)object);
                }
                if (string7 == null || string7 != null && string7.trim().length() == 0) {
                    if (string6.equalsIgnoreCase("LOAD") || string6.equalsIgnoreCase("CLEAR") || string6.equalsIgnoreCase("OLAP DML") || string6.equalsIgnoreCase("SOLVE")) {
                        string7 = string;
                        cubeBuildCommand.setMeasureSelection(string7);
                    }
                } else {
                    String[] stringArray = string7.split(",");
                    object = "";
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string9 = stringArray[i];
                        if (!arrayList2.contains(string9)) continue;
                        object = ((String)object).length() == 0 ? (String)object + string9 : (String)object + "," + string9;
                    }
                    if (((String)object).length() == 0) {
                        object = string;
                    }
                    cubeBuildCommand.setMeasureSelection((String)object);
                }
                if ((string5 = cubeBuildCommand.getDimensionCondition()) != null && (string5 == null || string5.length() != 0) || !string6.equalsIgnoreCase("CLEAR") && !string6.equalsIgnoreCase("OLAP DML") && !string6.equalsIgnoreCase("SOLVE")) continue;
                string5 = this.allstatDimCond;
                cubeBuildCommand.setDimensionCondition(string5);
            }
            boolean bl = ((CubeBuildSpecification)this.getChildObject()).isDefault();
            this.defaultCheckBox.setSelected(bl);
            if (string2 != null && string2.equalsIgnoreCase("SYS_DEFAULT")) {
                this.enableFields(false);
            } else {
                this.enableFields(true);
            }
        }
        this.validate();
        this.repaint();
    }

    private void enableFields(boolean bl) {
        this.defaultCheckBox.setEnabled(bl);
        this.lblName.setEnabled(bl);
        this.getNameField().setEnabled(bl);
        this.lblBuildCommands.setEnabled(bl);
        this.buildCommandExpressionEditorPanel.setEnabled(bl);
    }

    private void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
        this.cube = (Cube)this.getUpdatedObject();
        this.analyticWorkspace = this.cube.getAnalyticWorkspace();
        Schema schema = this.cube.getSchema();
        this.owner = schema.getName();
        this.conn = this.getConnection();
    }

    @Override
    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        Object object = this.getDataContext().get("dimensions");
        this.builder.initialize(this.getConnection(), (Cube)this.getUpdatedObject(), object);
        this.buildCommandExpressionEditorPanel.setText("");
        super.initialisePanel();
        this.initFromBuildSpecification((CubeBuildSpecification)this.getChildObject());
    }

    private Connection getConnection() {
        Connection connection = null;
        if (this.prov instanceof OracleDatabaseImpl) {
            OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.prov;
            connection = oracleDatabaseImpl.getConnection();
        }
        return connection;
    }

    public void commit(CubeBuildSpecification cubeBuildSpecification, Map<String, Object> map) {
        AbstractChildDBObject[] abstractChildDBObjectArray;
        Object object;
        String string = (String)map.get("CUBE_BUILD_SPECIFICATION_NAME_KEY");
        cubeBuildSpecification.setName(string);
        boolean bl = this.defaultCheckBox.isSelected();
        if (bl) {
            object = (Cube)this.getUpdatedObject();
            abstractChildDBObjectArray = ((Cube)object).getBuildSpecifications();
            for (int i = 0; i < abstractChildDBObjectArray.length; ++i) {
                if (abstractChildDBObjectArray[i].equals((Object)cubeBuildSpecification)) continue;
                abstractChildDBObjectArray[i].setIsDefault(!bl);
            }
        }
        cubeBuildSpecification.setIsDefault(bl);
        object = (List)map.get("CUBE_BUILD_COMMANDS_KEY");
        abstractChildDBObjectArray = new CubeBuildCommand[]{};
        cubeBuildSpecification.setBuildCommands((CubeBuildCommand[])object.toArray(abstractChildDBObjectArray));
        String string2 = (String)map.get("CUBE_BUILD_SPECIFICATION_SYNTAX_KEY");
        cubeBuildSpecification.setSyntax(string2);
    }

    public void initFromBuildSpecification(CubeBuildSpecification cubeBuildSpecification) {
        this.initFromBuildSpecificationData();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        Object object5;
        String string = this.prov.getInternalName(this.getNameField().getText());
        boolean bl = !this.getNameField().isEnabled();
        boolean bl2 = this.defaultCheckBox.isSelected();
        Cube cube = (Cube)this.getUpdatedObject();
        boolean bl3 = cube.isMVOn();
        String string2 = this.buildCommandExpressionEditorPanel.getText();
        String string3 = String.format("BUILD SPEC %s ( %s )", string, string2);
        Map<String, Object> map = null;
        String string4 = cube.getSchema().getName();
        try {
            map = BuildSyntax.getInstance().fromSyntax(string4, string3);
        }
        catch (SyntaxException syntaxException) {
            Object object2 = OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_SYNTAX_ERROR", string);
            object2 = (String)object2 + "  " + syntaxException.getLocalizedMessage();
            throw new TraversalException((String)object2);
        }
        catch (Exception exception) {
            Object object3 = OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_SYNTAX_ERROR", string);
            object3 = (String)object3 + "  " + exception.getLocalizedMessage();
            throw new TraversalException((String)object3);
        }
        String string5 = (String)map.get("CUBE_BUILD_SPECIFICATION_NAME_KEY");
        string = this.prov.getInternalName(string5);
        List list = (List)map.get("CUBE_BUILD_COMMANDS_KEY");
        try {
            this.prov.validateName("BUILDSPECIFICATION", string);
        }
        catch (InvalidNameException invalidNameException) {
            Object object4 = OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_NAME_ERROR", string);
            object4 = (String)object4 + "  " + invalidNameException.getMessage();
            throw new TraversalException((String)object4);
        }
        if (string.equalsIgnoreCase("SYS_DEFAULT") && !bl) {
            throw new TraversalException(OLAPArb.get("CUBE_VALIDATE_BUILDSPECS_SYS_DEFAULT_NAME_ERROR"));
        }
        if (BuildSyntax.getInstance().isKeyword(string)) {
            String string6 = OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_RESERVED_WORD_NAME_ERROR", string);
            throw new TraversalException(string6);
        }
        if (bl2 && bl3 && !string.equalsIgnoreCase("SYS_DEFAULT")) {
            throw new TraversalException(OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_DEFAULT_NAME_ERROR", string));
        }
        List list2 = list;
        int n = list2.size();
        if (n == 0) {
            throw new TraversalException(OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_NO_COMMAND_ERROR", string));
        }
        for (Object object5 : list2) {
            String string7;
            String string8 = object5.getType();
            if (!string8.equalsIgnoreCase("OLAP DML") && !string8.equalsIgnoreCase("PLSQL") || ((string7 = object5.getExpression()) == null || string7.trim().length() != 0) && string7 != null) continue;
            if (string8.equalsIgnoreCase("OLAP DML")) {
                throw new TraversalException(OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_OLAPDML_COMMAND_ERROR", string));
            }
            throw new TraversalException(OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_PLSQL_COMMAND_ERROR", string));
        }
        super.commitPanel();
        CubeBuildSpecification cubeBuildSpecification = (CubeBuildSpecification)this.getChildObject();
        this.commit(cubeBuildSpecification, map);
        object5 = cubeBuildSpecification.getName();
        if (object5 != null && ((String)(object5 = ((String)object5).trim())).length() > 0 && cube.getBuildSpecification((String)object5) == null) {
            cube.addBuildSpecification(cubeBuildSpecification);
        }
    }

    private void layoutComponents() {
        this.setName(this.getClass().getName());
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.setBasePath(new String[]{"buildSpecifications"});
        componentFactory.registerComponent(this.lblName, (Component)this.getNameField(), UIBundle.get((String)"COLUMN_INFO_LABEL_NAME"), "Name", "name");
        this.builder = new BuildSpecBuilder();
        try {
            this.buildCommandExpressionEditorPanel = this.builder.createBuilder();
        }
        catch (Throwable throwable) {
            LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
        }
        this.getNameField().setColumns(30);
        this.defaultCheckBox = new JCheckBox(OLAPArb.get("BUILD.SPECIFICATION.DEFAULT.LABEL"));
        this.defaultCheckBox.setName("defaultCheckBox");
        this.defaultCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CubeBuildSpecificationEditorPanel.this.cube.isMVOn()) {
                    CubeBuildSpecificationEditorPanel.this.defaultCheckBox.setSelected(false);
                    String string = null;
                    String string2 = CubeBuildSpecificationEditorPanel.this.prov.getInternalName(CubeBuildSpecificationEditorPanel.this.getNameField().getText());
                    String string3 = OLAPArb.format("CUBE_VALIDATE_BUILDSPECS_DEFAULT_NAME_ERROR", string2);
                    String string4 = OLAPArb.get("BUILD_SPECIFICATION_ERROR_TITLE");
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)string4, string);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(OLAPArb.get("BUILD.SPECIFICATION.PROPERTIES.LABEL")));
        int n = 0;
        this.add(this.lblName, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.getNameField(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.defaultCheckBox, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.getBuildCommandsPanel(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
    }

    private JPanel getBuildCommandsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setName("buildCommandPanel");
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.lblBuildCommands, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.buildCommandExpressionEditorPanel, gridBagConstraints);
        return jPanel;
    }
}

