/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import java.util.Arrays;

public class nls_national_character_set
extends Check {
    public nls_national_character_set() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.UNIVERSAL);
        this.setDeclarativeResult(CheckResult.WARNING);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String targetNationalCharSet = exeCtx.getAnalysisProperty(TargetInstanceProp.NLS_NCHAR_CHARACTERSET.getKey(), "AL16UTF16");
        String sqlQueryMain = "SELECT VALUE SOURCE_NCHAR, '" + targetNationalCharSet + "' TARGET_NCHAR FROM NLS_DATABASE_PARAMETERS WHERE PARAMETER = 'NLS_NCHAR_CHARACTERSET' AND VALUE != '" + targetNationalCharSet + "'";
        this.setSqlQuery(sqlQueryMain);
    }
}

