/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.KeyStroke;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.util.NodeCustomizer;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.bali.xml.util.XmlSingleSelectionAction;
import org.w3c.dom.Node;

public class XmlCustomizeAction
extends XmlSingleSelectionAction {
    private static final String _PROPERTIES_KEY = "Properties";

    public XmlCustomizeAction() {
        super(null, KeyStroke.getKeyStroke(10, 0), "customizeNode");
        this.putValue("XmlContext.MUTATES_MODEL", Boolean.TRUE);
        this.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        NodeCustomizer customizer;
        XmlKey key;
        Node n;
        if (!this.isEnabled()) {
            return;
        }
        this.setEnabled(false);
        AbstractModel model = this.getModel();
        XmlModel baseModel = model.getBaseModel();
        XmlMetadataResolver resolver = baseModel.getXmlMetadataResolver();
        final XmlContext context = baseModel.getContext();
        boolean onward = false;
        model.acquireReadLock();
        try {
            n = XmlCustomizeAction._getBaseModelNode(model, this._getTargetNode(event));
            if (n != null) {
                key = resolver.getNodeXmlKey(n);
                customizer = XmlModelUtils.getCustomizerOrDefault(baseModel, key, n);
                onward = customizer != null && customizer.isNodeCustomizable(context, n, key) && !resolver.isImmutable(n);
            } else {
                customizer = null;
                key = null;
            }
        }
        finally {
            model.releaseReadLock();
        }
        try {
            XmlModelUtils.setModalDialogRunning(true);
            if (onward) {
                new FixedNameTransactionTask(String.valueOf(this.getValue("Name"))){

                    @Override
                    protected void performTask(AbstractModel ignoredParam) throws XmlCommitException {
                        boolean ok = customizer.customizeNode(context, n, key);
                        if (!ok) {
                            this.cancelTask();
                        }
                    }
                }.run(model);
                this.setEnabled(true);
            }
        }
        finally {
            XmlModelUtils.setModalDialogRunning(false);
        }
    }

    private Node _getTargetNode(ActionEvent event) {
        if (event.getSource() instanceof Node) {
            return (Node)event.getSource();
        }
        AbstractModel model = this.getModel();
        return model.getSelection().getFirstSelectedNode();
    }

    public static final boolean isNodeCustomizable(AbstractModel model, Node node) {
        boolean enabled = false;
        XmlModel baseModel = model.getBaseModel();
        Node baseModelNode = XmlCustomizeAction._getBaseModelNode(model, node);
        if (baseModelNode != null) {
            NodeCustomizer customizer;
            XmlKey key = baseModel.getNodeXmlKey(baseModelNode);
            XmlMetadataResolver resolver = baseModel.getXmlMetadataResolver();
            if (key != null && (customizer = XmlModelUtils.getCustomizer(baseModel, key, baseModelNode)) != null) {
                enabled = customizer.isNodeCustomizable(model.getContext(), node, key) && !resolver.isImmutable(node);
            }
        }
        return enabled;
    }

    private static Node _getBaseModelNode(AbstractModel model, Node node) {
        if (model instanceof XmlView) {
            return ((XmlView)model).viewToModel(node);
        }
        return node;
    }

    @Override
    protected boolean isEnabledImpl(Node node) {
        return XmlCustomizeAction.isNodeCustomizable(this.getModel(), node);
    }

    @Override
    protected void updateName(Node node, boolean enabled) {
        if (this.getModel() == null) {
            this.putValue("Name", null);
        } else {
            Object[] args;
            if (enabled && node != null) {
                XmlMetadataResolver resolver = this.getModel().getXmlMetadataResolver();
                args = new String[]{resolver.getMediumDisplayName(node)};
            } else {
                args = new String[]{""};
            }
            String actionName = this.getModel().getTranslatedString(_PROPERTIES_KEY);
            this.putValue("Name", MessageFormat.format(actionName, args));
        }
    }
}

