/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.message;

import java.util.Map;
import java.util.logging.Level;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.message.MessageCategory;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.validator.ValidationException;
import oracle.javatools.status.Severity;
import org.w3c.dom.Node;

public class ValidationExceptionMessage
extends XmlModelMessage {
    private final ValidationException _ex;
    private final Level _level;

    public ValidationExceptionMessage(XmlModel model, ValidationException ex, Level level) {
        super(model);
        this._ex = ex;
        this._level = level;
    }

    @Override
    public MessageCategory getCategory() {
        return MessageCategory.GRAMMAR_VALIDITY;
    }

    @Override
    public Level getLevel() {
        return this._level;
    }

    @Override
    public String getShortDescription() {
        return this._ex.getLocalizedMessage();
    }

    @Override
    public String getLongDescription() {
        Object longDescription = this.getShortDescription();
        Exception cause = this._ex.getException();
        if (cause != null) {
            longDescription = (String)longDescription + "\n\n" + cause.getLocalizedMessage();
        }
        return longDescription;
    }

    @Override
    public Node getRelatedNode() {
        return this._ex.getInvalidNode();
    }

    @Override
    public Object getCause() {
        return this._ex;
    }

    @Override
    public String getMessageTypeImpl() {
        return this._ex.getTypeString();
    }

    @Override
    public Map<String, Object> getParameters() {
        return this._ex.getParameters();
    }

    @Override
    public Severity getSeverity() {
        if (this._ex.displayAsIncompleteSeverity()) {
            return Severity.INCOMPLETE;
        }
        return super.getSeverity();
    }

    @Override
    public boolean couldBeResolvedByAddingNodes() {
        return this._ex.couldBeResolvedByAddingNodes();
    }
}

