/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.awt.Component;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.MappedEditorFactoryInfo;
import oracle.bali.xml.gui.base.inspector.AbstractAttributeValueItemPropertyEditor;
import oracle.bali.xml.gui.base.inspector.AttributeValueItemPropertyEditor;
import oracle.bali.xml.gui.base.inspector.AttributeValueItemRenderer;
import oracle.bali.xml.gui.base.inspector.editors.EditorUtils;
import oracle.bali.xml.util.AttributeValueItem;
import oracle.bali.xml.util.AttributeValueItemProvider;
import oracle.bali.xml.util.ContextualAttributeValueItemProvider;

final class ComboBoxSupport {
    private ComboBoxSupport() {
    }

    public static EditorComponentInfo getComboBoxInfo(AttributeValueItemPropertyEditor propEditor) {
        Vector<AttributeValueItem> peItems = propEditor.getAttributeValueItems();
        if (!ComboBoxSupport._needComboBox(propEditor)) {
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(5);
        properties.put(MappedEditorFactoryInfo.MODEL, ComboBoxSupport._getComboBoxModel(propEditor, peItems));
        properties.put(MappedEditorFactoryInfo.RENDERER, ComboBoxSupport._getRenderer(propEditor));
        properties.put(MappedEditorFactoryInfo.TO_STRING_CONVERTER, propEditor.getRow().getStringConverter());
        return EditorUtils.createEditorComponentInfo(MappedEditorFactoryInfo.COMBO_BOX, properties);
    }

    private static Object _getInitialSelection(AttributeValueItemPropertyEditor propEditor) {
        Object initialSelection = !propEditor.__isRowSet() ? (propEditor.isConstrainedToEnumeration() ? propEditor.getNoneItem() : null) : propEditor.getAsText();
        return initialSelection;
    }

    private static ListCellRenderer _getRenderer(AttributeValueItemPropertyEditor propEditor) {
        return new DelegatingListCellRenderer(propEditor);
    }

    private static ComboBoxModel _getComboBoxModel(AttributeValueItemPropertyEditor propEditor, Vector<AttributeValueItem> peItems) {
        AVIComboModel model = new AVIComboModel(propEditor.isConstrainedToEnumeration(), propEditor.getNoneItem(), peItems);
        ((DefaultComboBoxModel)model).setSelectedItem(ComboBoxSupport._getInitialSelection(propEditor));
        return model;
    }

    private static boolean _needComboBox(AttributeValueItemPropertyEditor propEditor) {
        boolean canOverrideBase = false;
        String id = propEditor.__getBaseEditorComponentIdentifier();
        if (id != null) {
            if (id.equals(MappedEditorFactoryInfo.COMBO_BOX) || id.equals(MappedEditorFactoryInfo.TEXT_FIELD)) {
                canOverrideBase = true;
            }
        } else {
            canOverrideBase = true;
        }
        return !propEditor.getAttributeValueItems().isEmpty() && canOverrideBase;
    }

    private static final class DelegatingListCellRenderer
    implements ListCellRenderer {
        private final AbstractAttributeValueItemPropertyEditor _propEditor;
        private final AttributeValueItemRenderer _default_renderer;

        public DelegatingListCellRenderer(AbstractAttributeValueItemPropertyEditor propEditor) {
            this._propEditor = propEditor;
            this._default_renderer = new AttributeValueItemRenderer();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ListCellRenderer<Object> cellRenderer = null;
            if (value instanceof AttributeValueItem) {
                AttributeValueItem item = (AttributeValueItem)value;
                cellRenderer = this._getCustomListCellRenderer(item);
            }
            if (cellRenderer == null) {
                cellRenderer = this._default_renderer;
            }
            return cellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }

        private ListCellRenderer _getCustomListCellRenderer(AttributeValueItem item) {
            ContextualAttributeValueItemProvider cavip = this._propEditor.getCavip();
            if (cavip != null && cavip.hasCustomRenderer()) {
                return cavip.getCustomListCellRenderer(item);
            }
            AttributeValueItemProvider avip = this._propEditor.getAvip();
            if (avip != null && avip.hasCustomRenderer()) {
                return avip.getCustomListCellRenderer(item);
            }
            return null;
        }
    }

    private static class AVIComboModel
    extends DefaultComboBoxModel {
        private final boolean _isConstrainedToEnumeration;
        private final Object _noneItem;

        public AVIComboModel(boolean isConstrainedToEnumeration, Object noneItem, Vector<AttributeValueItem> items) {
            super(items);
            this._isConstrainedToEnumeration = isConstrainedToEnumeration;
            this._noneItem = noneItem;
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject instanceof String) {
                String str = anObject.toString();
                int size = this.getSize();
                for (int i = 0; i < size; ++i) {
                    AttributeValueItem item = (AttributeValueItem)this.getElementAt(i);
                    if (!AttributeValueItemPropertyEditor.__equalsSelectedValue(item, str)) continue;
                    anObject = item;
                    break;
                }
            } else if (anObject == null) {
                if (this._isConstrainedToEnumeration) {
                    anObject = this._noneItem;
                }
            } else if (!(anObject instanceof AttributeValueItem)) {
                throw new IllegalArgumentException("tried to set selection of invalid type: " + anObject);
            }
            super.setSelectedItem(anObject);
        }
    }
}

