/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.whitespace;

import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceMode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WhitespaceHandler {
    private static final String _sSPACE = "space";
    private static final String _sXML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final WhitespaceHandler _sDEFAULT_HANDLER = new WhitespaceHandler();

    public static WhitespaceHandler getDefaultWhitespaceHandler() {
        return _sDEFAULT_HANDLER;
    }

    public void beginCacheablePeriod() {
    }

    public void endCacheablePeriod() {
    }

    public WhitespaceMode getElementContentWhitespaceMode(TreeTraversal traversal, Element element) {
        String xmlSpaceValue;
        if (traversal == null) {
            traversal = DocumentTreeTraversal.INSTANCE;
        }
        WhitespaceMode specifiedMode = null;
        Attr xmlSpaceAttr = element.getAttributeNodeNS(_sXML_NAMESPACE, _sSPACE);
        if (xmlSpaceAttr != null && (xmlSpaceValue = xmlSpaceAttr.getValue()) != null) {
            if ("preserve".equals(xmlSpaceValue = xmlSpaceValue.trim())) {
                specifiedMode = WhitespaceMode.MODE_PRESERVE;
            } else if ("default".equals(xmlSpaceValue)) {
                specifiedMode = WhitespaceMode.MODE_COLLAPSE;
            }
        }
        return this.getElementContentWhitespaceModeImpl(traversal, element, specifiedMode);
    }

    public WhitespaceMode getAttributeContentWhitespaceMode(TreeTraversal traversal, Element owningElement, String attrNamespace, String attrLocalName) {
        return WhitespaceMode.MODE_REPLACE;
    }

    public final WhitespaceMode getAttributeContentWhitespaceMode(TreeTraversal traversal, Element owningElement, Attr attr) {
        return this.getAttributeContentWhitespaceMode(traversal, owningElement, attr.getNamespaceURI(), DomUtils.getLocalName((Node)attr));
    }

    public final WhitespaceMode getAttributeContentWhitespaceMode(TreeTraversal traversal, Attr attr) {
        return this.getAttributeContentWhitespaceMode(traversal, attr.getOwnerElement(), attr);
    }

    protected WhitespaceMode getElementContentWhitespaceModeImpl(TreeTraversal traversal, Element element, WhitespaceMode specifiedMode) {
        if (specifiedMode != null) {
            return specifiedMode;
        }
        if (traversal == null) {
            traversal = DocumentTreeTraversal.INSTANCE;
        }
        return WhitespaceMode.MODE_PRESERVE;
    }

    protected WhitespaceHandler() {
    }
}

