/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.versioning;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.proxy.GrammarProviderProxy;
import oracle.bali.xml.metadata.AggregateMetadataProvider;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.grammar.GrammarMetadataProvider;
import oracle.bali.xml.metadata.proxy.MetadataProviderProxy;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.event.XmlModelAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class VersionManager<E extends Enum<E>> {
    private XmlContext _context;
    private E _currentVersion = this.getDefaultVersion();
    private GrammarProviderProxy _grammarProvider;
    private MetadataProviderProxy _metadataProvider;
    private MetadataProvider _aggregateMetadataProvider;
    private static final Logger _LOGGER = Logger.getLogger(VersionManager.class.getName());

    public VersionManager() {
    }

    public VersionManager(XmlContext context) {
        this();
        this._context = context;
    }

    public final E getCurrentVersion() {
        return this._currentVersion;
    }

    public final GrammarProvider getGrammarProvider() {
        if (this._grammarProvider == null) {
            GrammarProvider gProvider = this.createGrammarProvider(this._currentVersion);
            if (gProvider == null) {
                throw new IllegalStateException("Null GrammarProvider returned for version: " + this._currentVersion);
            }
            this._grammarProvider = new GrammarProviderProxy(gProvider);
        }
        return this._grammarProvider;
    }

    public final MetadataProvider getMetadataProvider() {
        if (this._metadataProvider == null) {
            MetadataProvider mdProvider = this.createMetadataProvider(this._currentVersion);
            if (mdProvider == null) {
                throw new IllegalStateException("Null MetadataProvider returned for version: " + this._currentVersion);
            }
            this._metadataProvider = new MetadataProviderProxy(mdProvider);
        }
        if (this._aggregateMetadataProvider == null) {
            ArrayList<Object> mdProviders = new ArrayList<Object>();
            mdProviders.add(this._metadataProvider);
            mdProviders.add(new GrammarMetadataProvider(this._context.getGrammarResolver()));
            this._aggregateMetadataProvider = AggregateMetadataProvider.create(mdProviders);
        }
        return this._aggregateMetadataProvider;
    }

    public final QualifiedName getVersionQualifiedName(QualifiedName prototype) {
        return this.getVersionQualifiedNameImpl(prototype, this.getCurrentVersion());
    }

    public final QualifiedName getVersionQualifiedName(QualifiedName prototype, E version) {
        E testVersion = version;
        if (testVersion == null) {
            testVersion = this.getCurrentVersion();
        }
        return this.getVersionQualifiedNameImpl(prototype, testVersion);
    }

    public void attachToModel(XmlModel model) {
        model.addModelListener(new VersionManagerModelListener());
    }

    public abstract E getDefaultVersion();

    public abstract void initRootForVersion(Element var1, E var2);

    public void setContext(XmlContext context) {
        this._context = context;
    }

    protected QualifiedName getVersionQualifiedNameImpl(QualifiedName prototype, E version) {
        return prototype;
    }

    protected XmlContext getContext() {
        return this._context;
    }

    protected void notifyVersionChanged(E oldVersion, E newVersion) {
    }

    protected abstract E getVersion(Document var1);

    protected abstract GrammarProvider createGrammarProvider(E var1);

    protected abstract MetadataProvider createMetadataProvider(E var1);

    private class VersionManagerModelListener
    extends XmlModelAdapter {
        private VersionManagerModelListener() {
        }

        @Override
        public void listenerAttached(XmlModelEvent event) {
            this.modelChanged(event);
        }

        @Override
        public void modelChanged(XmlModelEvent event) {
            Document doc;
            if (event.isDomTreeChanged() && (doc = event.getModel().getDocument()) != null) {
                Object localVersion = VersionManager.this.getVersion(doc);
                if (localVersion == null) {
                    _LOGGER.log(Level.WARNING, "GetVersion for the document returned null, using the default version.");
                    localVersion = VersionManager.this.getDefaultVersion();
                }
                if (VersionManager.this._currentVersion != localVersion) {
                    VersionManager.this.notifyVersionChanged(VersionManager.this._currentVersion, localVersion);
                    VersionManager.this._currentVersion = localVersion;
                    if (VersionManager.this._metadataProvider != null) {
                        MetadataProvider mdProvider = VersionManager.this.createMetadataProvider(VersionManager.this._currentVersion);
                        if (mdProvider == null) {
                            throw new IllegalStateException("Null MetadataProvider returned for version: " + VersionManager.this._currentVersion);
                        }
                        VersionManager.this._metadataProvider.changeUnderlyingMetadataProvider(mdProvider);
                    }
                    if (VersionManager.this._grammarProvider != null) {
                        GrammarProvider gProvider = VersionManager.this.createGrammarProvider(VersionManager.this._currentVersion);
                        if (gProvider == null) {
                            throw new IllegalStateException("Null GrammarProvider returned for version: " + VersionManager.this._currentVersion);
                        }
                        VersionManager.this._grammarProvider.changeUnderlyingGrammarProvider(gProvider);
                    }
                }
            }
        }
    }
}

