/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.extension;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.worksheet.extension.WorksheetURLFileSystemHelper;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;

public class WorksheetNode
extends TextNode {
    public static final String EXT = ".worksheet";
    private static final Logger LOGGER = Logger.getLogger(WorksheetNode.class.getName());
    private static ScheduledExecutorService s_exec;
    private String m_connName;
    private ScheduledFuture<?> m_saver;
    private boolean m_dirty;

    private static String getDisplayName(WorksheetNode worksheetNode) {
        return URLFileSystem.getPlatformPathName((URL)worksheetNode.getURL());
    }

    public WorksheetNode() {
        this(null);
    }

    public WorksheetNode(URL uRL) {
        super(uRL);
    }

    public String getConnectionName() {
        return this.m_connName;
    }

    public void setConnectionName(String string) {
        this.m_connName = string;
        WorksheetURLFileSystemHelper.updateDisplayName(this.getURL(), string);
        UpdateMessage.fireObjectRenamed((Subject)this);
    }

    public String getShortLabel() {
        return WorksheetNode.getDisplayName(this);
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        this.m_connName = null;
    }

    private class Saver
    implements Runnable {
        private Saver() {
        }

        @Override
        public void run() {
            WorksheetNode.this.writeLock();
            try {
                WorksheetNode.this.m_saver = null;
                WorksheetNode.this.save();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            finally {
                WorksheetNode.this.writeUnlock();
            }
        }
    }
}

