/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.retry;

import java.io.Serializable;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.retry.RetryState;
import oracle.cloudstorage.util.Throwables;

public class RetryException
extends Exception {
    private static final long serialVersionUID = 125525959335125866L;
    private final IReply.Context context;

    public RetryException(IReply.Context context, String message, Throwable cause) {
        super(message, cause);
        this.context = context;
    }

    public IReply.Context getContext() {
        return this.context;
    }

    public RetryState getRetryState() {
        return this.context == null ? null : this.context.getRetryState();
    }

    @Override
    public String getMessage() {
        String message = super.getMessage() + "\n" + this.context.buildDetailedMessage();
        return message;
    }

    public final boolean wasCausedBy(Class<? extends Throwable> ... causeClasses) {
        for (Throwable cause = this; cause != null; cause = cause.getCause()) {
            Class<?> throwableClass = cause.getClass();
            for (Class<? extends Throwable> causeClass : causeClasses) {
                if (!causeClass.isAssignableFrom(throwableClass)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isSuppressing(Class<? extends Throwable> ... suppressedClasses) {
        boolean suppressing = RetryException.isSuppressing(this, suppressedClasses);
        return suppressing;
    }

    public static boolean isSuppressing(Throwable throwable, Class<? extends Throwable> ... suppressedClasses) {
        Class<?> throwableClass = throwable.getClass();
        for (Class<? extends Throwable> clazz : suppressedClasses) {
            if (!clazz.isAssignableFrom(throwableClass)) continue;
            return true;
        }
        if (RetryException.isSuppressing(throwable.getCause(), suppressedClasses)) {
            return true;
        }
        for (Serializable serializable : Throwables.getSuppressed(throwable)) {
            if (!RetryException.isSuppressing(throwable, suppressedClasses)) continue;
            return true;
        }
        return false;
    }
}

