/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.inspector.DisplayGroupPanel;
import oracle.ide.inspector.DisplayGroupPanelFactory;
import oracle.ide.inspector.Orientation;
import oracle.ide.inspector.Properties;
import oracle.ide.inspector.RenderingUtils;
import oracle.ide.inspector.layout.Choice;
import oracle.ide.inspector.layout.ChoiceGroup;
import oracle.ide.inspector.layout.ChoiceSelector;
import oracle.ide.inspector.layout.DisplayGroup;
import oracle.ide.inspector.layout.Element;

final class ChoiceGroupPanel
extends JPanel {
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel cardPanel = new JPanel(this.cardLayout);
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final Box choiceBox = Box.createHorizontalBox();
    private final Map<String, JPanel> panels = new HashMap<String, JPanel>();
    private final ChoiceSelector selector;
    private String selectedChoiceId;
    private boolean hasContent;
    private GridBagConstraints constraints;

    ChoiceGroupPanel(ChoiceGroup choiceGroup, Properties properties, Orientation orientation) {
        super(new BorderLayout());
        this.selector = choiceGroup.getChoiceSelector();
        this.cardPanel.setVisible(true);
        this.add((Component)this.choiceBox, "First");
        this.add(Box.createVerticalStrut(5), "Last");
        this.add((Component)this.cardPanel, "Last");
        this.render(choiceGroup, properties, orientation);
    }

    private void render(ChoiceGroup choiceGroup, Properties properties, Orientation orientation) {
        for (Element child : choiceGroup.getChildren()) {
            if (!this.isChoice(child)) continue;
            this.addChoice((Choice)child, properties, orientation);
        }
    }

    private boolean isChoice(Element e) {
        return e instanceof Choice;
    }

    private void addChoice(Choice choice, Properties properties, Orientation orientation) {
        boolean hasContent = false;
        ArrayList<Element> currentDisplayGroup = null;
        JPanel choicePanel = new JPanel(new GridBagLayout());
        this.constraints = RenderingUtils.initialConstraints();
        for (Element child : choice.getChildren()) {
            if (!(child instanceof DisplayGroup)) {
                if (currentDisplayGroup == null) {
                    currentDisplayGroup = new ArrayList<Element>();
                }
                currentDisplayGroup.add(child);
                continue;
            }
            hasContent = hasContent || this.addDisplayGroupToPanel(currentDisplayGroup, choicePanel, properties, orientation);
            currentDisplayGroup = null;
            hasContent = hasContent || this.addDisplayGroupToPanel((DisplayGroup)child, choicePanel, properties, orientation);
            ++this.constraints.gridy;
        }
        hasContent = hasContent || this.addDisplayGroupToPanel(currentDisplayGroup, choicePanel, properties, orientation);
        this.constraints.gridy = -1;
        this.constraints.gridheight = 0;
        this.constraints.gridwidth = 0;
        this.constraints.weighty = 1.0;
        choicePanel.add(Box.createVerticalGlue(), this.constraints);
        boolean bl = this.hasContent = this.hasContent || hasContent;
        if (hasContent) {
            this.addChoice(choice.getID(), choice.getTitle(), choicePanel, properties);
        }
    }

    private boolean addDisplayGroupToPanel(List<Element> displayGroup, JPanel panel, Properties properties, Orientation orientation) {
        if (displayGroup == null) {
            return false;
        }
        DisplayGroupPanel displayGroupPanel = DisplayGroupPanelFactory.createDisplayGroupPanel(displayGroup, properties, orientation);
        return this.addDisplayGroupPanel(displayGroupPanel, panel);
    }

    private boolean addDisplayGroupToPanel(DisplayGroup displayGroup, JPanel panel, Properties properties, Orientation orientation) {
        if (displayGroup == null) {
            return false;
        }
        DisplayGroupPanel displayGroupPanel = DisplayGroupPanelFactory.createDisplayGroupPanel(displayGroup, properties, orientation);
        return this.addDisplayGroupPanel(displayGroupPanel, panel);
    }

    private boolean addDisplayGroupPanel(DisplayGroupPanel displayGroupPanel, JPanel parent) {
        if (!displayGroupPanel.hasContent()) {
            return false;
        }
        parent.add((Component)displayGroupPanel, this.constraints);
        ++this.constraints.gridy;
        return true;
    }

    private void addChoice(String id, String title, JPanel choicePanel, Properties properties) {
        choicePanel.setBackground(this.getBackground());
        choicePanel.setName(id);
        this.panels.put(id, choicePanel);
        JRadioButton choice = this.newChoice(id, title, properties);
        if (this.buttonGroup.getButtonCount() == 0) {
            choice.setSelected(true);
            this.refresh(choicePanel);
        }
        this.add(choice);
    }

    private JRadioButton newChoice(final String id, String title, final Properties properties) {
        JRadioButton choice = new JRadioButton(title);
        choice.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ChoiceGroupPanel.this.panels.containsKey(id)) {
                    return;
                }
                try {
                    ChoiceGroupPanel.this.notifyChoiceSelector(id, properties);
                }
                catch (PropertyVetoException pve) {
                    return;
                }
                ChoiceGroupPanel.this.refresh(ChoiceGroupPanel.this.panels.get(id));
            }
        });
        choice.setBackground(this.getBackground());
        return choice;
    }

    private void refresh(JPanel panel) {
        String id = panel.getName();
        this.cardPanel.add((Component)panel, id);
        this.cardLayout.show(this.cardPanel, id);
        this.selectedChoiceId = id;
    }

    private void notifyChoiceSelector(String activatedChoiceId, Properties properties) throws PropertyVetoException {
        if (this.selector == null) {
            return;
        }
        this.selector.onDeactivate(properties.model(), this.selectedChoiceId);
        this.selector.onActivate(properties.model(), activatedChoiceId);
    }

    private void add(JRadioButton choice) {
        this.buttonGroup.add(choice);
        this.choiceBox.add(choice);
        this.choiceBox.add(Box.createHorizontalStrut(8));
    }

    boolean hasContent() {
        return this.hasContent;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        for (Component c : this.getComponents()) {
            if (!(c instanceof DisplayGroupPanel) && !(c instanceof ChoiceGroupPanel)) continue;
            c.setBackground(bg);
        }
    }
}

